META
key;value
description;District PB in Warszawa, Ursus
country;Poland
unit;Warszawa
district;Ursus
subunit;Ursus
instance;2024
num_projects;55
num_votes;4235
budget;2434251
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
336;380000;2278;Bezpieczny Ursus - uzupełniamy dziury w sieci dróg rowerowych;public transit and roads,sport;children,seniors;1;52.191033400792456;20.89254140853882
287;64500;2260;Zielony Ursus - duże drzewa przy dzielnicowych ulicach;public transit and roads,environmental protection,urban greenery;children,seniors;1;52.19459577869587;20.882303790420533
34;322750;2142;Bezpieczny Ursus - zadbajmy o bezpieczeństwo pieszych na przejściach;public transit and roads;children,seniors;1;52.19508453832921;20.87789654731751
481;486000;1630;Park Achera – rewitalizacja alejek;public space,urban greenery;children,seniors;1;52.195560274509766;20.895695686340336
478;87000;1619;Kwiaty w Ursusie;environmental protection,public space,urban greenery;children,seniors;1;52.19398904545455;20.88809370909091
1111;61330;1540;Aleja drzew w ciągu ulicy Skoroszewskiej;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.186959419735956;20.896543264389038
1176;156000;1311;Zielone przystanki w Ursusie w rejonie ul. Dzieci Warszawy;environmental protection,public space,urban greenery;children,seniors;1;52.193582433333326;20.9029263
926;98000;1270;Ursusiaki - rzeźby niedźwiadków w Ursusie;education,culture,public space;children,seniors;1;52.19458989101438;20.883282423019413
47;45500;1183;Bezpłatne zajęcia fitness w Ursusie – fit to nie mit;sport;children,seniors;1;;
524;96000;1103;Plenerowe wieczory muzyczne w Ursusie;education,culture,public space;children,seniors;1;52.19762785811621;20.887644767499296
19;158000;1048;Oświetlenie w alejce przy boisku OSiR;public transit and roads,public space;children,seniors;1;52.18452446667762;20.88981628417969
1170;84525;1035;Dzieci Warszawy w kwiatach;environmental protection,public space,urban greenery;children,seniors;1;52.1935572;20.9037768
236;50000;1026;Nowości wydawnicze w Bibliotece;culture;children,seniors;1;;
781;485000;932;Radarowe wyświetlacze prędkości - Buźki w Ursusie;public transit and roads,public space;children;0;52.19420961158882;20.882576465606693
517;28868;910;Zielony zakątek przy ul. Dzieci Warszawy 11;environmental protection,public space,urban greenery;children,seniors;1;52.19082882499026;20.912547111074677
958;100000;908;Mobilne mini boisko wielofunkcyjne w OSiR Ursus;public space,sport;children,seniors;1;52.1867809;20.88945775
148;457800;892;Lepszy chodnik na Regulskiej;public transit and roads;children,seniors;0;52.1896648;20.8755271
946;330000;884;Słoneczna energia w SP2 – montaż instalacji fotowoltaicznej.;education,environmental protection,public space,sport,urban greenery;children,seniors;0;52.200862929155065;20.869339763298008
765;100000;842;Wiata przystankowa na pętli autobusowej dla linii 194, przy stacji PKP Gołąbki.;public transit and roads,public space;children,seniors;1;52.207727646289634;20.86356925938162
203;23000;839;Pętle indukcyjne dla osób niedosłyszących w placówkach kultury;culture,welfare,public space;children,seniors;1;;
525;30000;830;Schodołaz dla niepełnosprawnych w Domu Kultury Portiernia;culture,public space;children,seniors;1;;
271;250000;804;Remont placu zabaw przy Szkole Podstawowej nr 381;education,public space,sport;children;0;52.187321600000004;20.88802888087946
135;430000;800;Rewitalizacja części placu zabaw przy ulicy Bony;culture,environmental protection,public space,sport,urban greenery;children;0;52.19898564371416;20.860826969146732
819;410000;782;Modernizacja placu zabaw przy Szkole Podstawowej nr 4;education,public space,sport;children;0;52.19266325;20.895869325268706
269;56000;758;Strefa relaksu przy Szkole Podstawowej nr 381;education,public space,urban greenery;children,seniors;1;52.187321600000004;20.88802888087946
766;25340;755;Róże zamiast błota. Rewitalizacja trawnika przy ulicy Konotopskiej.;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.20712409049781;20.86614418003592
101;460000;754;Letnie koncerty i potańcówki międzypokoleniowe w Ursusie;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;52.191692065732276;20.885381698171845
216;326350;748;Książkomat w Ursusie;culture;children,seniors;0;52.1918267;20.911355
270;11000;687;Wiosenna łąka kwietna z roślin cebulowych przy Szkole Podstawowej nr 381;education,public space,urban greenery;children,seniors;0;52.187321600000004;20.88802888087946
102;39000;682;Wyprzedaże garażowe w Ursusie (Park Czechowicki);education,culture,welfare;children,seniors;0;52.19149530309347;20.885667800685045
767;480000;681;Bezpieczne boiska przy SP2;education,public space,sport;children,seniors;0;52.20049495843744;20.868890762067167
483;96600;680;Kwiaty na okrągło, czyli rewitalizacja zieleni na rondzie im. Jana Cierlińskiego oraz dosadzenie roślin cebulowych na rondzie im. E. Malessy ‘Marcysi’;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.19756972157288;20.88113712750244
948;306000;680;Remont szatni przy hali sportowej w SP2.;education,culture,public space,sport;children,seniors;0;52.20096813945646;20.869381674073935
570;60000;679;Nagłośnienie i oświetlenie sceniczne dla Domu Kultury Portiernia;education,culture;children,seniors;0;52.19772428036121;20.887949466705326
31;26500;631;Bajkowy Arsus;culture;children;0;;
979;12000;562;Kawiarenka niespodzianek;education,culture;seniors;0;52.190719753948024;20.88912963867188
1329;65000;553;Ursus dla gości i turystów - przewodnik kulturalny po dzielnicy i pamiątki;education,culture,public space;children,seniors;0;52.19763837976284;20.887155532836918
21;36000;548;Wyprzedaże garażowe w Parku Achera;culture,public space;children,seniors;0;52.19569303611686;20.89560985565186
46;6000;513;Zakup koła garncarskiego dla Pracowni Ceramicznej Domu Kultury Kolorowa;culture;children,seniors;1;;
1092;224000;511;Szlagiery w Ursusie - cykl koncertowy ( W. Malicki, Zespół Raz Dwa Trzy, Grupa MoCarta i inni);education,culture;children,seniors;0;52.19874315565676;20.890460014343265
711;170941;507;Traktory w dożynkowym korowodzie;education,culture,public space;seniors;0;52.199784776508245;20.876212120056156
239;30000;497;Buduj, ćwicz pamięć i trenuj cierpliwość – warsztaty z lego;culture;children,seniors;0;;
759;68000;493;Spotkania z muzyką klasyczną - uczniowskie koncerty w Parku Czechowickim;education,culture;children,seniors;0;52.19185799779845;20.88481664657593
816;47160;493;Szkoła przedsiębiorczości w Ursusie;education;seniors;0;52.1910218;20.8888752
1303;74000;492;Akcja profilaktyczno-edukacyjna Dobrze mówię, bo dobrze słyszę;education;children;0;52.194564525000004;20.881969515189013
235;17000;458;Multimedialny dywan – nauka i zabawa poprzez ruch;culture;children;0;52.1962001;20.869256098751297
959;30000;451;Stół do teqball na terenie OSiR Ursus;sport;children,seniors;0;52.1867809;20.88945775
1652;65000;414;Zajęcia z papierowej wikliny dla Szkół Podstawowych w Ursusie;education,culture,environmental protection;children;0;52.194005706249996;20.88345939874861
956;30000;383;Traktorkowo Na Sportowo - Piknik dla przedszkolaków;education,culture,public space,sport;children,seniors;0;52.1867809;20.88945775
219;10455;365;Pętla indukcyjna w Bibliotece;culture;;0;;
220;12000;352;Rodzinne warsztaty języka migowego;culture;children,seniors;0;;
237;30000;349;Warsztaty Świąteczne w Bibliotece;culture;children,seniors;0;;
535;49500;329;Potańcówki …ale z klasą;education,culture;seniors;0;;
969;47160;324;Czas dla młodych (duchem) - Eko Festiwal Tańca i Sportu 2024;education,culture,environmental protection,sport;children,seniors;0;52.1913112;20.8859332
201;7500;256;Z grafiką na Ty - podstawy digitalpaintingu;education,culture;children,seniors;0;;
VOTES
voter_id;vote;age;sex
10;781,148,34;27;M
12;1111,47;18;F
29;570,819,19,34,781,946;31;M
43;46,47;35;F
50;570,336,926,711,203,979,481,958,216,135;40;M
60;269,270,271;48;M
74;766,765;40;F
78;524,525,219,816,336,203,481,237,958,269,220,236,271,46,47;46;F
79;766,765;3;F
81;766,765;;M
90;237,216,236,46,478,766,946,767,34,765,1303,1329,979,135,781;38;F
99;524,766,946,767,948,287,34,765,19,336,135;34;F
107;135,926,570,948,781,959,102;26;M
124;336,203,958,148,948,34,765,219;29;M
145;711,819,287,948,148,781,271,766,765,958,135;36;M
150;101,239,766,478,767,31,781,948,287,956,1303,235,336,926,237;38;F
195;481,819,781,767,946,220,101,1111,478,948,287,1329,336,135,216;21;M
203;287,956,34,336,926,481;36;M
207;946,1176,1170,1111,287,517,336,269,216,483;45;F
211;765,47,570,926,711,481,269,135,946,767,271,948,1652,19,819;43;F
220;946,148,287,34,219,816,517,336,926,711,203,481,958,269,483;38;M
233;517,481,819,979,216,781,1111,271,1170,1176,287,34,1329,336,135;40;F
264;819,47,525,765,271,478,236,102,946,767,948,1652,287,34,336;36;F
274;525,47,819,926,287,34,19,517,336,958,1176,1170,1111,478,481;42;M
280;220,1176,759,287,765,517,570,203,483,525,1092,336,481,958,135;28;F
281;270,101,1176,1170,478,287,524,481;47;F
283;148,1329,816,517,336,926,481,483,1176,1170,1111,478,287,34,765;44;M
285;46,148,765,219,819,336,269,946,236,948,287,34;31;F
295;766,287,926,481,959,478,767,948,956,765,19,47,239,135,336;43;F
303;31,287,336,926;26;M
321;517,336,816,819,19,948,271,767,478,959,102,1176,958,34,287;29;M
326;236,46,34,235,1092,535,101,201,959,1329,524,47,816,979,958;35;F
328;946,239,1176,767,948,34,765,1303,235,47;37;F
332;270,946,1176,102,781,956,765,47,336,203,979,148,287,34,481;31;M
339;819,958,135,216,481,926,219,765,1652,946,767,948,287,34,336;36;M
340;270,969,236,478,767,271,948,287,34,819,336,481,237,269;31;F
346;270,1176,1111,336,958,269,271;43;M
354;979,236,478,524,47,926,216;28;F
360;766,1176,1170,1111,478,46,287,34,517,336,481;28;F
370;239,336,711,958,946,101,102,969,478,31,781,948,287,956,34;34;F
403;946,767,948;40;M
408;781,1176,148,766,478,34,517,481,483,1170,1111,287,21,336;26;M
409;781,287,34;39;F
412;34;37;M
416;525,47,336,711,481,958,478;33;F
423;481,958,926,517,819,524,1329,19,148,766,1111,781,287,34,336;30;M
429;216,336,47,958,1329,235,19,1303,34,781,767,478,1176,946,287;27;F
433;101,236,31,148,287,956,34;30;F
448;478,19,926,766,239,201,236,287,34,1303,235,1329,47,816,336;30;M
453;765,711,958,216,483,766,1170,478,135,481;32;M
459;517,483,1111,478,148,287,34,336;26;M
498;102,236,1111,759,956,34,19,524,219,47,517,336,216,711,926;35;M
511;478,767,781,148,287,34,19,711,958;34;M
515;766,478,287,524;26;F
522;481,483,135,956,148,767,271,969,1176,101,478,287,34,19,336;29;M
526;946,948;43;F
529;948,946,269;44;M
535;946,767,948,47;73;M
539;946,948;12;F
567;236,766,148,216,781,31,287,34,524,570,336;32;M
590;481,483,270,19,336,959,1111,236,102,1176,271,781,287,34,269;43;F
594;819,271,336,767,1176,946,781,235,525,219,481,958,34,483,287;31;F
605;237,483,101,220,959,31,47,239,1652,956,34,1303,235,816,926;44;F
644;239,959,525,237,270,946,1176,1111,478,287,517,336,926,203,269;34;F
678;926,203,958,269,483,766,1176,1170,1111,478,148,34,19,336,287;29;F
689;478,781,287,34,135;39;F
691;1111,148,287,19;41;F
694;1176,46,219,203,517,481,946,1170,1111,478,781,287,524,47,336;36;M
701;711,216,237,47,525,956,236,102,969,31,148,759,1329,570,926;31;F
711;766,478,781,287;29;M
732;948,765,19,517,336,481,135,1111,478,271,781,46,287,34,819;26;F
741;19,1652,781,31,478,236,239,946,767,948,287,34,336,926,711;31;F
745;46,781,148,19,336,926,481,958,216,1176,1170,478,287,34,517;43;F
747;1303,524,535,203,481,135,483,766,1176,1170,1111,478,287,34,336;30;M
759;958,236,102,287,34,21,336,926,481,478,1111,1170,1176,47,517;20;F
778;1176,946,239,236,767,31,759,948,1652,287,765,235,525,336,481;34;F
803;767,271,781,948,34,19,47,819,336,481,958;34;M
804;101,781,287,34,1329,525,570,979;32;F
810;481,102,759,31,478,1111,1170,1176,239,101,956,34,287,524,926;34;F
830;1111,101,220,239,46,135,946,969,767,948,287,524,525;39;F
854;1176,148,765,1329,481,478,287,34,336,926;29;F
855;270,101,102,236,959,958,481,525,148,271;16;F
870;946,478,767,948,34,336;38;F
913;956,235,819,816,336,926,481,483,135,946,236,478,31,287,34;35;F
933;270,102,271,235,269;38;F
939;220,287,34,1303,47,336,203,958,946,767,948;34;F
952;946,948;41;F
954;766,1176,1111,765,235,237,946,767,781,948,287,34,19,336,926;32;F
978;135;23;F
979;1176,1111,478,148,287,956,34,235,524,47,517,336,979,216,483;30;F
982;948,767,1170,1176,946,1111,478,781,34,287,765,819,336,926,481;26;M
993;766,946,101,959,271,34,19,524,336,481,483;36;M
1004;1111,781,958,483,135,1176,946,525,336,203,481,1303,34,287,216;40;F
1010;19,1092,336,926,481,958,1652,478,1170,101,1176,1111,781,34,819;42;F
1020;135;25;F
1023;969,959,1176,270,946,781,336,481,269,1170,1111,46,34,517,287;27;F
1055;946,1111,781,34,765,926,958,478,287,956,524,336,711,203,979;30;M
1084;102,336,287;29;F
1089;478,287,34,336;34;F
1106;102,31,1652,956,34,19,481,958;40;F
1137;956,979,269,270,1111,483,481,235,766,946,1170,478,287,34,336;31;F
1151;1170,781,570,711,481,483,1176,1111,478,148,287,34,524,336;35;M
1162;203,819,781,481,135,946,1176,31,336,979,483,759,287,34,524;31;F
1169;1176,1111,781,287,34,524,47,816,336;43;F
1186;148,336,269,271;34;F
1204;102,236,287,34,21,336;39;M
1212;1176,765,19,926,203,517,525,1170,34,219,819,570,236,1111,287;47;F
1223;148,759,948,19,216,959,236,336,958;28;M
1228;1176,1170,1111,148,219,926,481,216,483,236,478,287,524,336;31;F
1291;270,959,271,781,336,711,269;43;M
1335;483,1329,765,287,148,478,1111,1170,1176,101,946,336,926,481,958;19;M
1340;478,236,101,524,1092,570;34;F
1350;946,767,271,1652,287,819,948;46;F
1367;946,287,956,34,21,765,235,1329,47,336,926,979,958,269,216;58;M
1376;765,1111,101,946,21,524;33;F
1403;819,269,1170,336,483,1111,478,34,287;31;M
1414;336,570,19,34,956,759,31,767,478,236,239,946,948,1652,287;42;F
1426;517,1329,956,31,478,1170,1176,102,1111,21,819,336,711,203,481;32;F
1428;219,524,781,220,239,31,1652,1303,235,47,336,711,203,237,216;35;F
1469;481,287,34,524,336;33;M
1475;1111,478,34,287;34;M
1482;517,219,148,46,1111,287,203,958,135,483,946,34,525,816,336;29;F
1483;816,570,336,481,979,237,135,19,216,21,101,287,926;36;F
1544;483,948,767,946,34,926,766,781,478,765,287,135;32;F
1590;481,135,766,236,34,336;41;M
1606;220,31,46,524;44;F
1613;926,483,287,478,517,570,135,34,336,481;39;F
1619;765,47,819,236,946,1176,1170,1111,478,148,287,34,21,336,19;23;M
1620;102,767,271,148,948,958,1170,478,1176,1111,34,19,819,336,481;39;M
1665;236,239,946,478,767,31,759,948,1652,287,1303,570,336,237,135;8;M
1681;959,148,34,336,958,269;36;F
1683;148,336,958,270,766,1170,1176,781,517,483,1111,478,287;42;M
1689;148,135,766,1111,478,781,287,34,21,765,19,819,517,336,481;30;F
1694;946,102,781,948,235,525,570,926,203,481,135;38;M
1710;481,926,570,1329,34,239,101,478,31,781,287,524,525,47,336;31;F
1715;926,203,135,483,969,236,478,781,765,1303,1329,525,816,711,481;27;F
1717;336,959,958,956;44;F
1736;270,269,271;39;F
1757;287,34,816,237,767,781,948,956,47,336;36;F
1761;969,270,959,271,148,1092,336,958,269;39;F
1786;766,220,239,1170,1111,21,19,816,478,287,34,524,47,336,926;29;F
1797;102,31,135,1111,47;69;F
1800;781,478,31,759,524,819,336,203,269,135,1176,481,19,287,34;31;M
1811;1176,270,31,148,34,19,819,336,481,958,269,946,236,959,271;30;F
1827;1652,1303,219,47,517,958,135,220,101,969,524,525,816,203,216;32;F
1860;946,766,148,781,959,767,101,969,271,948,47,819,336,958,135;29;F
1865;946,969,1303,19,135,478,781,948,287,34,765,336;46;M
1866;525,535,203,1170,1111,959,478,781,759,956,34,336,926,481,958;48;M
1873;47,711,237,483,216,239,236,478,31,287,956,34,235,926,979;31;F
1881;711,524,1303,34,759,236,946,478,767,31,948,1652,287,570,336;3;M
1890;767,239,1652,34,1303,1329,524,336,926,946,948;70;M
1901;956,946,478,767,948,1652,287,34,1303,570,336,711,481,237,135;44;M
1912;767,34,765,946,948;41;F
1922;483,525,19,34,946,1176,236,1111,271,46,148,287,765,336,481;35;F
1925;1176,1170,1111,478,767,781,148,34,19,47,819,336,481;34;M
1945;216,483,766,1111,478,767,271,948,47,135,269,819,336,287,34;28;F
1960;1329,287,759,781,31,478,148,34,765,47,819,570,336,481,237;69;F
1963;1329,19,1303,21,1176,781,287,34,765,481,926,336,570,517,1111;28;F
1964;767,946,287,135,34;39;M
1994;781,926,481,958,216,270,1111,478,271,287,34,336,269,956,148;32;F
2041;524,1092,203,216,767,1111,1176,102,46,235,47,819,926,481,958;43;F
2042;101,969,959,46,235,524,47,570,483,1170,478,287,34,336,481;41;F
2055;34,525,816,570,203,481,959,271,19,47,46,1652,336;47;F
2097;34,816,336,481,1111,287;37;M
2114;101,1111,148,759,287,956,34,524,47,819,816,336;30;F
2140;525,219,203,1176,524,946,570,336,926,711,481,34,287,31,239;38;M
2189;203,481,483;43;F
2233;102,236,34,21,524,219,47,336,711,979,958,237,216;35;F
2240;101,1176,478,781,148,19,517,958,34,287,1111,336,926,711,481;24;F
2274;969,759,220,236,271,46,34,525,47,819,816,336,203,481,269;47;M
2281;237,269,969,220,711,219,525,46,236,1176,979,524,102,759,478;35;F
2286;926,535,525,524,34,287,1652,781,271,1111,1170,1176,101,239,946;44;M
2287;759,781,478,969,101,236,271,34,524,525,47,481,269,216;67;F
2294;781,946,336,216,481,517,524,1652,1176,101,1170,34,926,1111,287;42;F
2314;946,767,287,271,781,948,34,235,819,517,336,481,958,269,135;36;M
2320;525,47,926,481,135,948,767,478,1176,766,946,287,34,765,336;36;M
2325;766,270,1176,1111,478,287;33;F
2337;46,47;69;F
2343;135,21,47,336,483,766,270,1176,1170,1111,478,148,287,517,481;34;F
2388;270,1176,1111,287,765,517,336,481;36;F
2417;220,236,1111,525,47,570,711;33;F
2430;1092;48;F
2468;19,34,959,1170,766,270,1176,102,478,1329,570,336,711,979,148;42;F
2507;31,759,287,34,19,47,570,336,203,958,481,270,271,148,269;38;M
2523;766,946,478,781,287,34;31;F
2539;958,483,819,525,19,767,959,478,148,47,1092,336,481;25;M
2557;946,766,270,1176,1170,1111,478,271,287,19,517,336,481,958,269;51;M
2584;203,336,816,47,525,524,34,287,759,46,271,236,969,101,220;18;F
2632;1176,959,781,948,34,765,235,219,819,481,135,236,336,203,958;34;M
2645;781,767,236,1176,239,19,34,948,220,959,956,765,1329,203,958;49;F
2666;816,336,237,135,216,220,101,969,236,46,34,525,47,203,269;20;M
2684;524,958,483,478,287,34;33;F
2755;766,765,336;39;M
2770;1111,287,34,47,19,336,979,481,958,270,271,269,135;37;F
2818;517,958,135,766,34,765,336;47;M
2840;1176,1170,1111,956,21,1303,19,235,1329,524,47,517,926,711,481;40;F
2842;946,287,478,101,969,237,46,47;50;F
2879;524,535,711,481,1170,101,478,31,46,1652,47,1092,819,336,926;35;F
2888;483,236,271,336,979,269,766,270,1176,1170,1111,478,287,517,481;47;F
2903;765,766;59;F
2916;270,1176,478,31,148,1652,102,271,47,336,269;34;F
2933;1170,1176,946,236,1111,478,767,948,287,34,21,765,47,517,135;38;F
2977;781,287,34,765,19,1329,269,270,271,1303,819,570,946,767,948;46;F
3021;478,1111,1170,1176,946,766,517,148,958,19,481;19;M
3044;766,220,21,1303,19,1329,525,1092,570,481,269,270,102,271,216;51;M
3045;239,102,236,959,31,1652,34,21,47,819,336,481,958,237,269;39;F
3104;766,148,1329,525,570,336,926;39;M
3122;219,525,203,766,220,1176,1170,1111,478,148,287,34,765,336,926;31;F
3195;958,481,926,524,19,948,478,766,946,767,781,765,135,216;34;M
3209;969,236,781,34,524,525,219,535,336,203,481,216,46,47,1092;49;F
3216;819,483,767,1176,270,766,1170,1111,478,287,34,19,524,336,481;32;F
3269;478,287,34,1329,524,47,926,711,216,203,1111,959,46,336,958;44;F
3272;483,766,220,148,34,336,958,101,203;43;F
3312;216,816,1329,478,1111,1170,1176,220,781,46,34,21,336,926,481;15;M
3423;766,270,1170,102,1111,478,525,517,483,47,287;28;F
3450;102,21;36;M
3456;1170,781,926,711,269,34,524,819,570,236,1111,148,481,287,336;44;M
3458;481,483,766,287,34,765,336;36;M
3459;270,220,101,236,478,524,336,216,47,1092,535,570;61;F
3537;765,781,766,1111,148,1176,946,478,46,34,47,135,336,287;36;F
3549;101,287,1303,524,535,269,481,979,216,47,46;27;F
3681;34,21,237,102,220,101,201,969,524,47,1092,535,711,979,135;36;F
3774;979,483,766,1176,1111,959,287,34,19,525,517,958,270,269,271;39;F
3837;969,31,19,1329,1092,570,711,481,237,1652,101,287,524,336,926;39;F
3888;21,34,287,1170,1111,781,524,47,926,958;46;F
3889;31,287,765,1329,524,1092,535,517,570,926,203,979,481,237,483;28;F
3910;926,711,203,481,216,220,101,201,102,236,148,34,47,535,979;34;F
3961;270,102,478,271,1652,34,19,524,336,269;43;F
3967;271,781,34,765,19,819,958,135,946,1176,236,767,948,336,216;47;F
3975;1111,270,102,483,481,336,781,766,946,201,148,478,21,287,34;25;M
4020;766,946,948,287,135;34;F
4031;946,525,759,236,1111,287,34,19,570,336,926,481,958;40;M
4034;270,1111,235,525,517,570,766,1170,478,148,287,34,336,926,483;50;M
4087;478,767,271,148,948,956,34,765,336,958,781,236,216;33;M
4100;19,525,816,481,135,781,34,765,1329,711;30;M
4197;767,31,1170,201,816,979,765,946,948,19,1329,47,958,481,959;34;M
4208;31,148,336,979,216;47;F
4265;34,336;33;F
4272;1111,287,34;28;F
4333;287,34,21,19,336;64;M
4364;148,135;34;M
4392;270,271,1652,269;35;F
4397;270,271,269;41;M
4414;1303,235,525,219,47,570,711,203,269,216,1176,478,336,287,148;36;F
4422;1170,1176,1111,478,31,148,19,483,336,236,271,287,34,819,481;36;M
4434;1176,1111,478,781,135,766,236,287,34,19,958,946,767,948,765;42;F
4451;959,271,19,269;40;M
4457;19,478,1170,946,1092,570,926,34,287,31,102,481,237;50;M
4526;235,517,19,819,481,959,1170,1176,269,781,271,1111,287,926,958;41;F
4561;711,979,535,816,219,524,1329,21,287,1652,781,34,1303,570,336;41;F
4562;959,236,969,1176,101,270,239,271,287,34,524,47,517,979,269;38;F
4607;948,946;12;F
4629;816,19,765,781,969,1176,1170,1111,759,287,1329,524,336,926,979;33;F
4637;1111,478,1652,287;33;F
4642;235,336,711,958,135,21,767,102,946,948;30;F
4691;946,948;10;F
4694;101,102,1111,287,21,19,1329,926,958,269,47;42;M
4707;101,766,478,781,956,235,336,481,483,269,1176,287,239,31,34;26;F
4719;767,270,271,148,269,135;28;M
4779;956,34,239,478,31,287,1303,765,21,47,926,711,979,237,135;44;F
4817;47,34,287,1170,478,759,524,535,481,926,979,236,1176,101,1111;29;F
4821;220,237,239,236,235,219,216;42;F
4830;1176,101,969,236,781,34,19,524,525,47,570,336,979,481,216;47;F
4837;102,959,478,767,271,948,483,19,34,31,336,926;45;F
4850;958,926,34,287,31,235,219,819,517,216;43;M
4873;524,1176,1170,236,478,31,287,956,34,765,235,711,481,237,135;37;F
4880;336,47,524,19,765,46,959,236,1176,101,239,478,34,287,148;27;F
4921;481,979,336,535,1092,524,34,287,478,1111,1170;30;F
5013;271,19,958,269;38;F
5018;1329,47,766,946,767,31,948,21,765,1092,336,926,711,979,135;51;F
5027;19;28;M
5067;31,287,203,481,216,219,525,46,148,946,1176,34,19,336,21;23;M
5069;19,1329,819,517,711,481,237,483,148,948,765,47,336,926,135;38;F
5073;102,1111,287,19,1329,570,216,766,236,478,34,21,765,336,926;42;M
5074;19;27;M
5100;236,969,1176,101,31,46,759,956,781,287,34,19,958,959;37;M
5112;1176,1170,1111,478,271,781,287,956,819,517,336,926,711,481,958;33;M
5115;816,47,1303,765,34,287,271,236,1170,239,766,336,203,979;46;F
5120;1111,481,517,1170,1176;26;M
5135;34,525,216,237,766,101,969,236,478,31,1652,235,524,47,819;35;F
5138;270,1176,1111,271,287,19,958,269;42;F
5162;959,271,46,34,21,235,525,219,47,517,336,203,269;44;F
5180;524,759,46,959,969,1170,1176,101,239,946,270,517,336,481,958;41;F
5181;287;31;F
5277;959,271,19,47,819,958,287,270,269;42;F
5280;31,235,524,711,336,1092,47,34,287,478,270,271,19,819,269;59;F
5310;336,570,819,19,34,46,767,959,201,101,102,1111,21,47,1092;41;F
5346;101,270,959,819,570,1111,478,148,287,19,47,336,926,481,958;47;F
5353;270,271,269,287,1111;46;F
5363;19;47;M
5376;270,525,269,946,767,271,781,948,34,765,19,819,336,958,135;58;M
5413;270,148,765,47,926,481,216,102,478,781,287,34,21,1329,336;45;F
5434;1176,1170,1111,517,481;52;F
5451;481,819,148,766,287,34,517,336;33;M
5491;216,269,481,1170,101,102,21,524,47;37;F
5502;270,1176,102,1111,148,287,21,19,1329,517,979,481;32;M
5514;101,34,524,336;35;F
5560;1329,525,570,711,203;36;F
5583;236,781,287,31,524,336;31;F
5592;47,46;30;F
5650;711,19;63;M
5664;148,766,269,270,34,1329,336,1111,478,287,524,517,926,481,483;32;F
5667;819,336,517;47;M
5672;101,270,766,926,203,958,269,216,525,19,478,781,287,34,524;31;M
5691;336,570,525,287,31,270,946,478,781,1329,816,101,102,765,766;60;F
5694;481,926,1329,781,478,1111,148,34,336;29;M
5706;948,19,1329,1176,1170,1111,34,47,517,946,478,148,287,336,926;26;F
5764;1176,524,1092,759,31,969,1170,237,216,101,102,236,34,21,481;36;F
5785;270,1176,1170,102,236,1111,478,781,287,34,21,1303,47,481,216;45;F
5794;948,287,34,19,524,525,219,816,570,237,216,135,766,765,336;34;F
5808;148,101,1176,1170,1111,478,287,34,524,47,481,483;49;F
5811;19;26;F
5815;969,478,524,1092,535,483,101,287,34,336;26;F
5838;220,135,946,969,959,767,765,926,979,958,236,287,1303,525,336;48;F
5877;336,135,34;33;M
5904;220,239,1176,201,102,1111,236,959,287,235,525,47,570,336,46;40;F
5906;220,946,239,236,767,948,1652,956,765,1303,235,1329,336,926,711;31;F
5923;766,1170,102,1111,478,781,148,287,34,336;30;F
5995;220,287,524,816,203,979;27;F
5997;34,781,1176;31;M
6001;766,220,236,31,759,34,1303,525,219,570,926,203,237;67;M
6004;270,271,269,148;37;F
6035;239,1303,926,235,34,31;36;F
6040;287,570,34;40;M
6046;478,781,148,759,287,34,19,1329,524,336,958,269,216;39;F
6085;19,1092,483,101,270,236,271,287,34,47,336,979,958,269;65;F
6099;34,148;32;M
6114;270,478,271,956,19,524,481,958,269;29;F
6131;1111,31,287,19,819,336,481,270,271,269;37;M
6133;236,1329,570,216;44;M
6145;759,948,34,765,1329,1092,816,535,481,958,237,269,216,483,135;61;F
6168;102,101;25;M
6197;481,478,1111,102,336,271,269,21;34;M
6202;517,1170,102,31,759,926,239,478,781,46,1652,21,47,336,481;37;F
6206;270,271,148,19,269;34;F
6209;19;45;M
6238;948,959,956,765,958;24;M
6254;336,271,270,766,1176,1170,1111,287,34,21,819,517,926,481,483;35;F
6273;1092,570,711,481,270,102,271,287,34,21,269;41;M
6302;766,270,1170,1111,287,1176,478,47,336,926,979;25;F
6303;101,102,236,524,237;39;F
6323;287,46,31,766,946,1176,1111,767,271;19;F
6465;478,781,287,34,765,525,47,570,336,926,148;31;M
6470;148,956,21,235,336;39;M
6473;819,535,481,269,135,711,524,1303,34,956,759,239,31,1652,47;34;F
6503;1176,1111,478,767,781,948,287,34,765,524,47,1092,135,570,336;61;F
6527;1111,236,1176,766,946,481,767,781,948,287,34,525,1092,135,336;57;F
6541;1176,1170,1111,478,148,34,287;22;F
6550;236,201,1176,946,1111,287,19,525,819,517,336,203,958,269,135;20;F
6573;766,220,946,1176,767,781,46,948,287,765,1329,816,336,481,926;16;M
6581;34,148;30;F
6593;759,481,524,959,958,969,46,535,570,483,31,47,336,287,478;29;F
6604;958,336,819,767,271,948,956,47,959,135;38;F
6606;969,1176,101,946,270,1170,1111,478,287,34,524,819,517,336,481;26;F
6610;287;44;M
6667;946,287,34,765,336;37;M
6706;766,959,478,148,481,336,765,34,287,135;31;M
6711;926,481,270,946,1176,478,271,948,148,19,1111,287,34,336,483;45;M
6760;1170,21,19,336,1176,1111,478,148,287,34;28;M
6766;483,969,766,270,1176,1170,1111,287,34,21,819,517,336,926,481;36;M
6779;287,781,766,946,767,948,34,765,135;41;F
6781;1176,1170,969,1111,478,46,759,1652,287,34,524,1092,535,336,203;40;F
6821;969,766,239,102,1111,1652,287,19,47,958,220,236,478,765,926;43;F
6845;766,270,946,478,148,287,34,19,819,481,483,1176,1170,1111;30;F
6850;766,47,287,781,1176,1170,1111,148,34,524,517,336,926,481;24;M
6856;946,1111,767,948,34,336,958;44;F
6881;271,535,336,269,239,101,765,1329,524,926,711,979,958,135;29;F
6891;47,926,979,481,270,1176,1170,959,478,287,34,19,517,336,958;47;F
6893;220,201,478,46,287,34,336;43;F
6962;766,270,1176,1170,1111,271,287,34,21,819,517,336,926,481,483;1;M
6965;102,781,21,47,1092,336,481,979;63;F
6997;926,219,31,1111,236,478,781,287,1092,535,711,979,481,958,237;37;M
7003;220,102,34,21,19;21;F
7015;946,767,959,1111,948,34,19,336,958;11;M
7016;271,148,948,34,19,47,819,336,203,269,216;41;F
7061;946,46,765,19,535,336,203,979;22;F
7087;102,1111,959,34,765,336,481,958,483,239,1176,236,287,19,216;23;F
7091;270,102,478,781,287,956,34,21,1303,47,1092,336,481,483;41;F
7152;31,46,1329,47,201,236,1111,287,336,926,711,216,570,525,765;18;M
7162;236,1170,766,483,926,517,47,148,46,201,1111,478,287,34,336;26;M
7164;239,102,781,1652,34,21,765,1329,47,1092,570,926,711,979,135;46;M
7166;766,21,1111,287,34,517,336,926,481;24;M
7224;235,1303,956,759,478,271,1111,1176,31,287,819,517,926,269,135;31;F
7260;766,287,759,148,781,271,767,1111,236,946,948,34,765,336,135;39;F
7274;270,271,148,269,19;7;F
7278;1329,524,525,219,47,816,570,203,979,216,765,336,926,711,958;13;M
7299;21,219,958;36;F
7309;270,287,956,1176,269,1111,271;35;F
7340;220,239,47,336,237;34;F
7350;336;27;M
7381;959,946,1176,34,765,525,819,816,766,271,148,1111,287,19,336;33;F
7383;946,102,21,765,19,1092,336,926,711,979,481,958,135,483,216;35;M
7386;946,767,948,47,1092,816,535,336,135;42;F
7422;524,759,148,101,270,102,271,269;68;F
7443;816,481,135,765,570,336,946,767,948,287,34;42;M
7458;711,926,517,47,148,959,946,1111,767,781,287,34,19,336,958;18;F
7470;481,270,766,1176,1170,1111,478,759,287,34,525,219,517,336,203;28;F
7492;237,201,239,236,102,46,759,21,524,525,570,336,979,216,47;53;F
7537;270,478,759,979,101,1176,1170,1111,287,524,1092,535,517,336,926;38;F
7550;969,1176,766,926,524,525,219,517,220,1111,478,1303,203,979,481;45;F
7553;525,524,1329,19,34,287,148,271,767,478,959,1111,236,1176,336;42;M
7554;21,1303,19,235,524,816,570,711,481,269,135,102,525,336,203;53;F
7566;711,47,34,956,1652,781,31,101,759,235,524,1092,570,336,958;33;M
7571;969,1176,1170,236,1111,478,31,287,34,219,517,336,926,481,237;43;F
7573;958,1176,1111,478,31,148,956,34,19,47,270,101,336,269,271;34;F
7579;1176,270,101,271,31,148,948,34,19,524,819,336,481,958,269;35;M
7628;946,948;45;F
7636;481,958,483,766,946,270,1176,1170,1111,478,287,524,525,47,517;26;F
7657;31,271,767,478,959,1111,969,101,946,34,524,816,535,336,926;39;F
7746;1652,766,767,135,946,101,46,948,816,535;44;F
7748;481,219,765,287,203,47,1329,525,926,46,478,236,34,336,135;41;F
7753;148,287,34,47,336,979;31;F
7756;766,270,102,478,781,287,34,765,19,47,816,336,958,135;40;M
7761;270,271,148,269;47;M
7775;1176,47,336,481,958;48;F
7792;46,781,102,101,1176,1111,478,287,34,19,47,711,926,336,483;15;M
7824;34,979;73;F
7830;946,948;39;F
7832;816,236,239,478,781,1652,287,336,926,237,483,102,34,21,135;47;F
7842;239,979,481,216,1170,271,1652,287,19,1329,819,336,958,269,135;12;M
7847;31,781,34,1303,336,926,1652,201,478,524,525,203,481,483,135;55;M
7854;102,236,21,19,958;16;F
7872;336,819,236,478,1176,946,287,34;34;M
7893;21,1329,525,47,570,102,236,478,287,34,765,336,926,711,481;44;M
7895;1329,819,481,483,517,765,478,1176,946,1111,148,287,34,19,336;23;M
7973;219,19,47,711,203,979,524,570,926,101,478,481,336,34,287;63;M
7985;336,1176,765,481,1111,767,271,19,819,135,946,781,148,287,34;34;M
7988;34,956,759,969,102,101,478,31,781,287,524,47,570,336,711;43;F
7991;969,781,287,236,235,524,525,31,481,34,47,819,336,216,135;30;F
7999;766,1176,1111,478,287,34,21,765,1329,336,481,135;44;M
8006;269,483,767,946,766,270,1176,956,1170,969,236,478,1111,271,287;38;M
8018;766,478,148,287,34,765,235,1329,524,47,336,926,711,269,135;29;F
8035;1176,1170,478,148,525,216,203,979,101,236,287,34,19,524,336;28;F
8046;237,269,336,816,235,236,201,271;39;F
8053;767,271,478,236,1176,270,1170,102,1111,287,34,19,926,711,481;33;M
8079;269,483,220,101,1111,271,46,524,535,336,216,1176,287,1092,481;31;F
8094;1176,102,1111,148,765,19,47,336;41;F
8142;959,46,570,958,926;36;M
8151;34,1111,1176,766,102,287,21,765,1329,524,336,926,979,478,135;31;F
8154;135,483,148,46,1170,201,101,239,270,765,19,47,336,481,958;25;M
8193;31,46,148,336,525,203,483,219,236,781,478,287,34,765,926;37;M
8213;1652,759,781,1170,101,946,220,336,237,236,34,219,711,203,216;59;F
8223;236,270,220,946,767,31,948,1652,34,235,47,336,926,237,135;40;F
8255;1170,1176,270,766,478,759,287,34,765,235,336,926,203,481,135;28;F
8273;781,201,1176,239,220,236,1111,959,34,816,481,958,269,271,19;43;F
8285;219,525,958,203,148,34,765,336;39;F
8339;926,765,1652,1170,946,1111,959,767,271,148,1329,1092,336,958,1176;35;M
8351;766,135,239,956,765,235,926;33;F
8377;271,46,19,525,570,203,946,1111,767,1652,948,287,34,336,481;42;F
8387;570,101,220,1170,102,478,781,287,34,525,219,517,336,203,481;41;F
8442;766,946,767,781,948,287,34,765,336,135;45;F
8448;946,270,781,524,47,535,269,34,478,101,102,21,517,336,481;58;F
8457;946,948;40;M
8466;1176,101,270,946,767,948,287,765,524,525,819,570,336,269,135;46;F
8539;31,956,1303,816,236,765,483,135;40;M
8544;1329,34,781,239,946,767,948,765,1303,235,47,203,979,216,135;42;F
8548;1176,766,270,946,767,271,948,34,819,570,336,926,481,269,135;12;F
8551;767,271,46,235,47,203,239,959,956,1303,19,525,570,481,958;43;F
8555;958,101,711,517,926,1176,1170,1111,478,781,148,34,19,1329,336;23;M
8560;220,31,46,759,235,524;35;M
8572;1176,478,34,517,336,1170,1111,148,287,19,819,481,958;43;M
8586;781,524,336,765,135,946,969,767,948;37;F
8604;47,926,1170,478,31,759,287,19,524,336,958,270,271,46,269;43;F
8642;236,270,946,101,201,767,271,781,948,34,765,19,525,819,517;9;F
8662;19,47,336,239,101,236,31,46,1652,287,1303,235,816,819,237;39;F
8684;1111,956,517,481;36;F
8708;101,478,34,336,481;28;F
8713;767,478,101,766,1329,524,336,979,216,781,34,287;31;F
8714;483;15;F
8726;946,1170,1111,478,767,148,948,287,34,765,19,517,336,481,483;19;M
8733;956,148,31,271,478,1111,236,102,1176,946,959,767,948,287,135;41;F
8741;236,34,47,203;39;F
8759;31,21,235,1329,525,481,781,524,570,34,1092,478,926,287;33;M
8784;216,483,135;17;F
8804;478,34,287;35;F
8814;781,19,926,766,767,1652,287,34,765,946,948;37;M
8832;148,135;24;F
8840;336,34,287;28;M
8841;946,236,767,271,948,34,525,819,517,570,336,926,958,269,135;47;M
8873;946,767,948;39;F
8893;31,46,21,1092,135;60;F
8899;959,31,34,524,979,481,216,101,102,148,759,287,21,235,47;34;F
8937;946,767,948;36;F
8947;969,101,766,711,336,1652,946,767,948;43;F
8957;1170,1111,959,478,46,287,34,21,524,525,219,47,517,336,481;57;F
8963;517,481,269,216,135,336,819,525,19,34,948,148,271,236,1176;37;M
8967;958,483,1329,1303,34,781,969,101,236,759,524,47,1092,535,926;50;F
8979;101,1176,1170,102,1111,34,21,47,819,517,336,216;40;F
9012;570,336,926,711,979,481,483,101,287,34;23;F
9017;236,926,958,766,1170,959,47,570,336,481,216,483,1111,478,287;31;F
9018;478,102,101,287,34,21,524,525,535,570,336,481,958;30;M
9024;948,19,336,979,958,34,287,765,767;41;F
9029;239,236,34,1303,235,216,135;31;F
9040;19,926,478,959,1111,1170,102,287,21,34,336,481,958,216,483;30;F
9048;336,535,47,524,34,759,969,101;34;F
9100;31,21,34,524,219,1092,203,483,101,478,287,525,711,926,481;47;F
9128;1329,34,767,271,1111,956,21,336,1176,1170,478,781,287,926,481;36;M
9136;1170,483,766,270,946,1176,765,517,236,46,759,525,1111,336,287;45;F
9142;759,483,1176,1111,478,34,1329,336;35;F
9160;478,759,287,1303,524,819,517,236,34,219,336,203,481,979,216;44;F
9194;956,1652,759,781,31,1111,1170,239,101,1176,34,524,517,336,958;35;F
9210;956,959,287,34,19,570,336,958;30;M
9225;287,34;27;M
9247;101,102;48;M
9250;959,483,481,816,1170,1176,239,478,46,1652,287,34,47,336,958;49;F
9265;759,956,816,1329,524,535,979,216,239,1111,781,287,34,336,711;26;F
9309;148,767,270,766,1176,1170,1111,478,287,34,517,336,481;29;F
9318;1176,102,236,46,759,287,21,336,203,979;27;F
9349;101,102;13;F
9419;101,102;45;F
9422;46,759,287,47,535,203,979;34;F
9455;1111,781,235,19,926,483,1170,1176,236,478,287,34,819,336,481;40;M
9467;711,948,781,478,1176,946,287,34,524,47,336,958;26;M
9469;101,102,287,21,765,535,926;55;F
9477;816,1092,525,524,1329,235,21,1652,46,102,201,101,478,287,34;29;M
9493;102,1111,478,287,21,517,237,239,959,956;41;M
9501;766,781,287,34,765,19,47,336,926,481;26;F
9505;287,34,1329,524,570,711;36;M
9525;148,102,220,1176,236,1111,271,287,34,19,1329,525,819,570,336;32;M
9540;525,47,926,711,979,239,102,478,767,148,287,1303,816,570,336;35;F
9543;946,767,948;34;F
9639;135,269,979,926,336,816,47,34,287,781,271,767,478,946;50;F
9656;946,766,270,1176,1170,236,1111,478,271,31,287,19,47,926,216;33;F
9671;19,525,481,135,201,1170,524,287,517,1111,34,336,926,203,216;33;M
9679;287,956,34,235,47,816,570,336,481,237,269,1176,1170,478,148;33;F
9705;148,31,781,135,483,236,478,287,765,1329,219,47,926,203,216;50;F
9739;959,759,1652,336,946,270,481,958,1176,1111,271,287,34,19,819;48;F
9787;781,239,102,948,956,819,570,203,958,135,236,959,148,34,525;52;M
9801;101,946,102,236,767,31,948,956,765,524,47,336,926,711,135;35;F
9802;766,946,1176,1111,148,287,765,19,336,926,481,483;11;M
9816;969,203,135,483,481,1329,21,34,287,948,31,478,711,765,336;47;M
9830;287,517,483,766,1170,31;32;M
9899;269,239,946,969,34,336,979,1176,1111,959,287,956,819,517,958;41;F
9917;148,478,766,946,1176,1170,1111,287,21,517,336,926,216,135;45;F
9918;766,102,236,517,524,216,101,1176,1111,478,31,287,21,336,481;32;F
9935;101,1176,1170,236,1111,478,287,524,47,816,517,336,979,481,216;28;F
9988;34,19,524,819,535,481,237,101,1176,969,959,47,336,926,979;52;F
10012;220,270,102,236,478,767,271,34,765,525,819,570,946,336,216;30;F
10067;1176,1170,478,287,517,336,481;27;M
10073;102,781,336,101,759,34,524,1092,270,478,271,287,47,711,269;36;F
10125;767,236,570,481,270,220,766,1111,781,287,34,525,336,203,979;31;F
10178;483,1176,1170,1111,478,148,287,34,336;31;M
10198;1092,47;45;M
10216;34,524,47,711,481,101,102,478,271,781,148,956,135;30;F
10235;101,1170,1111,478,287,21,524,517;42;F
10250;236,101,478,767,781,948,765,524,535,926,711,979,483,135,216;23;F
10275;525,236,1176,946,1111,948,34,765,819,570,203,481,269,148,135;31;F
10360;31,19,926,1176,1170,483,135,481,336,34,287,148,781,478,1111;34;M
10367;959,969,237,979,535,816,47,235,1303,34,956,201,102,101,239;25;F
10374;570,481,220,1176,959,1652,235,47,203,237,201,31,46,759,21;44;F
10376;270,271,759,1652,269;42;F
10380;1092,47,759,148,969,102,1176,946,220,765,19,816,336,926,203;41;F
10401;781,759,34,816,336,979,958,216,101,1176,524,47,1092,535,711;26;F
10417;525,765,148,478,959,1170,766,1176,1111,287,34,517,336,481,483;26;F
10441;1170,102,1111,478,31,34,21,819,481;38;M
10557;236,759,148,287,235,524,47,1092,336,979;45;F
10579;766,1176,1170,1111,478,287;33;M
10591;781,759,948,21,765,524,481,237,483,101,1111,478,287,34,47;38;F
10620;1176,270,958,926,336,517,781,31,102,766,946,478,767,948,765;40;F
10625;946,765,216,524,235,34,287,46,101,1176,102,236;37;M
10649;958,524,47,535,478,1111,239,101,969,819,270,271,1652,287,269;38;F
10685;819,525,781,101,570,236,1170,1111,31,34,524,535,336,481,958;42;F
10733;287,34;42;F
10803;766,765,1303,524,525,219,336,926,203,135;32;M
10836;766,270,1176,1170,1111,19,517;32;F
10895;948,819,517,570,926,481,483,766,478,148,287,34,765,19,336;34;F
10906;481,46,148,19,517,135,766,1176,1111,287,1329,336,946,767,948;37;M
10917;101,478,287,1303,47,711,481;35;F
10937;478,959,102,101,270,271,148,34,19,524,47,336,958,269,135;41;F
10947;478,1111,102,101,766,270,959,271,148,1652,34,336,979,958,269;65;F
10972;926,819,1329,765,948,781,946,101,969,535,958,287,34,1092,336;28;M
11043;1170,1111,481,711,135,765,781,478,101,766,287,34,336,483,926;28;F
11044;1176,1170,1111,478,1652,287,34,765,819,517,336,481,269,483,135;42;M
11059;478,781,287,34,765,19,525,219,336,926,203,481,958,216,483;33;M
11069;271;28;M
11072;270,478,46,1652,287,34,269,271;37;F
11086;481,216,979,926,336,524,235,1329,34,287,759,781,478,101,220;32;F
11114;1111,148,287,946,481,483,766,1176;26;M
11126;517,216,19,781,481,765,946,478,1111,236,1170,34,1176,336;17;M
11137;271;39;M
11236;269,969,239,102,271,31,781,148,948,956,34,21,19,47,958;35;F
11242;1329,816,570,269,946,767,948,148,287,34,765,819,135,336,271;40;M
11307;31,956,926,711,203,481,287,34,21,235,524,47,570,336,135;45;F
11310;766,1111,478,287,19,47,336;34;F
11379;1111,1176,1170,524,236,478,287,34,816,570,336,979,481,237,483;30;F
11405;336,958,946,948;46;M
11447;478,1652,34,19,235,819,958,270,271,31,148,816,336,481,269;38;M
11594;101,102,959,478,31,287,956,34,524,816,535,926,711,979,958;30;F
11609;816,958,135,220,946,102,767,31,948,34,524,525,47,570,926;37;F
11648;819,535,101,270,271,31,287,34,47,336,711,237,269,483,135;28;F
11649;236,948,1303,47,819,481,958,1176,781,148,336;31;F
11659;102,239,220,766,946,1176,1170,1111,478,948,34,19,517,336,481;35;F
11664;270,271,148,269;39;F
11678;517,336,926,711,481,216,483,1176,101,1111,781,287,524,979,34;45;F
11696;269,47,270,271;34;F
11710;236,101,270,766,1176,1170,1111,478,46,287,517,336,926,481,216;33;F
11717;19,47,216,926,270,239,1170,478,1652,287,34,1176,1111,271,269;38;F
11769;1176,219,203,481,958,1170,781,34,517,336;49;M
11791;271;43;F
11806;946,270,1111,271,781,34,19,816,517,336,926,203,481,958,269;40;F
11808;271,148,269;38;M
11831;270,269,271;39;F
11842;47,946,767,948,765,135;33;F
11876;1111,478,287,34,336,926,481,483;37;M
11911;269,135,766,946,1111,781,287,34,765,47,517,336,979,481,958;24;F
11922;946,767,948;42;F
11934;1170,34,979,483,1111,959,478,287,19,336,481,958;30;F
11945;766,759,34,1329,1092,336,979,269,216,1176,236,1111,46,287,926;26;F
11963;816,819,1652,948,271,767,959,201,239,220,31,46,1303,525,47;28;F
12005;570,47,203,21,235,481,220,239,236,46,1329,525,336;43;F
12042;1111,1176,34,517,336,481,287;32;M
12045;481,269,926,336,517,1111,1170,1176,270,766,478,287,1329,711,483;61;M
12065;1652,287,47,819,816,336,237,135,766,946,767,948;43;F
12071;969,201,239,236,148,287,1303,525,1092,926,711,216,101,102,1652;45;M
12122;483,766,236,1111,478,46,517,524,926,1176,287,235,481,237,216;30;F
12125;969,31,34,979,481,478,759,21,524,47;30;F
12135;481,483,135,271,1170,1111,239,478,31,287,956,34,47,570,336;30;M
12142;969,767,759,948,1303,524,47,570,711,237,216,31,287,135,336;38;F
12153;535,524,287,101,1176,1170,102,236,1111,478,34,21,1092,481,216;55;F
12157;220,1170,956,235,1329,524,47,525,219,535,336,926,711;40;F
12160;269,271;40;M
12177;570,959,1111,101,946,239,102,31,34,21,47,926;43;M
12227;101,102,478,759,287,956,235,1329,524,1092,535;29;F
12273;948,958,135,1176,1170,148,287,517,481,483,34,711,478,19,336;31;M
12300;766,148,34,19,336,926;29;M
12335;269,270,271,135;40;F
12350;239,481,958,102,271,19,524,336,269;39;M
12352;1111,148,34,765,19,525,570,958,478,781,287,336,926,481,483;29;F
12371;235,19,1176,21,34,781,101,102,1111,478,287,47,336,481,237;45;F
12388;270,102,1111,271,31,1652,21,19,524,47,336,926,711,237,269;38;F
12420;1176,236,1111,959,287,19,816,336,958,269,216;40;M
12432;220,101,236,1111,759,287,34,524,47,336;30;F
12470;270,269,271;38;F
12482;271;33;F
12483;31;47;F
12527;31;14;F
12551;31;55;M
12558;483,203,517,219,236,1176,766,1170,1111,478,287,481,216;41;M
12561;34,287,1652,781,1111,1176,1170,31,759,517;34;F
12579;819,711,101,946,270,1111,271,46,765,570,336,926,481,958,269;36;F
12611;766,239,1176,1111,287,34,524,517,336,711;41;F
12614;101,1176,1111,478,287,336,958,1170;45;F
12624;148,34,1303,47,816,336,517,135,525,766,946,767,948,765,203;26;F
12631;270,271,269;64;F
12633;524,336,481,1111,101,34,19,203,270,102,478,271,31,148,269;38;M
12662;148,101,102,21,19;37;M
12677;481,819,1329,34,287,478,1170,101,1176,1111,959,781,1092,336,926;38;M
12679;946,236,767,948,135;33;F
12681;336,517,219,235,19,21,34,287,148,781,1111,102,1176,946,270;34;F
12728;220,481,336,235,34,1111,287;41;F
12745;271,148,135;7;F
12787;1176,1170,102,236,759,21,101,524,481,483,1111,478,287,1092,926;58;F
12793;148,287,235,524,47,766,478,34,19,336,203,481,958,819,1303;41;F
12802;270,271,269;39;M
12821;31,948,21,1092,819,570,926;39;M
12824;270,1176,1170,271,1303,47,237,481,269;44;F
12837;759,1329,481,216,766,34,21,525,535,203,979,101,524,47,570;30;F
12858;524,926,979,216,766,47,336,711,34,287,759,781,478,236,102;34;M
12863;979,481,236,959,478,31,216,239,1652,287,34,816,336,1303,819;37;F
12864;102,271,148,956,1303,235,524,47,979,216,958;29;F
12872;766,1176,287,21,481;33;F
12875;765,34,1652,478,946,767,948,336;37;F
12878;1176,1170,1111,287,1303,819,481;42;F
12881;21,102,525,819,926,336,1170,1176,1111,478,287,19,517,481;33;F
12883;1170,101,1111,478,287,524,47,819,816,535,517,336,926,481,216;46;F
12937;135,819;46;F
12977;948,19,819,481,269,1176,781,148,34,765,525,816,570,336,203;45;M
13001;101,1176,1170,102,1111,959,478,148,287,21,34,47,336,958,481;30;F
13023;239,101,34,958,481,979,336,31;16;F
13036;336,287,46,148;44;M
13051;287,34,524,517,102,201,1176,220,958,481,336,1111,1170,21,819;44;M
13068;270,271,19,958,269;36;F
13084;958,481,517,819,19,956,287,478,270,236,271,31,148,235,47;38;F
13096;236,959,781,287,19,235,524,47,958,269,216,102,148,34,336;30;F
13138;524,219,570,203,216,239,220,946,236,767,31,948,765,237,135;40;F
13151;570,819,1092,524,1303,956,1652,759,271,969,101,270,946,767,948;36;F
13176;819;52;F
13233;1176,946,203,570,517,819,47,19,1303,765,34,948,148,271,135;31;F
13245;979,216,236,1111,46,148,1092,336;34;M
13249;1111,47,336,135;36;M
13268;287,34;29;F
13306;102,236,271,948,287,956,21,19,525,819,926,711;39;F
13393;524,219,570,203,216,239,220,946,236,767,31,948,765,237,135;62;F
13458;148,34,19,336,483,481,517,287,478,1111,1170,1176,270,766,946;32;F
13512;481,270,239,236,767,819,336,269,1176,1170,1111,478,287,34,517;37;M
13537;101,236,959,271,1652,958,819;40;F
13594;478,1111,236,102,1170,239,270,946,287,21,524,47,1092,481,216;46;F
13628;958,34,781,203,481,1303,31,478,1176,819;26;F
13660;1303,819;38;F
13697;478,959,766,946,1170,1176,1111,781,287,34,517,336,926,481,958;34;M
13707;781,287,525,926,19,34,336,1303,819;46;F
13798;766,236,478,148,524,926,1176,1170,1111,287,517,336,481;42;M
13832;711,483,1092,524,46,1111,1170,1176,287,1329,926,481;53;F
13838;959,271,270,269;45;F
13889;483,926,1092,47,525,287,1170,1176,1111,34,19,1329,524,517,481;41;F
13893;1111,287,765,47,336;30;F
13936;535,237,1176,1111,781,287,34,19,517,481,21,926,236,46,47;58;F
13939;34,766,287,478,1170,1176,1111;44;F
13964;481,270,102,271,287,19,47,819,711,269,1111,781,148,34,336;50;M
13989;236,34,816,203,979,958,969,31,956,235,525,47,336,926,711;39;F
13999;1176,1111,767,271,781,948,287,34,765,19,819,336,481,269,135;48;M
14038;19,819,135,481,711,336,517,525,765,148,271,1176,1111,287,34;27;F
14044;525,219,819,336,926,711,203,481,1176,46,287,34,517,1111,135;46;M
14053;239,236,1111,287,34,958,819;37;F
14076;1176,287,21,570,481,216;44;F
14099;239,220,271,956,711,819;38;F
14126;958,517,235,21,31,478,236,102,135,767,287,956,34,336,926;40;F
14154;478,102,1176,969,1170,1111,47,481,46,287,21,524,517;30;F
14212;148,525,1092,711,101,969,478,781,287,765,1329,524,535,336,135;47;F
14249;1176,1170,1111,478,287,34,336;28;M
14308;1170,478,1176,481,483,1111,926,958,766,148,781,287,336,765,19;40;M
14331;216,969,1170,1176,239,946,220,270,1111,31,781,1303,1092,819,336;41;F
14438;1652,1111,101,478,1303,524,1092,819,481;43;F
14458;34,781,271,478,102,201,239,270,1111,287,926,711,269;40;M
14484;270,271,269;35;F
14493;1303,19,102,236,517,481,958,31,287,956,34,21,336,926,135;5;F
14538;19,481,34;37;M
14568;271;39;F
14636;759,1652,524,816,956,287,969,1176,1170,1111,46,47,819,517,926;39;F
14640;239,270,102,101,478,21,1329,524,47,336,926,711,979,481,216;31;F
14657;1176,1170,236,1111,478,31,759,287,524,819,517,336,926,481,269;45;F
14658;766,101,31,148,34,235,1329,524,336;32;F
14691;819;34;F
14771;766,1170,969,478,481,483,270,1176,236,1111,287,34,517,336,926;48;F
14822;219,270,946,1176,478,781,34,765,517,336,481,287,220,766,483;19;M
14847;336,270,1111,271,269;33;F
14866;1111,1176,959,478,148,34,19,525,219,47,816,336,203,481,958;42;F
14882;819;42;F
14903;148,34,765,19,524,819,926,481,216;39;F
14952;478,767,271,524,819,517,336,926,481,958,269,135,287,34,19;30;F
14976;270,271,148,269;9;M
15028;287,47,816,270,271,517,269;40;F
15036;1176,101,1170,102,1111,959,478,781,759,34,47,336,711;47;F
15039;766,1176,287;29;M
15070;101,148,336,711,979,481,766,765,524,1092,926;31;F
15115;766,959,767,1652,287,235,816,336,958,269,31,34,19,524,135;40;F
15128;101,969,819;39;F
15132;759,1303,235,535,517,203,979,958,148,287,34,524,47,336,926;40;F
15165;1170,1176,1111,478,287,517,336;48;F
15184;1176,1111,478,31,46,287,235,819,517,570,336,926,979,481,237;36;F
15192;270,271,148,336,269;46;F
15205;525,269,135,270,767,271,31,287,956,34,1303,819,926,979,958;29;F
15208;1170,46,1652,19,235,1329,517,336,958,216,483,239,236,34,481;54;M
15223;926,781,956,958,47,31,765,135;43;F
15238;1329,19,47,517,481,216,1176,1170,1111,478,287,34,819,336,926;25;M
15240;926,481,483,34,287,781,336;31;M
15253;1652,525,47,570,203;38;F
15263;781,287,34,336,135,766,946,767,948,765;41;F
15277;1329,765,948,781,31,767,1111,1176,270,946,478,287,34,525,819;28;F
15287;570,1092,524,1329,956,1652,767,946,948;40;F
15333;948,1652,287,1092,816,570,336,711,958,135,1170,1111,271,47,819;40;M
15475;1652,287,47,816,517,979,270,271,269;14;F
15497;102,478,287,203,1176,1170,1111,34,336;28;F
15509;959,236,570,535,816,524,1111,201,239,102,759,287,819,336,481;41;F
15533;1170,1111,478,287,47,816,517,979,270,271,269;8;M
15542;766,1111,148,759,287,34,765,336,926;28;F
15551;102,1329,926;48;F
15552;483,766,236,478,287,765,1329,1092,336,926;30;M
15592;1652,21,101,1176,969,236,478,34,711,926,47,19,781,819,481;47;M
15624;525,958,216,336,570,34,236,478,1303,287,819;40;F
15627;1303,819;47;F
15664;102,236,1111,478,781,148,34,765,219,816,336,926,203,979,269;33;F
15668;203,926,478,1176,270,766,781,148,287,34,336;43;M
15685;926,336,517,287,148,46,1111;26;M
15698;959,336,481,958,781,759,287,34,816;28;M
15709;271;41;F
15730;101,1111,524,47,816,517;50;F
15735;336,766,34,483,1176,1170,1111,478,148,287,524;39;M
15748;765,524,47,481,135,34;22;F
15768;478,766,270,946,102,1111,765,237,979,781,148,816,336,926,203;3;M
15782;271,269;36;M
15813;819,336,101,270,524,517,926,481,958,216,1176,1111,1652,287,34;43;F
15847;1170,1176,1111,478,781,287,34,524,1092,819,535,336,926,711,481;51;F
15854;287,765,19,948,525,711,481,1329,34,148,336;29;F
15878;781,46,819,517,336,979,483,102,478,287,34,21,926,711,481;70;M
15883;34,525,336,481,220,478,287,148,926,203,216;37;M
15915;959,19,287,1111,781,926,1176,478,336,271,1652;38;M
15921;1176,1111,959,781,948,956,765,19,525,926,481,135,148,34,336;39;M
15979;517,336,481,1170,1111,287,1303,1092,819;44;M
15984;478,270,766,220,236,1111,781,765,1303,946,767,948,203,135;37;F
16018;1176,1111,478,46,287,34,21,235,524,525,47,819,517,336,203;29;F
16189;517,819,524,1170,1176,1111,959,478,781,287,271,34,19,336,958;11;M
16222;969,101,481,135,236,336,34,956,148,959,271,19,47,958,269;40;F
16283;216,148,478,1176,1170,1111,959,781,287,34,19,819,336,926,958;10;M
16291;271;39;F
16311;135,483,216,102,236,287,525,1092,481,34,21,336,711,926,203;51;M
16334;819,235,19,148,478,766,1170,1111,287,34,21,517,336,926,481;33;F
16375;270,1176,1170,1111,478,31,287,34,765,47,336,926,481,269,216;32;F
16400;711,203,148,478,1170,1176,19,21,46,287,34,336,269,1111,816;46;M
16401;336,958,483,216,481,766,236,1111,478,287,34,1329,525,926,203;75;F
16554;201,203;72;F
16583;34,19,1329,525,819,148,47,570,336,926,711,979,481,958,216;46;F
16589;478,1170,1176,1111,781,34,819,481;42;F
16680;1111,220,236,219,926,203,216;37;F
16692;926,236,235,219,237;36;F
16696;958,946,148,19,570,483,269,270,271,948,1652,34,819,336,481;39;F
16755;1652,956,481,958,216,483,236,478,287,34,525,1092,517,336,926;59;M
16767;101;22;F
16823;926,711,148,34,336;28;M
16844;236,1329,336,1111,478,287,34,525,219,1092,926,711,203,979,481;27;F
16858;239,478,31,781,759,1652,287,34,1303,235,336,216,135;42;F
16859;1176,1170,478,287,34,21,517,336,926,481,483;32;M
16899;759,959,102,270,478,766,148,1170,1176,1111,958,926,287,483,481;27;M
16959;148,781,478,959,1170,1176,239,236,1111,34,524,47,336;45;F
16986;478,525,219,203,1176,1170,1111,34;34;M
17065;269,483,135;16;F
17083;766;34;M
17108;336,969,781,34,535,711,926,101,1092,236,759,524,47,481,216;22;F
17123;478,1329,524,525,219,570,203,958,31,759,287,956,34,336,926;35;F
17130;236,1111,478,287,34,1329,525,219,1092,336,926,711,203,979,481;49;F
17191;46,948,34,135,766,236,148,21,765,524,1092,819,570,336,481;49;F
17224;269,270,271,148;46;F
17225;135,959,201,1176,239,46,948,1652,235,47,819,336,481,958,237;42;F
17268;766,765,926,135,946,767,948;36;F
17301;270,946,271,148,948,1652,34,19,819,570,336,481,958,269,483;10;F
17335;766,1176,1170,1111,478,148,287,34,765,517,336,926,203,481,483;28;M
17353;270,946,271,148,948,1652,34,19,819,570,336,481,958,269,483;6;F
17366;969,336,711,979,958,535,47,34,1652,46,959,102,101,946,819;41;F
17368;101,1176,31,759,765,1303,525,979,1092,819,926;44;F
17417;1170,1176,101,524,525,219,816,926,203,216,236,31,956,47,711;42;F
17423;478,1111;32;M
17494;46,287,34,517,102,781,19,336,270,269,271,148,948,481,958;49;M
17508;711,481,269,216,766,946,236,767,271,948,765,819,336,958,135;40;F
17544;1303,781,236,239,759,287,34,1092,135;68;F
17555;34,271,926,946,1176,767,781,148,948,287,765,819,336,481,135;15;M
17603;478,525,336,1111;39;M
17626;270,517,926,481,236,1170,1111,220,1176,478,34,287,203,47,46;47;M
17673;1111,478,287,517,946,1176;42;F
17688;21,766,1111,34,525,926,1176,1170,102,478,287,765,517,336,481;26;M
17752;201,102,1111,287,525,816,759,1652,46,31,239,946,1303,926,135;46;M
17818;47,819,517,269,483,135,478,287,34,336,481;28;M
17827;481;32;F
17833;711,336,570,1092,525,524,1329,287,969,201,239,220,781,34,926;39;F
17941;135,203,478,34,1303,287,781,765,220,946,239,236,767,948,237;73;M
17947;946,570,336,203,481,269,1303,819;37;M
17970;1111,34,819,570,979,481;38;F
17982;1176,1170,1111,287,34,235,47,816,517,481,1303;31;F
17994;219,481,336,570,525,19,948,767,236,271,958,269,47,31,270;54;F
17997;766,336,926;47;F
18008;1303,759,31,271,767,1111,236,1176,946,1652,287,34,765,481,135;29;F
18010;766,1176,1111,478,759,926,287,34,765,481;31;M
18020;336,926;49;M
18080;270,1176,1170,1111,271,336,269;36;F
18118;1176,1111,478,287,1303,19,1329,525,219,816,517,203,481,216,483;23;M
18121;336,711,979,958,216,101,1111,478,287,524,219,47,535,203,481;59;F
18143;517;46;F
18151;102,959,271,269,958;43;M
18155;1176,1170,1111,47,517,336,481;27;F
18176;1111,478,271,31,287,956,34,1303,235,1329,525,219,819,336,926;37;F
18198;1111,287,47,235,19,336,203,34,1652,237,216,219,1303,236,819;43;F
18206;1176,1170,102,959,1111,478,34,235,524,47,819,46;21;M
18295;270,766,1176,31,46,216,34,765,19,235,525,219,47,819,816;33;F
18403;220,236,235,219,237,216;61;M
18418;287,524,517,336;28;F
18421;270,1329,1176,1170,1111,478,148,287,34,21,19,711,336,816;43;M
18433;1303,711,239,236,1111,271,31,235,819,570,336,481,958,269,237;36;M
18456;958,1176,101,946,766,135,481,517,524,287,271,478,1111,102,1170;22;M
18469;759,816,525,203,481,483,101,1176,102,148,287,34,21,19,336;31;F
18487;1111,148,287,34,336;36;M
18618;956,1303,1329,926,269,1176,31,235,819,336,216,236,781,287,34;31;F
18624;220,1176,1170,102,236,1111,287,34,21,47,819,517,203,481,216;26;F
18653;34,765,336,216,135;38;F
18700;948,1652,956,1329,819,1303,219,336,1176,1170,478,287,517,926,481;28;F
18702;478,21,1303,47,216,239,1176,1170,236,287,34,235,517,481;35;F
18712;478,1111,102,1170,481,711,336,34,287,759,148;20;M
18716;946,201,236,767,948,34,524,47,1092,135;40;F
18739;270,271,19,269;5;F
18744;34,235,219,1092,237,236,478,271,781,287,819,979,481,216,135;29;F
18795;101,781,336,148;53;F
18800;237,1652,239,236,287;40;F
18882;1170,478,271,946,1176,1111,287,525,517,481;56;F
18952;135,926,336,946,1111,287,34;21;M
18988;101,1170,969,483,517,1111,1176,946,766,287;50;M
19009;236,31,1111,102,1176,101,46,287,34,21,19,47,819,535,237;38;F
19023;525,517,570,336,979,481,216,483,524,1303,21,46,478,236,102;30;F
19055;958,269,781,336,1111,271;37;F
19111;1176,101,102,236,1111,31,46,287,34,21,19,47,819,535,237;39;M
19115;525,47,1092,535,979,270,101,102,271,524,570,336,203,958,269;47;F
19135;101,102,781,34,19,481,958,269;48;M
19138;101,201,102,236,1111,31,46,287,34,21,19,47,819,535,237;9;M
19184;1111,1170,1176,926,481,478,287,34,1303,819;48;M
19201;220,148,765,525,219,203;36;F
19217;271,1170,781,287,34,336;44;M
19250;1303,336,711,979,237,216,239,1652,956,235,819,535,926,958,135;7;F
19281;759,46,959,1111,101,946,270,1176,1170,478,781,287,517,926,481;24;F
19309;766,483,759,34,525,336,481,958,1176,1170,1111,959,287,517;50;F
19318;236,959,781,926,711,203,34,336;48;M
19353;1170,1111,478,781,1652,287,21,47,819,926,481;41;F
19382;1329,34,101,1111,478,287,21,524,47,1092,535,517,336,926,481;58;F
19397;781,34,926,481,135;36;M
19450;979,203,535,1092,524,34,759,1176,236,1111,1329,219,47,816,216;45;F
19494;765,336,711,958,269,135,47;36;M
19504;1111,969,102,1170,946,767,271,148,287,34,19,47,819,336,958;41;M
19507;102,1176,1170,46,759,287,34,19,524,525,819,517,336,926,481;53;F
19509;1176,766,270,102,236,524,336,483,220,1170,1111,478,287,21,517;48;M
19517;101,201,31,46,287,235,524,517,239,1111,1652,956,34,819,237;39;F
19536;271,31,781,948,287,235,524,819,336,203,979,239,236,46,47;34;F
19555;220,148,239,31,19,235,979,483,1170,236,478,287,819,336,481;9;F
19576;270,271,269;33;F
19585;1111,236,969,102,1170,1176,101,766,478,781,34,765,47,336,926;35;F
19638;766,1176,1170,236,1111,478,959,148,287,34,765,19,819,336,481;19;M
19645;336,269,483,946,766,270,1111,478,287,34,765,19,525,219,203;35;F
19654;220,239,1176,1170,102,1111,959,478,46,287,34,21,19,1329,517;42;F
19670;481,270,1111,34,483,766,1170,1176,517,216,478,287;28;M
19672;759,21,765,525,219,570,203,216,1092,926,101,478,287,1329,524;28;F
19747;270,1176,767,478,148,287,34,336,926,481,269,483,1170;30;M
19859;969,216,1092,47,524,781,478,236,1170,481,926,46,535,203,979;69;F
19867;47,819,535,570;44;F
19885;102,969,767,765,1329,524,926,481,483,478,781,287,525,517,958;37;F
19896;816,535,570,926,203,102,781,19,819,336,711,481,237,958,216;55;F
19897;781,959,34,956,19,235,525,819,570,203,481,958;44;M
19913;270,239,31,781,816,481,958,216,1176,1170,1111,478,287,34,517;38;F
19927;1329,219,570,926,711,203,979,958,237,216,483,135,236,759,781;50;M
19932;946,1111,767,271,948,148,287,34,765,336;33;M
20053;781,31,271,946,135,959,1303,34,765,1329,336,926;37;M
20102;946,759,956,287,34,765,1329,525,517,926,481,269,135,483,336;43;M
20108;235,524,819,570,336,926,711,481,958,269,31,781,287,34,47;32;M
20160;135,237,765,948,31,767,946,236,220,239,216,203,570,219,524;9;F
20174;524,34,1652,759,31,478,236,969,239,201,946,767,948,336,203;39;F
20194;946,239,201,969,236,478,767,31,759,948,1652,34,524,336,203;40;M
20210;237,135,765,948,31,767,236,239,946,220,216,203,219,524,570;6;F
20212;47,819,535,711,926,481,766,1176,1170,1111,478,34,524,336,517;43;F
20244;101,1176,1170,1111,478,759,287,34,524,1092,336;39;F
20272;946,239,201,969,236,478,767,31,759,948,1652,34,524,336,203;8;M
20310;819,525,19,765,948,478,102,946,270,781,46,287,21,926,336;38;M
20313;946,239,201,969,236,478,767,31,759,948,1652,34,524,336,203;7;F
20345;478,767,271,31,781,46,148,287,34,765,19,525,819,517,336;37;F
20468;959,102,46,19,47;46;F
20480;1303,236,1111,31,781,287,956,34,235,525,517,336,926,203,481;30;F
20590;766,1176,287,524,336,926,979,1092,1329,34,781,1111,1170,201,101;50;M
20660;148,956,765,517,336,711,483,481,766,1176,1111,31,287,34,926;29;M
20663;956,781,31,478,236,239,1176,1170,1111,148,287,34,336,711,481;49;M
20676;239,101,1176,1170,1111,478,31,21,524,819,816,535,517,481,483;43;M
20701;959,1111,236,1170,1176,101,135;43;F
20751;1170,201,1176,101,239,946,270,220;51;F
20959;1176,101,969,21,1170,1111,478,287,524,535,926,979,481,958,216;23;F
20968;270,271,269;43;F
21046;336,1176,1170,102,1111,478,287,517;35;F
21061;239,201,101,220;40;M
21069;216,766,1111,781,34,765,219,203,237,135,220,101,236,535,926;30;F
21076;819,711,135,958,765,956,34,287,948,148,781,767,946,926,336;42;M
21089;1170,1176,239,287,34,19,524,525,47,819,517,336,203,958,269;40;F
21151;1111,478,287,34,336;24;M
21161;1303,19,481,135,101,819,203,1176,236,46,34,525,219,517,336;43;M
21198;201,1170,102,1111,478,287,21,524,535,517,336,979,481,237,216;31;F
21214;287,926,220,1176,1170,517;34;F
21228;34,235,47,336,979,958,269,483,270,271;37;F
21242;239;23;F
21253;1176,1170,1111,478,287,34,517;32;F
21282;946,1176,1170,287,34,517,336;33;M
21352;135,235,287,948,31,767,271,239,946,102,781,1652,34,336,926;36;F
21355;239,819,517,336,481;39;F
21396;483,216,102,959,958,135,481,711,765,287,948,781,767,946,148;46;M
21408;478,287,517;50;F
21416;239;43;F
21423;336,135;30;F
21471;236,781,765,235,816,237,216,220,946,239,767,948,34,47,336;37;F
21474;239;21;F
21488;216,237,102,1111,781,34,21,1092,236,1170,47;49;F
21522;1176,1111,287,34,19,336,481,958;39;F
21571;148,47,236,478,287,34,1303,336,135;33;M
21638;201,1170,1329,711,483,481,34,287,148,478,236,969,239,47,336;32;F
21665;220,236,524,1092,926,711,958,336,478,287,34;39;F
21673;1170,1176,236,1111,478,287,34,235,19,47,816,517,336,481,216;43;F
21675;946,766,1176,1170,236,1111,478,287,34,19,47,816,517,336,216;42;M
21676;148,31,1176,766,336,481,483,1170,1111,959,478,287,34,765,819;45;F
21696;270,102,271,269;42;M
21759;478,31,759,525,219,517,269,819,1176,1170,1111,765,19,201,203;50;M
21761;959,148,336,926,1176,1170,1111,478,287,34,21,19,517,481,958;41;M
21810;959,31,148,759,34,19,525,47,535,570,336,711,203,958,216;53;F
21819;239,946,1170,969,236,767,31,781,948,956,34,1303,517,336,926;4;F
21837;781,1652,34,19,235,525,219,535,135,47,336,203,979,958,237;38;F
21842;1176,1170,287,21,524,47,517,926,216;38;F
21855;517;39;F
21936;239,1111,766,270,236,478,1652,287,34,47,1092,517,570,336,481;36;F
21945;19;29;M
21958;34,47,336,958,236,765,1303,1092,816,570,759,781,31,1111,819;51;F
21988;570,819,946,102,767,948;7;M
22073;946,102,767,765,819,570;8;F
22099;946,767,948;40;F
22109;46,711,216,219,34,819,1303,101,236,759,524,1092,535,979,237;67;F
22133;19,819,517,336,481,269,135,287,34,765,483;34;F
22207;135,781,239,478,31,759,287,34,524,47,816,336,926,979,237;30;F
22283;1170,1176,101,236,1111,478,148,765,481,766,287,34,524,517,336;31;F
22298;1111,781,287,34,524,525,336,203,481,958,216,483,1176,1170,517;33;F
22329;270,946,1176,1111,287,34,19,219,517,336,203;42;M
22338;816,19,21,287,1652,781,31,478,1176,1170,1111,34,47,517,481;41;F
22356;948,287,19,819,946,148,34,1303,235,525,219,47,816,336,203;33;F
22361;1176,535,483,766,101,1170,478,781,287,34,765,524,336,926,203;26;F
22386;148,948,34,219,819,570,336,203,481,237,239,236,287,926,216;30;F
22388;781,525,570,481,483,766,946,1176,1170,1111,478,287,34,524,47;31;F
22413;1176,236,21,336,270,767,271,819,948,216;35;F
22472;767,31,781,46,524,979,135,102,236,287,34,765,336,47,926;37;F
22487;34,47,816,535,237,216,135;47;F
22505;135,216,269,481,819,524,1303,956,271,1111,239,759,336;39;F
22575;235,524,525,926,481,216,483,1176,1170,478,1111,287,47,517,336;42;F
22593;483,958,481,766,1176,270,946,478,148,287,34,19,525,336,926;26;F
22634;270,271,148,287,1303,235,47,816,535,570,336,926,958,481,269;34;F
22643;711,1170,478,767,781,287,21,19,524,525,570,926,1176,102,481;38;F
22681;271,781,1303,1329,816,481,958,946,1111,478,148,287,34,47,336;28;F
22688;781,148,1652,287,34,336,926,135;41;M
22732;959,765,47,819,517,481,979,269,34,19,524,525,958,216,336;28;F
22759;1170,819,946,1176,287,34,765,219,570,203,236,1111,31,46,481;37;F
22807;34,1176,1170,102,478,767,781,287,21,19,525,570,926,711,481;42;M
22831;101,31,765,524,216,1176,1111,148,287,956,34,570,336,481,958;36;F
22848;102,959,31,148,287,956,525,570,336,979,481,958,201,101,269;36;M
22862;271,478,236,1170,1176,946,766,270,1111,287,34,525,570,203,481;34;F
22879;926,336,135;39;F
22901;148,478,102,270,1176,1170,236,1111,287,34,21,517,926,481,216;21;F
22930;946,766,1176,1170,1111,478,148,287,34,765,19,517,336,926,481;33;M
22954;946,1176,1170,1111,767,478,46,287,34,19,525,517,926;35;F
22989;31,759,524,1092,47,336,926,481,517,34,287,1652,478,1170,1111;39;F
23065;239;39;M
23095;525,270,271,570,269;56;F
23131;946,767,271,525,819,481,781,765,219,1111,236,1176,287,34,336;33;F
23132;31,148,956,47,1092,336,958,237,269,271;35;F
23161;101,236,148,525,219,336,926,203;33;F
23174;287,958,478,34,1176,1170,969,1111,21,517,336,481;42;F
23228;219,946,478,759,34,517,570,336,1176,1170,1111,287,525,203,481;31;F
23339;781,287,235,570,481,239,102,236,759,34,21,336,926,237,216;41;F
23346;711,269,270,1176,1170,478,271,31,524,819,481,958,216,101,135;44;F
23477;766,959,148,517,336,926,216,19,34,287,781,1176,1170,478,1111;41;F
23496;270,269,271;48;F
23504;481;42;F
23507;336,287,1111;36;M
23554;956,19,517,336,926,481,216,483,1176,1170,1111,478,959,287,958;15;F
23560;481;48;M
23587;1111,948,766,270,1176,1170,271,148,287,34,765,819,517,336,269;32;F
23661;220,46,148,524,819,711,481,958,135,287,34,525,336,203,47;30;F
23664;1652,21,1303,235,19,524,525,819,535,570,336,979,481,958,216;14;F
23682;1170,1176,1111,959,478,287,34,21,19,525,47,1092,336,926,481;52;F
23705;525,524,235,19,34,46,959,236,287,956,478,759,711,1092,926;46;F
23720;269,958,19,1111,101,781,287,819,336;47;F
23780;517,216,1176,1170,959,478,287,956,34,19,525,336,926,481,958;61;M
23782;203,336,570,819,525,19,34,948,46,148,767,102,1170,1176,287;26;M
23795;1303,235,1111,1329,478,47,101,1176,1170,517,216,766,270,956,926;37;F
23828;101,1111,271,46,1652,47,819;38;F
23842;959,287,336,958;43;M
24007;946,959,767,271,148,19,819,517,481,135,1111,287,34,765,216;31;M
24012;481,517,287,1176,1111;42;F
24018;1176,1170,1111,478,287,517;35;M
24025;271,269;36;F
24031;219,21,220,47,102,239,236,235,237;42;F
24055;765,1303,19,1329,47,926,481,478,781,287,34,524,570,483,336;31;F
24074;31,759,956,19,819,517,269,1170,1111,34,47,336,711,481,135;39;F
24076;1176,1170,1111,46,759,287,34,21,47,819,517,570,926,481,269;49;F
24084;766,765;34;F
24096;270,239,101,271,759,524,47,1092,711,958,269;39;M
24109;766,270,1170,1111,478,287,525,1176,236,781,336;44;M
24151;781,1176,1092,819,336,481,101,148;60;F
24169;759,1111,781,1176,1170,766,478,517,483,101,148,287,34,765,524;39;M
24199;216,766,1176,1170,236,1111,478,287,21,525,819,517,336,203,481;40;M
24246;46,236,1111,34,336,711,481,958,216,270,271,287,956,269,816;43;F
24290;1111,31,148,287,336,481;42;F
24293;816,201,31,46,525,1092,535,570,203,979;64;M
24295;1329,46,271,759,766,1176,1170,1111,478,287,34,517,926,481;38;F
24359;102,478,781,287,19,525;54;M
24363;535,203,1092,336,237,525,1303,781,959,220,101,102,46,759,34;55;F
24379;767,271,236,148,948,34,765,19,525,336;26;M
24401;1111,478,525,979,216,926,336,517,219,21,956,236,102,1170,1176;66;F
24404;570,336,481,237,1176,478,483,135,766,1170,236,1111,287,765,819;49;M
24410;766,239,1176,101,759,287,34,524,47,535,336,979,481;26;F
24411;1170,1111,287,1329,524,336,819;41;M
24423;19,1176,1170,1111,478,271,287,34,819,336,481;36;F
24488;270,101,271,759,1652,287,19,524,47,819,816,535,336,958,269;39;M
24511;336,711,237,483,34,956,478,959,1176,239,481,1303,287,31,819;36;F
24526;1170,1111,478,271,287,34,19,47,819,816,570,336,926,269,148;31;M
24532;102,1111,478,759,287,34,524,47,336,926,979,270,271,958,269;62;F
24541;34,270,271,269;38;F
24542;237,926,819,1303,956,1652,31,478,959,969,1170,1176,239;3;M
24562;766,946,767,948;37;F
24566;946,781,19,219,216,819,336,517,102,1111,1176,46,148,287,481;42;M
24608;958,336,19,287,102,1111;47;M
24621;1652,1303,816,946,1176,1111,517,336;49;M
24651;926,517,47,19,148,478,1170,1176,766,1111,287,34,816,336,481;32;F
24662;148,287,19,336,958;29;F
24668;336,926,1176,1170,102,236,1111,478,287,34,21,524,1092,517,481;52;M
24701;102,1111,31,46,287,1303,525,819,517,570,336,926,203,481,237;5;F
24707;711,926,819,235,1303,956,1652,959;36;M
24711;958,336,767,959,148,287,34,19;31;M
24744;956,237,711,819;85;F
24787;47,148,220,525,481,216,219,1329,287,759,478,1111,1176,926,203;48;M
24832;270,271,19,269;34;M
24853;711,959,816,570,336,926,481,958,483;38;M
24854;270,271,19,269;22;F
24897;287,1329,481,478,524,926;35;M
24903;959,19,819,336,481;39;F
24954;336,959,816,570,926,711,979,481,958,483;37;F
24963;34,46,287,21,765,524,47,1092,816,570,336,926,711,203,979;70;F
24970;270,271,269;38;F
25045;101,46,271,270,269;37;F
25070;1170,336,766,781,34,926,478,1111,287;30;M
25075;239,101,1111,478,31,759,1652,287,34,235,524,47,819;32;F
25079;236,478,781,287,34,336;30;F
25088;236,524,1092,570,216,148,1111,1170,1176,478,287,336,926;44;M
25102;102,46,21,47;41;F
25125;236,959,478,287,1303,19,1329,517,958,1170,1176,1111,34,819,336;47;F
25147;148,31,1170,101,237,524,287,478,1111,220,236,759,219,203,216;30;M
25149;1111,959,781,47,203,958,236,220,1176,34,1329,819,336;50;M
25195;47,570,203,979,135,946,101,148,19,336,239,102,46,524,525;32;F
25221;201,102,816,958,236,959,1303,47,336,1111,969,46,956,216;31;F
25223;1176,102,1111,524,336,481;31;F
25242;1111,1176,34,336,1303,819;40;F
25244;102,31,148,47,517,1176,1170,1111,478,271,287,34,19,819,336;32;M
25250;220,203,766,270,1176,1170,1111,478,287,765,1329,926,958,483,135;35;F
25251;765,481,478,1170,766,236,517,483,216,34,1111,1176,781,287,336;35;M
25254;1176,1170,1111,478,287,517,336,926,481;38;M
25364;766,946,101,102,236,767,31,948,287,34,765,524,47,535,336;40;F
25409;517;18;M
25437;517;47;M
25480;34,1329,219,478,236,46,336,711,203,481,269;46;F
25482;766,236,478,781,46,148,287,956,34,1329,336,711,481,237,483;50;M
25484;236,478,781,46,1329,481,148,711,336,956,34;71;F
25509;271,478,959,1111,1170,1176,270,946,767,948;9;F
25511;235,524,135;34;F
25549;102,270,271,269;39;M
25553;270,102,271,269;39;F
25609;959,524,1111;37;F
25618;271,781,287,958,269,135;34;M
25642;766,1111,478,287,19,517,336,481,483;40;M
25664;47,46;50;F
25700;269,203,336,819,1303,765,287,948,271,767,236,946,148,34;38;F
25709;287,766,481,269,270,478,1092,926,483,517,1176,1170,1111;49;F
25712;102,101,239,270,478,926,711,148,287,34,524,47,958,216,135;42;F
25767;34,336,1111;44;M
25774;47,270,101,236,478,271,287,1652,34,21,1092,336,481,958,269;38;F
25794;31,478,1170,946,1176,1111,287,517,336,926,481;26;M
25811;483,336,517,1329,287,478,766,1176,1170,1303,1111;45;F
25821;336,203,979,524,235,958,478,236,201,220,969,926,237,781,1652;45;F
25828;781,958,269,101,1176,478,271,287,34,19,524,1092,819,535,336;46;F
25837;525,34,478,287;42;F
25841;481,336,1092,524,19,781,959,270,1176,1170,1111,478,287,34,517;38;F
25846;148,766,946,220,34,525,219,517,336,203,1303,483,287,1111,1176;31;F
25863;236,478,101,102,759,287,34,19,524,1092,816,535,336,711,481;28;F
25874;101,102,1111,781,759,287,34,219,525,816,203,236,524,47,336;56;F
25881;766,765;62;F
25895;766,765;65;M
25904;766,765;31;F
25956;483,535,524,21,759,102,101,270,517,287,478,1170,1176,766,1111;50;M
25980;1303,47,816,570,216,102,969,1111,31,46,759,956;31;M
25998;271,781,948,759,1652,34,765,47,46,1176,101,239,946,270,766;8;F
26026;135,766,767,781,948,1652,34,1303,1329,47,816,535,336,926,203;35;F
26062;1303,1329,1170,946,1111,1176,270,287,21,765,525,47,336,203,481;41;M
26093;135;30;M
26120;781,1652,287,34,19,235,135;38;F
26193;926,1329,524,525,570,203;19;M
26195;1329,524,525,570,203,269;51;F
26198;336,483,19,781,1111,766,478,34,203,135,1329,765,525,570,711;51;F
26210;216,481,979,336,535,1092,21,287,759,478,1111,102,1170,1176,101;33;M
26214;220,101,102,759,34,524,203,148;35;F
26273;483,336,517,819,47,19,1170,946,270,1176,1111,781,148,287,34;45;F
26305;203,219,237,1111,766,483,517,481,287,765,19,1170,478,148,270;58;F
26323;31,946,948,767;44;M
26331;239,1170,271,517;41;F
26358;478,1170,767,765,483,481,948,766,1176,1111,148,287,34,19,336;32;M
26387;1111,767,478,271,31,781,46,148,759,948,287,34,765,524,47;7;M
26402;766,1170,959,478,148,34,19,517,926,481,483,1176,1111,287,336;38;M
26425;819,148,958,216,31,47,524,1329,34,236,969,1170,1176,956,1303;36;F
26447;946,948,767;10;M
26490;148,816,535,570,958,237,216,102,236,46,34,47,926,711,481;44;F
26517;948,767;41;F
26539;216,203,946,239,101,287,34,765,1329,524,525,47,816,336,135;32;F
26541;1170,969,236,478,781,46,524,47,1092,535,926,203,979,481,216;72;M
26561;135,1329,524,525,570,203;15;F
26566;216,483,517,19,956,31,478,1170,1176,101,1329,524,525,570,203;36;M
26570;270,478,148,287,34,19,235,524,47,336,926,481,958,269,271;40;F
26599;31,781,481,216,956,1329,47,711;39;M
26600;1111,236,969,766,31,271,148,19,235,481,269;31;M
26602;135;35;F
26614;102,525,203,481,216,269,711,570,819,1092,19,46,781,271,270;54;M
26620;34,21,1329,524,47,1092,336,926,203,979,958,216,948,767,946;46;F
26625;270,239,271,269;33;F
26636;34,524,1652,135;44;F
26648;287,34,135;35;F
26655;781,767,1111,1170,1176,270,766,478,287,34;25;M
26669;31,270,1176,766,1111,478,148,287,34,765,19,524,336,926,481;36;F
26671;235,525,219,269,203,766,102,31,781,287,34,336,926,979,135;36;F
26674;1111,287,958,269,336,101,102,271,148,21,19,47,819,535,237;32;F
26684;759,31,271,969,101,478,781,287,524,816,336,1652,1176,1170,1111;35;F
26692;19,1329,524,47,819,816,336,926,711,203,481,958,269,483,135;36;M
26706;102,336,926,1329,524,525,570,203,135;27;M
26707;101,478,767,948,287,34,819,570,336,481,269,483,135;45;F
26712;271,781,19,816,481,269,483,270,236,148,287,34,1303,819,336;49;F
26748;959,478,287,34,765,19,524,570,336,711,979,958,969,781,926;35;M
26772;517,525,524,287,31,781,1176,1111,34,336,926,481,269;18;F
26793;271,1329,524,525,570,711,203,269;50;M
26809;1170,948,1652,1303,336,481,1176,1111,959,781,287,34,19,819,517;46;F
26816;481,926,819,524,781,767,478,101,135;43;F
26825;766,765,979,220,236,34,235,219,926,203,481,237;40;M
26832;270,31,46,759,1652,34,1303,235,525,570,336,926,481,958,135;43;F
26927;781,19,336,926,481,958,216,1176,1170,1111,287,34,1303,819,517;36;F
26930;517,711,481,269,483,135,270,766,478,287,34,235,819,336,926;27;F
26939;816,517,570,481,483,135,946,270,766,1111,287,219,525,336,203;35;F
26955;21,478,101,1176,1170,220,1111,287,1092,819,517,570,336,481;37;F
26969;336,203,481,237,216,1170,236,1111,478,46,287,34,525,819,517;41;F
26988;1111,270,236,271,287,524,269;36;F
27030;203,1329,524,525,570;50;F
27049;570;59;F
27071;34,956,148,781,1170,1176,270,766,483,1111,478,31,287,926,135;35;M
27079;765,287,148,271,1111,1170,946,270,766,236,478,34,47,926,216;21;F
27096;1329,524,525,203,570;16;F
27118;31,21,570,926,203,483,946,236,767,781,948,765,19,336,135;38;F
27171;1176,102,1111,767,271,781,819,1170,287,34,336,481,958;32;M
27198;135,765,766;31;M
27310;1092,524,34,148,959,236,1176,1170,1111,478,287,19,517,336,481;42;F
27333;220,946,239,236,767,31,948,34,765,524,336,203,481,958,216;16;M
27370;236,271,287,21,19,235,525,47,819,336,203,958,237,269,135;37;F
27395;216,203,219,525,759,46,31,270,236,271,148,269;32;F
27409;270,271,148,269;36;M
27427;270,271,269;38;M
27437;946,101,478,269,524,525,535,336,979,481,483,1176,287,47,517;45;F
27447;1092,203,220,101,31,781,148,34,235,47,816,535,336,926,711;40;F
27469;1092,19,478,236,1111,287,34,765,525,47,926,711,203,481,216;46;F
27497;21,1303,781,1092,336,926,1176,1170,1111,759,1652,287,34,819,481;44;F
27499;47,34,46,1111,1170,102,570,1176,481,101,819,759,336,236,31;36;F
27518;958,926,336,1092,47,1329,19,34,287,781,31,1176;40;M
27547;483,524,765,287,148,781,517,101,1170,1111,478,1092,47,336,979;47;F
27608;765,235,47,336,481,135;39;F
27650;102,1176,1170,1111,46,481,34,47,570,101,819,759,336,236,31;38;M
27655;1111,101,711,1176;28;F
27679;46,1170,1176,1111,102,481,34,47,570,101,819,759,336,236,31;7;M
27715;766,220,270,102,236,478,46,287,34,524,819,816,926,336,203;30;M
27721;958;36;M
27737;1170,1176,1111,102,46,481,34,47,570,101,819,759,336,236,31;4;M
27740;958,270,959,271,269;40;F
27746;535,711,979,481,483,1176,102,478,46,287,34,524,1092,570,926;32;M
27764;481,766,946,1176,478,47,483,102,1111,287;35;F
27777;767,524,101,102,959,781,21,765,19,47,570,336,481,958,148;33;M
27784;959,270,271,269;13;F
27798;959,19,270,271,269;9;M
27799;1176,203,269,483,766,1170,1111,478,287,34,19,819,517,336,481;43;F
27808;271,269,270,959,19,958;9;M
27817;535,47,524,34,287,781,1111,969,102,1176,101,148;40;F
27836;220,101,767,34,19,524,47,336,979,135;44;F
27877;525,570,203,101,220,102,1111,959,34,21,1303,819,336,958,216;44;F
28058;525,517,570,21,34,236,1176;48;F
28097;1092,1303,101,236,287,34,765;24;F
28156;1170,239,1176,1111,781,759,1652,287,34,1329,570,336,926,203,481;14;F
28171;236,101,766,959,478,271,287,765,336,711,135,270,946,767,948;45;F
28200;767,946,948,336;47;F
28245;819;42;M
28263;270,483,269,766,946,1170,1111,287,517,481,1176,203,336,135,478;23;M
28267;959,1111,1170,270,271,287,34,525,219,517,570,336,203,958,269;44;F
28279;101,946,287,148,781,271,1111,1170,1176,239,270,766,478,34,336;30;F
28287;525,135,781,478,47,524,336,483,21,34,287,236,102,1652,926;44;F
28303;767,271,781,148,948,956,819,517,481,1176,959,34,19,336,958;43;M
28305;711,1652,148,478,481,483;64;F
28317;948,287,956,34,525,819,816,517,570,336,203,958,481,269;40;F
28319;220,478,148;35;M
28355;271,1303,19,524,816,767,203,216,239;37;F
28369;287,19,336;39;M
28445;926,958,956,34,235,524,336,135;35;F
28463;46,148,956,21,1329,819,287,19,525,336,711,481,958,269,216;15;F
28518;47,19,336,478,959,946,1111,148,287,34,819,926,481,958,216;42;F
28523;19,101,148,759,524,525,47,1092,819,816,535,336,926;69;F
28571;781,148,948,287,34,235,819,481,958,270,959,271,1652,19,269;38;F
28574;959,148,759,287,956,34,1303,19,1329,816,926,711,958,269,216;35;M
28577;287,34,47,517,481;33;M
28592;287,765,1092,816,979,216,483,766,101,34,235,524,47,958,135;46;F
28632;46,34,1303,19,525,219,926,958,220,148,287,235,819,336,203;20;F
28640;478,1170,1176,766,102,19,148,34,524,47,535,336,711,979,483;62;F
28660;203,287,102,101,336,46,47;28;F
28669;46,767,102,1176,101,269,481,336,524,1303,287,271,1111,47,819;43;F
28676;203,979,958,269,135,219,271,767,959,201,270,220,336,765,1092;46;M
28682;1092,765,34,287,236,102,1176,101,766,946,959,767,948,956,958;47;F
28729;236,239,220,946,767,948,1652,34,235,47,816,336,926,979,237;10;M
28756;1092,766,101,1176,102,236,287,34,765,959,946,767,956,948,958;15;F
28804;46,1652,336,926,711,481,135;37;F
28811;1176,1092,765,34,287,236,102,101,766,946,959,767,948,956,958;13;M
28861;1170,1176,101,1111,478,287,34,524,336;32;F
28866;946,767,948,1170,236,148,1092,483;41;F
28872;1170,236,767,271,31,34,235,336,1176,1111,478,287,21,819,481;39;M
28875;1111,958,135,946,101,819,979,19,767,969,270,271,287,47,269;47;F
28902;481,946,1176,102,1170,236,1111,478,148,287,21,926;17;F
28930;1329,525,101,759,287,34,524,47,1092,535,570,203,979,481,216;30;M
28997;101,219,239,236,235,1329,926,237,216;46;F
29008;101,759,287,34,524,1092,336,483,135;39;M
29027;31,956,336,203,481,237;85;F
29032;766,1176,102,1170,1111,478,287,34,21,819,517,336,481,216,269;37;F
29057;1329,524,525,570,203;30;M
29063;31,956,34,524,47,336,203,481,958,237;77;M
29088;31,478,220,216,287,959,236,946,948,767;42;F
29097;959,1170,946,270,766,239,1176,201,1111,969,478,287,19,524,816;19;F
29100;946,46,287,765,203;41;F
29137;101,102,948,34,21,481,135;43;F
29194;478,1170,767,1176,271,781,948,287,34,765,19,819,336,481,958;45;M
29207;1303,819;47;F
29214;1176,102,236,1111,959,781,148,287,21,525,219,517,570,203,979;33;M
29224;1170,102,478,21,481,287,34,19,1092,570,979;57;M
29290;1329,524,525,570,203;72;F
29299;271,765,819,336,135;43;F
29302;1092,766,1176,102,236,1111,781,148,287,34,19,958,47,481,336;28;F
29310;269,135,478;34;M
29318;1329,524,525,570,203;71;F
29333;270,958,1111,481,946,767,271,948,287,34,765,19,819,336,135;39;F
29381;781,271,102,946,766,1176,1170,236,478,46,21,765,19,819,926;51;F
29395;1111,959,478,781,148,287,34,524,47,816,535,336,926,203,979;24;M
29402;1176,759,524,1092,481,1111,287;46;F
29407;216,236,102;34;F
29431;336,481,958,216,220,946,767,148,765,19,819,269,135,270,271;39;M
29450;766,220,101,767,781,135,203,765,525;36;F
29565;336,31,956,570,711,481,135;52;M
29633;201,239,946,220,969,236,767,759,34,1303,219,47,570,336,216;50;F
29669;101,524,570,711,203,979,237;39;F
29725;948,819,766,1176,1111,148,34,19,525,47,336,481,483,135,287;35;F
29743;1303,287,31,1111,1092,766,969,948,956,765,135,946,101,767,524;37;M
29750;767,271,948,287,34,765,19,525,819,570,336,203,958,269,135;28;F
29816;711,478,1111,236,1170,1176,1303,926,287,34,47,819,336,481,958;43;M
29912;31,239,270,766,1176,1170,1111,478,148,287,34,235,517,336,481;41;M
29942;135,239,1652,1303,1329,203;42;F
29973;1303,819;14;M
29986;483,237,711,926,336,47,235,765,34,31,478,946,948,135;32;F
29996;1303,819;11;F
30018;1170,478,47,236,1111,287,34,517,336,481,135;33;F
30026;946,767,148,948,765;34;M
30032;1303,819;8;F
30033;478,767,31,781,948,1652,287,34,765,235,47,570,336,926,135;9;M
30061;979,239,101,969,31,781,148,759,956,524,47,535,926,201,711;30;F
30072;766,781,759,481,287,34,765,524,336,711;30;M
30099;270,478,271,31,148,759,1652,34,524,47,336,926,979,958,269;36;F
30106;270,239,959,271,148,759,1652,287,19,47,336,979,958,237,269;36;M
30116;1170,236,517,336,711,203,958,481;42;F
30133;946,767,31,948,1652,34,765,235,47,570,336,926,711,958,135;7;F
30160;946,767,31,948,1652,287,765,235,1092,570,336,926,711,958,135;2;F
30170;759,1652,287,956,34,21,1303,19,219,481,237,1111,478,235,47;35;F
30215;766,236,478,287,34,765,336,481,483,135;34;F
30245;219,19,765,34,287,948,148,46,781,767,236,1176,946,336,216;31;F
30287;34,287,102,959,478,336,926;26;F
30351;101,946,766,478,34,819,926,767,1176,148,481,269,1111,336,239;15;M
30386;148,47,270,269,271;43;F
30392;270,271,269,135,1329,524,525,570,203;37;F
30419;270,271,269;36;F
30450;270,201,1111,271,19,47,336,269;33;F
30466;148,525,203,269,19,1176,1111,478,287,524,336,481,958,216,483;32;M
30467;766,239,1176,1170,236,1111,478,271,287,517,216,135;32;F
30490;481,1111,34,979,216,1092,524,1329,287,478,959,236,102,101,220;32;F
30501;148,336,481,203,219,1303;49;M
30523;239,766,1170,102,236,1111,478,46,34,21,235,47,517,481,135;42;F
30534;1329,34,956,287,148,478,101,239,270,236,759,235,47,271,269;37;F
30540;1329,524,47,336,979,958,287,926,956,1176,1170,102,1111,235,135;30;F
30555;1170,102,236,1111,959,478,287,21,524,816,517,336,979,958,216;15;F
30630;135,203,958,216,239,236,271,46,287,765,1329,47,517,926,481;35;F
30675;525,481,478,1111,1170,766,1176,102,148,287,34,19,524,336,135;30;M
30744;336,287,148,781,271,767,478,1111,1170,1176,819,535,517,711,958;32;F
30770;1176,1170,236,1111,287,47,517,481,216;41;M
30775;766,270,946,1176,1170,478,31,287,517,101,524,1092,535;27;F
30784;287,34,517,336,135;39;F
30793;270,766,959,781,948,524,47,958,19,478,236,287,34,336,135;42;F
30834;201,203;34;F
30836;203,979,535,46;41;M
30858;767,946,948;34;F
30859;270,271,269;11;F
30864;946,767,948;41;M
30885;481,1303,148,236,239,101,102,31,46,759,287,34,21,47,336;44;F
30893;270,959,271,269;7;F
30977;135;44;F
30979;101,1176,1170,478,287,336,481;49;M
30983;765,19,517,483,766,1176,1170,1111,478,148,287,34,336,926,481;27;M
31000;1176,1170,1111,478,287,34,19,525,219,816,517,336,926,203,483;36;M
31070;524,1329,34,1170,1176,101,270,766,1111,478,46,287,1092,570,336;43;F
31072;220,101,287,1329,47,1092,481;45;F
31100;287,19,47,816,535,926,203,979,216,239,336,958,270,271,269;40;F
31102;1176,1170,1111,478,287,34,235,517,216,336;45;F
31136;1176,31,148,819,816,135,946,101,1170,1111,478,271,219,47,517;27;F
31141;34,1652,46,31,1111,969,239,236,148,570,979,958,270,269,271;44;F
31145;819,1303;44;F
31153;946,478,959,47,517,203,216,220,1176,1170,1111,765,524,336,926;19;M
31281;1111,959,781,287,34,19,47,819,517,336,958;44;M
31327;235,148,31,101,270,102,236,271,956,34,21,524,816,237,269;44;F
31328;946,948,47;69;F
31332;781,765,711,481,237,1176,1170,102,478,524,47,517,926,979,216;14;F
31403;478,1092,216,47,926,135;30;F
31449;478,287,765,524,336,926;45;M
31513;478,524,19,101,270,271,148,1652,287,958,269;28;F
31522;239,1176,1170,969,1111,478,31,287,21,235,47,819,517,336,481;37;F
31555;270,271,269;45;M
31556;101,1111,46,21,47,517,481,216;67;F
31562;819,946,767,781,948,34,765,1303,524,525,1092,336,926,711,203;47;F
31600;958,19,148,271;35;F
31608;239,101,1111,271,948,34,235,1092,517,570,336,979,481,958,135;42;M
31676;270,101,271,148,1652,287,34,19,524,47,535,336,979,958,269;8;M
31685;946,766,781,819,102,287,34,765,1092,926,135,21;52;M
31686;239,46,956,235,219,517,237,979,478,1170,270,766,1176,201,203;45;F
31689;1111,759,765,47,979,101,478,287,336,926,135,946,1176,767,948;18;F
31691;478,759,34,979,216,101,1176,1170,236,1111,287,21,47,517,481;45;F
31747;270,236,1111,271,269;38;M
31755;524,535,135,926,336,34,287,948,781,767,236,102,1176,101,946;13;F
31829;1176,46,1303,47,816,570,287,235,336,135;34;F
31832;926,135;39;F
31862;959,31,46,759,958,269,236,781,948,287,34,819,336,481,1111;43;M
31879;819,481,216,135,220,946,1111,271,31,287,34,765,525,219,203;54;M
31888;287,1652,148,46,31,767,478,959,1111,969,102,1176,101,239,135;37;F
31954;220,1176,1111,959,46,148,948,287,47,819,336,203,481,958,135;22;F
31957;101,478,767,34,524,946,948;64;F
31986;31,148,336,201,203;39;M
31991;1111,478,31,287,34,765,525,219,816,517,926,203,481,220,1176;53;F
32021;19,481,979,926,336,958,959,101,483,570,524,1092,287;24;M
32092;478,781,34,819;38;F
32114;148,271,236,766,946,478,570,216,135,1303,235,525,219,816,203;49;F
32115;481,336,1111,478,287,969,236,570,270,946,101,271,759,524,269;38;F
32121;1329,47,570,926,979,102,236;46;F
32134;236,1111,478,287,517,926;50;F
32204;1111,102,220,1170,1176,236,959,759,287,524,47;31;M
32256;948,287,956,819,570,203,483,271,759,34,765,19,47,336,135;42;M
32265;525,235,287,236,270,271,34,765,336,979,203,237,269,483,135;43;F
32350;1111,781,34;71;M
32390;31,1303,819;34;F
32431;216,1176,102,969,1111,781,287,34,21,1303,1092,819,336,203,481;43;F
32486;270,946,767,948,269,271;35;F
32491;239,135,483,958,979,47,766,481,517,270,1176,1170,1111,478,287;30;F
32508;31,1652,19,235,1329,525,219,570,926,958,201,781,34,336,203;36;F
32528;926,34,781,958,239,270,220,959,271,31,759,1652,19,336,269;41;F
32620;766,1111,478,287,19,47;28;F
32639;287,34,19,135;34;F
32762;759,287,34,21,1329,219,483,101,102,765,524,47,926,135,979;54;F
32780;336,239,102,236,21,1303,219,525,47,926,481,237,1111,287,819;36;F
32787;959,19,570,336,239,236,1111,287,1303,525,219,819,926,481,237;37;M
32800;759,570,336;19;M
33014;1176,1170,1111,287,336,517;27;M
33133;1176,1170,478,287,34,336,481,135;41;M
33169;1176,1170,767,287,819,517,570,481,269,483,148,948,34,765,336;39;M
33185;336,1652;49;M
33211;270,271,269;42;F
33224;1111,220,287,19;30;M
33228;483,135,766,220,1176,1111,767,781,46,287,765,47,819,535,336;48;F
33230;1111,478,271,148,819,958,481,287,34,765,336,135;39;M
33341;1176,1170,102,236,1111,478,287,21,926;48;F
33343;239,1176,781,1652,34,19,525,47,958,271,1303,336,269,270,517;42;F
33369;102,956,235,1303,1092,816,926,979,781,1652,34,1329,219,336,203;41;M
33415;958,781,478,236,287,1329,525,1092,336,926,1176,1170,1111,1652,19;40;F
33612;271,31,46,1652,287,34,1303,19,235,524,525,47,819,816,570;33;M
33616;239,1111,1652,1303,525,517;44;F
33650;766,1170,236,959,31,148,235,926,483,102,478,34,765,336,203;47;M
33686;946,239,101,969,767,46,948,524,47,535,135;39;F
33711;946,1111,767,46,948,47,1092;51;F
33720;481,958,946,1176,959,767,781,148,948,287,34,765,19,135,336;42;M
33726;271,148,948,19,819,926,1176,1170,1111,478,287,34,517,336,481;36;M
33766;236,102,19,481;21;F
33850;946,1111,478,767,271,948,765,570,135,483,287,819,336,926,711;37;M
33867;517,819,148,767,102,1176,1170,1111,287,34,21,19,336,481,958;48;M
33871;517,336,711,481,958,270,1170,102,1111,959,478,287,34,21,19;44;F
33943;336;27;F
33952;236,336,481,220,1176,1170,1111,478,287,34,524,47,816,979,216;42;F
33979;19,219,1092,336,203,101,1170,236,46,47,819,535,926,481,216;43;F
33993;478,287,34,235,47,816,517,481,946,1111,135;65;F
34007;1111,46,19,235,524,47,816,517,336,926,481,958,759,1652,287;38;F
34094;956,19,816,336,958,239,34,517,478,781,1111,1170,287,21,481;45;M
34105;269,481,819,21,946,767,948,19,236,34,336,958,237,216;40;F
34112;525,135,237,926,336,47,34,765,781,31,236,766,946,767,948;35;F
34180;1176,759,1652,287,19,235,524,47,816,517,336,926,481,958,1111;38;M
34203;767,948,517,135,819,47,816,766,1176,148,287,34,765,19,336;28;M
34212;31,235,47,816,336;31;F
34303;336,287,946,201,203;47;M
34317;1170,102,759,34,958,216,236,1111,478,46,19,1329,517,926,481;47;M
34331;958,517,19,1170,1303,819;46;M
34359;946,201,1111,287,203;13;M
34375;781,524,816,481,237,759,235,336,287,34,19,958,270,271,269;35;F
34376;203,236,270,34,483,1170,765,47,1176,766,946,1111,287,336;30;M
34378;946,201,1111,287,203;11;M
34379;270,271,19,269;69;F
34392;946,201,1111,287,203;46;F
34440;781,21,819,926,1176,1170,1111,31,287,956,34,47,517,336,481;38;F
34463;287,336;27;M
34499;1092,781,270,759,1652,19,269,336,271,148,287,524;40;M
34575;1111,478,781,287,483,102,926,269,525,570;52;M
34588;336,1170,236,1111;26;M
34597;926,979,481,237,236,21,1329,47,336,711,216;48;F
34630;767,570,135,271,31,34,819,336,47;39;F
34636;1329,524,525,570,203;78;F
34678;759,287,765,524,1303,926,239,1111,271,269;40;F
34687;101,201,102,236,1111,31,46,287,34,21,19,47,819,535,237;4;F
34690;235,19,1303,478,102,270,239,271,781,34,269;44;F
34706;524,239,1170,236,959,478,781,1652,34,19,517,336,926,979,481;41;F
34732;239,34,1303,336;37;F
34769;148;43;F
34817;946,478,148,287,19,524,336,203,958,481,220,781,34,1092,711;40;M
34818;478,781,524,525,570,203;74;F
34833;1329,926,958,478,287,1092;40;F
34842;101,102,478,781,148,287,34,926,711;46;M
34854;101,46,148,1329,525,219,203,979,481,1170,1176,1303,47,816,570;35;F
34866;781,948,765,19,524,1092,570,481,958,483,135,478,287,34,926;47;F
34905;979,969,781,1652,956,765,1329,1092,816,926,237,216,483,336,958;35;F
34925;287,517,1111,1170,1176,216;30;M
34960;19,781,478,959,31,101,135,969,239,34,47,525,946,767,948;35;F
34969;31,220,46,1329,524,101,102,478,1092,47,535,336,203,979,135;66;F
34970;535,47,958,926,525,570,524,1092,287,19,336,34,946,767,948;36;M
34982;101,102,959,767,781,287,34,21,1303,524,525,47,816,336,958;34;F
35009;948,235,819,237,483,969,946,101,236,1652,47,336,979,216,1303;37;F
35015;956,765,19,958,237,269,135,336,781,287,34,524,525,1092,570;48;M
35032;270,766,336,102,478,31,1652,287,21,1303,47,926,481,216;43;F
35041;767,46,287,765,235,819,237,216,135,236,948,1652,1303,47,816;43;F
35055;31,478,236,220,239,946,767,1652,956,34,1303,235,47,336,926;5;F
35091;525,46,1111,102,201,946,478,767,948,287,21,765,524,47,816;21;F
35110;1176,239,220,287,34,19,235,525,336,926,481,237,236,1111,1652;39;F
35112;19,525,959,478,1652,287,336,481,958,216;45;M
35117;1111,34,481,19,336;30;M
35148;767,525,570,336,958,979,1092,781,31,236,101,239,34,47,1303;55;F
35149;1176,1170,1111,478,767,781,948,287,34,47,517,336,711,481,958;45;F
35151;524,979,946,948,235,47;35;F
35182;819,765,948,31,102,766,1176,1111,478,34,47,517,336,269,216;39;M
35189;478,759,19,1329,819,203,235,524,781,148,287,34,926,711,958;44;F
35198;767,948,135;37;F
35229;34,535,979,239,1652,1303,47,336,926;39;F
35239;201,1111,148,34,19,525,570,336,926,203,481,216,102,46,47;43;F
35255;270,481,948,1652,46,271,236,220;18;F
35258;47,336;51;F
35260;1303,1329,524,47,816,517,481,135;41;F
35395;765,19,269,135,946,1176,271,767,948,287,21,34,525,819,570;33;M
35429;287,336,958,203,481,216,1176,1170,236,517;41;F
35439;219,517,34,1170,1176,946,1111,203,525,1303,21,287,46,478,236;39;F
35457;1329,958,31,956,235,525,926,287,21,524,47,478,759,1092,481;63;F
35462;271,19,524,336,759,34,1303,47,819,481;43;F
35485;1303,235,1329,819,816,926,711,203,958,220,102,236,31,524;44;F
35576;946,478,46,287,819,336,481,483,47,148;46;F
35599;1176,270,766,1111,287,517;37;M
35647;524,535,336,481,958,216,1176,101,946,220,478,287,34,926,235;31;F
35650;525,570,946,270,766,34,1303,524,1111,478,287,47,517,336,203;80;F
35669;101,236,1111,287,34,819,1170,1176;45;M
35731;220,1176,1170,1111,478,287,517;19;M
35770;102,21,524,336;54;M
35871;819,19,765,34,287,781,478,1111,1170,1176,101,524,47,1092,336;47;F
35895;220,1170,46,1329,524,47,926;23;F
35919;135,19;33;F
35955;34,1303;32;F
35989;219,287,148,1111,236,102,1176,239,220,336,203,979,958,237,216;19;F
36014;1652,781,969,1170,1176,239,236,1111,478,31,287,34,524,1092,926;37;F
36028;946,239,31,148,948,1303,47;32;F
36072;148,287,336;35;M
36081;336,926,203,216,1176,236,759,235,525,237,102,46,148,1652,21;40;F
36089;959,271,759,34,525,1092,481,269,239,236,235,819,517,958,135;43;F
36098;220,31,781,46,1652,34,765,1329,524,47,816,535,336,979,135;49;F
36118;135,203,959,287,34,1303,19,958;43;F
36165;517,958,483,135,481,336,478,101,1176,216,1170,1111,287,34,47;45;F
36207;46,101,270,766,239,1176,1111,31,948,287,1303,235,525,336,979;38;F
36271;483,525,19,765,1111,236,1170,102,958,101,1652,287,34,21,47;43;F
36414;926,287,1652,478,1111,969,1170,958,336,1092,19,34,270,271,269;48;F
36443;19,47,816;29;F
36480;517;50;M
36495;101,34,765,47,135;54;F
36530;220,946,239,201,236,767,948,765,525,819,816,336,979,269,216;16;M
36536;517;50;F
36573;517;19;M
36583;481,47,478,1170,766,1111,781,525,219,203,46,287,34,336,236;53;F
36620;478,517,1111,287,336;47;F
36755;478,287,819,1176,1329,517,481;74;F
36802;1092,34,47;52;F
36826;766,946,270,235,524,525,219,47,979,220,239,102,21,1303,216;44;F
36894;148;48;M
36914;1176,946,270,220,766,19,524,525,816,336,236,1111,287,47,517;15;F
36990;1176,478,46,287,525,1092,711,216,135,236,1329,926;41;F
37142;102,287,21,524,47;45;F
37179;946,767,31,948,34,765,1303,235,336,926;10;F
37208;1176,1170,765,19,517,336,481,135;36;M
37225;946,481,766,270,1111,483,269,287,478;49;F
37232;524,47,1092,816,926,203,711,481,201,781,34,21,765,570,979;49;M
37242;767,948,21,765,336,958;15;M
37301;135,781,926,287;40;M
37325;926,979,216,102,47,1092,483,946,478,767,781,948,287,524,34;41;F
37332;31,101,239,271,767,759,47,819,236,148,34,336,711,269,1303;29;F
37370;478,31,148,287,201,135,766,765,1303,203;53;F
37381;236,781,1329,926,483,766,946,478,767,948,287,34,765,19,336;49;F
37416;19,21,34,759,781,1111,47,1092;48;F
37427;287,34,19,47,819,816,570,336,711,203,958,269,216,135,1303;53;F
37453;946,101,767,781,948,517,336,481,524,765,34,287,478,236,766;46;F
37457;336,47,19,34,948,148,767,1111,236,969,1170,1176,239,1303,711;56;M
37532;481,336,34,1170,239,816,478,47;49;M
37534;1092,101,102,21,46,47;55;F
37553;483,336,570,517,525,524,1329,1111,239,1176,1170,236,478,759,287;37;F
37562;216,135,236,946,270,766,525,219,336,483,759,287,34,1303,524;38;F
37575;270,1170,148,478,767,781,517,1303,766,948,287,34,765,336,135;49;F
37601;1176,1170,478,781,287,34,336;41;M
37624;483,979,816,34,1111,478,781,1329,524,481,102,21,711;43;M
37636;287,765,19,235,1329,819,517,570,979,237,269,34,336,926,216;13;M
37707;34,766,270,102,236,1111,148,21,336,926,481,216,483,478,287;35;F
37721;336;27;M
37775;483,766,946,1176,1170,102,1111,478,148,287,524,219,816,336,481;26;M
37784;1176,959,271,287,34,19,525,219,819,336,926,203,481,269,1652;46;F
37880;236,969,958,1111,47,946,570,336,148,271,759,948,1652,819,269;33;F
37886;1176,287,336,711,781,956,34,47,969,1111,31,819,926,1652,481;37;F
37896;1111,269,271;38;M
38011;1176,946,270,220,766,239,101,478,31,517,979,481,287,711,524;29;F
38016;270,271,269;37;F
38089;1176,1111,959,271,287,34,1303,19,819,517,336,203,481,958,135;38;F
38133;759,239,101,1111,287,34,47,517,481,958,237,216,956,524,819;38;F
38136;766,969,956,765,1303,524,47,926,287,481,237,946,948,767;39;F
38207;148,21;50;M
38254;517,481,781,287,34,1170,1111,959,478,19,336;38;F
38266;766,101,478,46,759,1652,287,816,535,570,979,216,926;47;F
38347;220,1170,34,336,524,1303,819;42;F
38358;711,483,135,956,1303,235,47,336,926,481,237,766,946,767,948;46;M
38373;47,517,570,336,958,481,269,766,1176,201,1111,478,31,287,21;34;F
38384;1176,1111,1329,47,203,481,1170,969,21,336,926,979,478,287,34;45;F
38406;781,148,948,287,34,765,1303,19,47,517,203,481,237,483,135;25;F
38408;34,1303,1329,524,336,926,711,135,237,481,766,946,767,948;8;F
38478;946,767,271,948,1303,19,819,336,958,269,483,216,236,34;30;F
38486;959,287,1092,816,216,1176,1170,102,1111,148,21,535,336,979,481;49;F
38490;956,219,336,481,1111,959,759,287,19,711,203,958;35;M
38522;766,1176,781,287,34,765,336,135;43;F
38571;517,47,1176,1170,1111,478;26;F
38578;969,101,270,269,271;46;F
38579;34,816,517,1176,1170,1111,781,287,956,1303,1329,336,926,203,481;33;M
38668;946,1111,148,19,219,336;22;M
38745;31,956,237,711,1176,1170,236,1111,287,517,926,481;38;F
38772;47;42;F
38802;216,19,31,236,1170,239,1111,21,47,336,481;34;F
38817;1176,1170,236,1111,959,478,781,148,34,525,47,336;41;F
38847;19,525,336,958,239,1176,236,1111,1652,287,34,1303,47,517,819;34;F
38853;766,101,1176,1170,1111,478,287,819,336,481,958;47;F
38899;483,135,958,926,336,239,1111,478,31,287,34,765,1303,19,235;35;F
38930;148,34,1092,819,481,946,767,781,948,287,483,135,766,765,336;35;M
38942;956,19,235,819,336,958,237,1176,1170,478,31,287,517,926,481;37;F
38972;766,946,1111,46,816,481,102,236,287,34,21,524,47,336,926;24;F
39017;336,239,31,759,47,287;34;F
39031;101,946,781,46,948,1652,287,19,235,47,535,336,481,958;7;F
39033;271,148,765,524,1111,1176,478,781,287,34,517,336,926,481,269;17;M
39096;135,946,767,948;68;F
39124;219,926,203,216,483,946,236,34,336,1176,1111,478,287,517,481;29;F
39196;135,481,203,570,525,478;45;F
39234;946,239,767,781,948,1652,34,235,47,535,336,926,979,481,135;35;F
39240;959,478,765,19,47,926,979,958,135;42;F
39247;236,1111,478,1652,34,19,524,517,535,336,926,481,958;48;F
39248;483,270,946,765,1176,1170,478,1329,819,926,481,766,1111,287,34;14;M
39369;287,336,517;37;F
39402;21,235,525,819,517,203,269,216,220,1176,1111,287,34,336,481;44;F
39408;135;40;F
39494;1170,236,478,287,34,926,979,1176,1111,1329,47,517,336,481,216;31;F
39503;525,235,271,959,101,203,239,236,1111,31,46,759,1652,287,1303;37;F
39504;819,524,19,34,287,478,101,946,766,767,948,765,336,711,135;39;M
39507;766,765,135;31;F
39563;969,101,478,524,1092,336,47,34,287,31,102,946,767,948,135;35;F
39575;524,219,819,570,336,203,979,481,269,946,101,1176,1111,34,517;39;F
39590;766,270,1176,1170,478,1111,46,287,525,219,517,336,926,203,483;26;F
39623;236,1111,478,1652,287,926;16;F
39628;766,946,1111,287,34,524,336;47;M
39638;31,47,816,711,958,1303,239,102,336;35;M
39666;969,926,237,135,34,46,101,781,1652,287,765,766,946,767,948;41;F
39668;102,336,216;34;M
39684;1170,1111,478,287,34,19,524,517,336,481,135;26;F
39709;478,1111;48;M
39736;1111,478,781,1652,287,34,235,766,236,765,219,135;39;M
39751;525,570,203,220,239,236,235,219,816,711,979,237,216;52;F
39831;102,1111,236,766,946,767,31,948,956,765,235,336,135;33;F
39914;765,956,235,926,135;30;F
39963;765,287,948,46,236,478,34,1303,336,481;42;F
39992;1176,1170,1111,478,287,517,336;29;M
39993;958,1111,1176,270,271,926,269;42;F
40024;766,101,236,478,781,287,34,1329,524,219,47,336,926,979,216;54;F
40047;1170,336,819;48;M
40097;956,1652,31,101,271,287,34,765,235,524,47,269,135,216,1303;46;F
40120;959,148,287,34,765,19,525,219,570,336,926,203,979,481,135;41;F
40132;1176,270,271,958,269;10;M
40191;270,271,926,958,269;8;M
40226;926,1176,270,271,958,269;6;M
40238;269,102,220,34,21,19,517,570,481,336,958,236,1111,1303,819;46;F
40240;1329,524,711,816,239,1176,1170,959,31,781,1652,47,481,958,237;39;F
40281;34,525,47,819,535,237,483,969,101,478,271,956,21,269,135;33;F
40383;239,220,236,287,34,1303,235,47,336,135;36;F
40410;481,34,19,517,926,958,269,766,270,1176,1111,271,287;43;M
40427;270,271,19,269;22;F
40476;270,271,926,958,269;81;F
40492;570,819,19,336,47,524,765,948,767,236,101,239,946,926,135;44;F
40504;926,270,271,269;85;M
40523;135;43;F
40541;1170,34,765,19,336,481,483,270,946,220,1176,1111,478,759,287;35;M
40553;1176,1170,1111,478,148,34,21,481,819;58;M
40576;767,979,21,525,102,101,34,765,1329,524,1092,816,570,336,135;53;M
40620;483,336,101;18;F
40623;1170,781,1111,517;51;M
40735;270,271,926,269;75;F
40741;481,19,781,31,271,959,101,956,34,1303,816,336,926,269,270;46;F
40749;271,101,270,765,570,481,216,236,287,34,766,483,478,1329,926;33;M
40781;235,958,766,1176,765,819,336,481,287,148,1170,1111,34,19,926;40;M
40876;203;72;M
40877;203,220,946,239,101,767,31,781,948,34,235,524,525,336,926;29;F
41040;270,271,269;32;F
41114;1176,766,270,1111,148,287,336,478,765,19,926,481,483;39;M
41147;1170,47,816,517,958,481;37;F
41210;1111,236,102,1170,478,46,287,524,525,47,819,517,481;41;F
41331;1111,21,816,203,958,216,946,478,148,287,34,47,481,19,336;32;F
41343;956,21,1329,958,1111,478,781,287,481,216,1176,517,336,1170,1652;37;F
41344;765,148,766,101,102,781,1652;60;M
41363;1176,1170,478,287,926,517;38;F
41370;101,34,948,31,271,767,239,148,1303,19,956,235,524,816,336;36;M
41396;946,1111,478,271,948,287,956,34,765,235,819,336,926,481,483;36;M
41404;570,336,979,958,766,102,956,34,765,235,524,926,711,216,135;41;F
41417;1176,1170,969,1111,478,46,287,34,21,765,47,525,203,481,517;24;F
41476;1092,47,819,816,336,570,926,711,203,979,481,958,269,148,34;36;F
41485;239,946,270,220,766,1176,201,959,478,948,47,336,269,287,34;40;M
41507;781,926;36;M
41512;1176,101,201,969,236,287,1303,524,47,816,535,958,483,239,926;32;F
41580;239,102,236,959,21,926;43;M
41585;478,270,766,946,1176,1170,1111,948,1652,287,765,19,819,517,336;37;F
41590;271,781,287,21,235,524,269,767,31,148,956,34,1092,819,216;30;F
41637;946,767,948;47;F
41654;236,524,47,517,336,481;33;F
41672;19,271,269,46,1652,958;38;F
41675;766,946,767,948,34,765,336,958,135;7;M
41691;781,525,336,1176,1111,478,148,287,34,19,524,47,1092,481,483;45;F
41695;766,946,767,948,34,765,19,336,135;3;M
41728;269,270,101,102,1111,236,478,759,287,21,1329,524,1092,979,481;77;F
41730;478,148,956,34,765,1329,524,47,816,336,926,979,958,483,287;31;M
41735;287,236,1170,1176,101,1111;47;F
41764;216,926,816,47,19,478,781,287,765,1329,958,135,336;51;M
41774;269,481,336,570,816,819,235,1303,765,948,287,34,47;42;F
41775;270,1176,478,34,19,47,535,336,958,483;44;F
41825;766,1111,287;41;F
41895;816,148,336,979,269;40;F
41901;336,1303,34,148,46,239,102,959,270,236,271,19,819,216,269;40;F
41921;135;28;F
41944;31,46,570,1111,1176,766,1170,517,135,946,478,781,287,926,481;48;F
42000;31,102,1111,287,21,235,47,1092,336,478,148,34,819,570,481;38;M
42015;483,135,1170,148,19,926,517,766,1176,1111,478,287,34,336,481;41;M
42040;926,958,766,946,1176,1111,767,781,948,287,34,19,1329,336;26;M
42332;46,287,336;43;M
42377;765,483,946,1111,759,220,1176,201,46,1303,525,219,47,336,203;18;F
42378;220,766,1176,102,236,1111,478,46,148,287,21,219,483,481,203;22;F
42379;46,47;37;F
42507;101,781,46,1329,524,525,1092,336,102,1111,1170,1176,239,236,759;45;M
42521;271,819,135,946,781,148,765,19,570,481,216,478,287,34,336;49;F
42551;34,1303,819,236,31,956,235,336,237,711,926,781,946,767,948;37;F
42564;287,47,1092,535,336,269,483,766,148;61;M
42572;236,1170,102,1111,19;34;M
42590;1092,926;63;F
42643;101,148,287,524;43;M
42653;478,287,34,235,336,979,481,483,135;38;F
42703;1111,781,34,765,336,19,1652,979,481;36;F
42726;220,239,201,102,236,959,21,535,926;43;F
42736;239,46,34,525,926,336,270,766,1176,1170,1111,478,287,517,481;63;F
42764;926,1303,766,1176,1170,1111,478,46,287,1329,819,517,203,481,483;48;F
42784;766,946,478,767,781,759,948,34,765,926,979,711,483,135,1329;23;M
42885;220,1329,969,765,524,47,1092,816,336,926,979;46;F
42912;483,979,517,287,478,1170,1111;39;F
42918;1652,287,34,135,766,946,767,948,765,336,926;34;F
42943;287,34,478,236,781,271,766,270,946,767,948,765,336,711,135;44;M
42946;236,781,287,34,19,926,481,237,269,271,46,1652,21,47,535;59;M
42955;478,46,1303,524,525,219,47,816,535,570,926,203,958,481,483;34;M
42957;135,948,271,766,946,1176,102,1111,46,21,19,819,570,926,481;52;M
42964;31,34,236,287,956,235,1329,524,1092,570,926,481,958,237,483;33;F
42965;270,269,271;50;M
43008;946,959,287,34,19,336;30;M
43031;766,946,478,767,948,1652,287,34,765,336,926;4;F
43042;570,1092,34,1652,781,1170,102,236,1111,478,287,21,819,336,481;39;F
43046;1092,102,21,336;50;M
43061;203,1111,236,271,781,46,1652,21,19,47,535,926,237,481,269;84;F
43068;336,926,711,481,958,237,236,34,235,219,216;33;F
43080;766,946,236,767,948,1652,287,34,765,336,926;4;F
43095;270,1176,1170,1111,271,1092,819,336,269;33;F
43133;235,1329,819,102,1652,765,525,47,570,135,1303,287,34,336,926;36;F
43136;1329,483,481,336,816,47,19,34,287,148,1111,236,1176,239,946;38;F
43186;766,1170,1111,478,287,34,765,19,1329,219,517,336,203,481,483;31;M
43188;819,946,767,948;35;F
43200;270,1111,271,31,148,287,34,1092,819,517,570,336,481,958,269;38;M
43206;239,236,478,287,34,765,1303,1329,524,816,570,766,525,336,203;48;F
43270;1176,1170,1111;38;F
43272;766,1170,1111,478,287,34,765,19,1329,219,517,336,203,481,483;31;F
43276;1111,478,271,31,148,287,34,19,819,517,570,336,481,958,269;2;F
43310;958,336,34,959,148;31;M
43330;235,19,102,239,34,336,1303;41;F
43333;270,1111,478,271,31,287,34,524,819,517,570,336,481,958,269;6;M
43356;270,1111,478,271,31,287,34,819,517,570,336,926,481,958,269;8;M
43357;711,336,979,958,19,34,956,31,21,481,959,483,478,926,287;30;M
43387;766,46,148,336,481,483,517,34,287,781,478,1111,1170,1176,270;27;F
43395;148,47,336,926,979,270,271,269;24;F
43504;517,19,1170,946,1176,236,1111,959,781,287,34,819,336,481,216;44;M
43547;483,819,948,478,101,956,269,271,1176,1170,517,19,287,1111,336;34;F
43549;711,220,203,483,216,979,926,1092,47,1329,34,781,236,102,101;52;F
43553;517,481,269,1111,135,236,270,766,946,478,148,287,34,336,483;28;M
43561;287,219,926,203,236,1111,478,235,524,525,47,1092,819,711,979;49;F
43640;203,1303,1329,816,926,711,481,959,478,781,46,759,47,336,570;50;F
43656;46,287,47;31;F
43712;525,959,102,478,148,287,34,819,483,481,1176,1170,1111,336,517;57;M
43758;481,483;66;F
43780;1329,524,525,570,203,135;69;F
43869;148,759,1652,287,34,19,235,524,47,1092,816,517,336,481,958;45;F
43962;1176,478,287,19;23;F
43994;1092,759,959,1176,1170,969,1111,271,781,1652,956,481,483,1303,819;37;F
44005;781,956,148,1652,1303,47,203,236,31,759,34,525,570,336,481;36;F
44006;959,483,216,926,336,219,47,525,1329,34,287,148,478,236,102;43;F
44042;767,946,135;35;M
44159;481,524,34,759,781,478,1111,102,148,287;59;M
44196;956,524,47;41;M
44215;270,1652,34,47,237,269,271;35;F
44220;1303,34,819,336,101,102,767,148,948,765,525,47,570,237,135;46;F
44230;270,271,269;9;F
44252;271,269;41;M
44260;270,271,269;10;F
44428;216,766,478,781,46,956,336,269,1170,1111,287,524,525,517,481;35;F
44432;201,203;74;F
44435;201,203;79;M
44453;959,816,926,979,237,535,101,102,969,31,759,956,34,524,47;31;F
44460;1176,1170,1111,517,481,483;69;F
44497;948,271,767,236,1170,1176,1111,46,287,34,19,819,336,481,958;46;F
44519;1111,287,19,524,958;34;M
44522;270,271,269;47;F
44577;34,525,517,336,269,946,1176,767,148,135;25;F
44588;287,34,19,525,47,570,336,979,270,271,269;45;F
44619;1303,1111,239,1176,1170,478,31,287,34,235,525,219,517,336,483;28;F
44626;926;50;M
44666;102,759,969,101,220,236,478,46,1303,47,336,203,958,216,483;79;F
44771;46,19,235,524,47,819,336,926,481,269,236,148,1652,287,517;42;F
44780;216,101,201,1170,478,781,34,19,524,47,1092,816,535,336,979;48;F
44784;524,19,1111,478,287,34,926,481,483;34;M
44794;201,478,271,946,767,948,287,34,765,47,535,570,336,711,135;41;F
44799;101,1111,271,958,269;35;M
44816;336,31,959,239,1176,1170,102,236,1111,781,287,21,570,481,216;39;F
44856;270,271,269;30;M
44871;270,271,269;33;F
44882;239,1111,287,956,765,525,816,946,767,948,517,926,711,203,135;13;M
44953;1176,946,1111,478,287,1652,102,926;51;F
45095;270,239,101,1111,271,148,287,235,524,819,336,926,979,958,269;5;M
45158;1111,287,34,21,765,19,336;23;M
45171;235,34,956,1652,759,148,31,969;38;F
45181;483,135,524,1329,1303,34,956,31,969,102,239,101,478,781,287;7;M
45198;1176,1170,1303,819,481;47;F
45231;1176,1170,1111,478,31,148,287,34,765,525,570,926,711;32;M
45269;767,946,948,135;35;F
45289;570,201,979,535,34,237,135,101,766,102,31,765,235,524,926;50;F
45307;766,1170,1111,478,148,46,287,34,19,1329,819,336,926,979,958;14;F
45327;1176,236,1111,767,271,148,46,287,34,819,517,336,958,269,135;46;M
45344;102,236,1111,31,287,34,21,1303,525,819,336,203,135;44;F
45381;478,47,926,135,946,767,948;22;M
45395;979,535,47,524,34,46,236,102,1652;50;F
45412;237,524,483,101,1176,287,19,816,336,1170,926,203,481,135,216;55;F
45453;481,483,766,478,781,287,34,524,336,926;28;F
45473;525,570,203;41;F
45486;767,781,816,216,270,478,34,765,524,525,1092,535,570,203,269;48;F
45519;237,570,517,19,1111,766,1170,236,478,287,34,336,926,958,483;39;M
45596;239,287,958,47,816,819;35;F
45606;1329,766,270,1176,517,483,819,926,481,478,1170,948,336;46;M
45619;1170,1176,270,271,148,287,34,19,47,1092,570,336,958,269,135;52;F
45637;483,481,336,517,19,765,948,767,478,1111,1170,1176,766,135,287;54;F
45705;47,481,483;60;F
45735;271,148;44;F
45749;765,271,1170,946,220,766,1111,336,287,34,478,235,1303,135,203;35;F
45750;271,148,19,819,336,926,135,236,1111,287,956,34,47,481,237;37;F
45761;19,819,336,958;37;M
45771;535,481,237,269,101,1176,1111,478,31,47;45;F
45790;236,19,481,1176,1111,148,219,203,478,766,287,765,781,34,336;53;M
45826;46,1176,1170,236,1111,287,34,19,219,47,819,517,336,481,216;48;F
45835;148,34,481,1303,819;38;M
45869;1176,1111,101,1170,478,781,759,34,524,1092,481,237,216,47;15;F
45878;1176,31,478,969,1170,979,47,1329,237,216,236,239,235,220,219;65;F
45886;236,287,34,219,216;66;F
45901;101,1176,1170,1111,478,287,47;10;M
45907;101,781,1111,956,19,959,767,926,946,148,948,287,34,336,958;37;M
45938;766,270,1176,1170,1111,478,287,34,570,336,926,958,237,216,483;10;F
45988;1176,1170,236,1111,478,148,34,19,819,336,926,481,958;52;F
46000;1170,236,1111,478,781,287,34,19,517,570,336,958,237,216,483;8;M
46057;766,1176,236,1111,478,46,287,34,517,570,926,958,237,216,483;5;M
46069;1176,1170,236,1111,46,287,34,19,219,47,819,517,336,481,216;47;M
46085;1176,1170,236,1111,46,287,34,19,219,47,819,517,336,481,216;15;M
46107;816,203,135,220,101,102,236,767,287,956,765,524,525,517,336;25;F
46116;148,767,236,969,101,759,21,1329,525,47,203,481,237,269,216;41;M
46154;781,203,483,766,1176,1111,478,287,34,336,481;29;F
46181;135;36;M
46182;1170,203,216,979,766,1176,101,236,478,287,34,21,47,336,481;20;F
46258;201,203;78;F
46264;819;45;F
46268;201,203;54;M
46278;201,203;87;F
46285;201,203;83;F
46287;270,271,269;48;F
46297;946,767,271,759,948,1303,958,148,19,481,483,34,287,781,926;32;M
46305;201,203;84;F
46321;201,203;72;F
46328;201,203;82;F
46329;765,34,148,946,1176,1170,1111,478,287;20;M
46336;201,203;82;F
46345;201,203;71;M
46353;201,203;75;F
46360;478,1111,1176,946,270,766,1170,767,148,948,287,34,765,19,336;56;F
46367;201,203;75;F
46383;201,203;75;F
46385;31,759,517,926,481,524,1111,1170,1176,236,478,46,287,47,216;29;F
46394;201,203;77;F
46403;201,478,524,525,203,481,483,135;66;F
46404;270,517,481,483,766,478,1176,1170,1111,148,287,926;31;M
46412;478,34,19,336,287,46;20;M
46413;1176,1111,102,478,287,21,765,19,47;57;F
46441;201,478,524,525,203,481,483,135;70;F
46448;102,1111,959,287,34,21,524,819,517,336,216;39;F
46457;481,711,336,816,819,1092,969,239,271,31,956,34,235,47,926;36;F
46491;148,767,959,969,766,220,101,102,271,31,956,47,816,958,269;33;F
46500;1303,819;49;M
46552;969,31,956,34,19,517,570,926,958,959,1111,236,201,102,21;36;M
46599;481,958,101,102,271,148,21,570,269;49;F
46612;1176,1170,969,236,1111,31,287,34,19,47,819,517,336,481,237;38;F
46658;203,481,958,237,766,946,478,271,948,524,819,767,287,765,269;46;F
46662;201,203;58;M
46672;19,34,959,236,270,766,1176,1170,1111,478,287,517,336,926,481;19;M
46679;236,201,958,203,926,336,517,46,766,1176,1170,1111,959,478,287;35;F
46715;948,19,21,765,819,517,570,958,269,483,135,1111,959,759,481;31;F
46725;1170,236,959,478,287,956,19,926,481,958,336,1176,1111,1652,517;11;F
46732;1176,287,1111;43;M
46736;220,1111,287,47,336;39;F
46739;979,766,1176,201,1170,1111,959,478,781,287,34,1303,525,336,958;35;M
46788;235,216,481,31,1652,287,524,1092,336,926,979,946,767,948,135;37;F
46797;969,478,959,148,34,1303,47,570,926,481,101,102,287,765,336;38;F
46799;481,926;17;M
46824;239,21,235,336,926,481,270,271,148,524,47,958,269;38;F
46864;239;37;F
46940;135,269,481,336,34,287,1652,46,31,271,767,1111,1303,819,1176;34;F
46961;819;48;F
47026;220,1176,1170,1111,287,34,517,336,481,269;38;M
47095;766,21,483,135;46;F
47148;946,767,948,34,336;43;F
47165;201,203;77;F
47184;101,1176,478,287,524,336,481;30;F
47185;946,767,948,336,135;8;F
47188;46,759,19,1329,524,525,219,47,958,216,236,34,819,336,203;51;F
47192;766,946,1176,1170,1111,287,517,336;33;M
47207;946,767,948,336,135;10;M
47223;946,767,948,336,135;13;M
47235;1652,956,34,765,1303,525,1092,816,570,336,711,979,958,969,1329;31;F
47240;767,946,948,336,135;65;F
47244;101,1176,1170,102,236,31,287,956,34,21,524,535,517,481,216;34;F
47254;517,135;37;M
47264;1111,102,948,287,34,19,47,819,816,481,148,478,1170,1176,101;23;F
47278;819;31;F
47297;239,969,236,287,765,235,816,570,767,478,781,34,524,47,336;39;F
47299;926,336,766,287,524,201,203;20;F
47306;781,34,235,1329,524,47,1092,336,711,203,958,102,236,765,216;62;M
47312;47,336,201,203;47;F
47355;270,102,236,34,21,1329,47,1092,816,336,203,216;67;F
47395;239,101,1176,1170,1111,478,31,781,287,956,34,517,336,711,481;37;M
47423;959,525,47,216,237,481,336,1329,21,148,781,478,102,236,101;32;M
47435;239,1176,1170,236,1111,478,287,34,1303,47,819,517,336,481,216;36;F
47448;101,478,481,483;57;F
47464;1303,19,816,766,270,1176,1170,1111,478,31,148,287,34,535,336;29;F
47493;959,19,946,270,759,148;33;M
47500;220,101,1170,969,1111,31,816,237,239,235,524,819;27;M
47567;271,270,1092,336,220,287,34,21,19,524,47,517,711,958,269;41;F
47587;34,816,517,336,926,979,958,1176,1111,478,781,1170,47,819,481;40;F
47604;1170,102,1111,478,148,287,34,21,525,517,570,336,481,958,135;40;M
47637;239,101,478,781,148,287,765,216,135,31,34,1092,336,711,926;38;M
47639;34,287,1111,101,958,19,1176,478,759,926,711,203,1170,781,481;45;F
47655;287,816,481,237,819,524,235,1652,31,1111,239,220;41;F
47672;287,34,483,478,781,336;45;M
47673;34,1170,1176,1111,478,781,287,1329,524,525,336,926,711,481,958;16;M
47702;203,481,958,237,220,239,102,31,34,781,1652,21,19,235,524;42;F
47740;1111,102,1170,1176,239,101,236,31,287,34,21,524,570,481,237;32;F
47765;102,287,34,21,1329,524,47,1092,535,926,979,216,101;49;F
47771;1111;42;M
47789;19,336,148,781,979,958,34,926;27;M
47823;203,483,1170,1111,478,781,46,1652,287,34,21,19,926,481,958;10;F
47846;1176,1170,236,31,19,525,819,517,570,336,481,958,269,216,956;37;F
47852;101,239,766,270,946,201,1111,478,759,287,524,47,517,336,481;35;F
47957;1652,478,31,34,19,203,481,270,239,271,148,759,336,958,269;36;F
47969;101,948,287,34,524,47,336;43;F
47992;220,201,102,236,959,46,21,535,926;18;F
48019;819;30;F
48042;781,216,287,148,271,270,956,34,336,958,269;38;M
48071;46,148,287,525,517,570,270,1176,1170,1111,47,819,336,481;41;M
48086;270,271,269;38;F
48090;271;43;F
48093;270,271,148,956,34,481,269,216;8;F
48113;816,1092,525,1303,765,34,1170,201,270,766,1176,969,46,47,336;43;F
48116;220,1170,478,21,34,19,1329,525,219,47,819,816,926,203,481;23;F
48121;1176,1170,1111,478,31,34,21,1303,524,819,535,517,336,926,481;40;F
48126;481,979,203,816,219,525,235,1303,46,31,959,236,201,1176,220;48;F
48134;270,271,269;10;M
48148;271,31,1652,235,570,336,203,958,270,759,269;38;F
48215;270,271,269;34;F
48236;969,102,101,220,766,946,1176,239,959,781,148,287,34,47,336;32;F
48249;148,336;44;M
48260;1176,524,216,235,236,101,102,287,34,47,336;45;F
48285;979,201,478,524,525,203,481,483,135;70;F
48291;201,478,524,525,203,481,135,483;81;F
48295;271;36;F
48296;201,478,525,524,203,481,483,135;76;F
48307;201,478,524,525,203,481,483,135;77;F
48317;201,478,524,525,203,481,483,135;70;F
48320;819;38;F
48323;201,478,524,525,203,481,483,135;72;F
48324;481,1176,1111,478,287,765,517,926;36;M
48327;201,478,524,525,203,481,483,135;78;F
48329;1303,819;37;F
48335;148,31,1111,969,1170,1176,766,478,781,287,1329,524,1092,926,481;33;F
48340;148,765,1303,19,525,219,203,236,287,34,524,47,336,958,216;19;F
48360;270,271,148,269;8;F
48371;1111;42;F
48374;270,271,148,269;5;F
48426;101,102,781,34,21,19,1329,524,525,1092,570,336,711,958,135;64;M
48443;101,270,958,269,271;40;M
48459;336,711,219,781,102,759,287,34,524,203,1303,525,816,570,926;48;F
48484;819,203,979,958,216,135,239,236,287,34,19,524,47,816,336;29;M
48515;216,135,270,101,478,271,21,19,1176,1170,1111,287,524,517,481;29;F
48519;525,219,336,203,269,478,287,34,926,481,1111,959,19,47,958;43;M
48531;269,270,271;47;F
48542;216,781,287,1303,759,34,524,525,219,816,570,336,926,711,203;18;M
48556;271,239,219,819,816,336,203,237,946,767,948,765,481,483,135;54;F
48611;958,203,711,926,336,570,525,524,1329,1303,287,759,46,31,478;19;M
48633;926,1176,946,236,759,816,336,1329,524,525,570,979,203;25;M
48742;34,148,287,570,203,481,483,1176,1170,1111,236,219,517,336,958;42;M
48780;46;18;M
48841;816,570,979,958,483,239,271,31,287,34,819,926,135;39;M
48869;946,336,481,1170,958,1176,766,270,1111,959,478,271,781,19,269;41;M
48978;101,1176,781,287,34,235,524,47,336,216;43;F
49036;220,101,765,1329,524,535,336,979,135,816,481,102,759,21,956;37;F
49044;270,271,269;38;F
49069;287,781,969,1170,1176,239,766,270,478,46,1652,956,819,816,481;39;F
49154;19,34,287,478,1111,1176,270,239,1170,271,235,517,336,958,269;35;F
49300;1111,766,287,819,237,1170,236,759,148,525,219,47,336,203,481;37;F
49355;271;44;F
49374;102,1111,781,21,481,958,135,287;35;M
49432;216,946,236,287,34,765,47,135;48;F
49440;270,271,269;47;F
49477;781,270,946,101,948,767,271,765,1303,524,525,47,535,336,269;13;M
49483;948,765,525,47,524,1303,781,767,946,535,336,270,269,101,271;9;M
49491;1303,765,34,759,46,271,767,1111,969,1176,101,517,336,481,216;30;F
49507;767,135,46,766,236,478,781,287,34,765,525,219,336,203,216;45;F
49508;481,1170,1176,1111,287,34,517,336;47;M
49540;946,270,101,767,271,781,948,765,1303,524,525,47,535,336,269;45;F
49553;1170,759,287,481,102,236,478,781,148,19,524,47,819,926,135;65;F
49574;1111,478,271,765,926,135,102,148,287,34,21,19,336,481,958;36;F
49614;270,271,525,219,766,1176,1170,236,1111,478,148,287,47,336,481;47;M
49623;481,483,269,570,517,148,478,1111,1176,766,270,287,21,524,336;35;F
49637;19,819,711,216,958,481,336,1092,524,765,781,478,236,102,101;47;M
49677;765,19,1329,483,766,1176,1170,1111,478,287,525,517,270,271,269;11;M
49678;481,483;54;M
49685;525,1176,101,946,1170,1111,19,524,219,517,203;48;F
49690;711,926,336,1329,765,34,287,759,148,781,478,1111,236,102,101;41;F
49691;216,524,19,102,239,101,1111,148,34,336,958,270,271,269;10;F
49696;946,287,203,481;36;F
49711;270,946,101,767,271,781,948,765,1303,524,525,47,535,336,269;44;M
49727;524,517,481,483,135,19,34,287,478,1111,1170,1176,101,766,979;32;F
49732;270,1176,271,958,269;37;M
49769;525,819,570,203,269,216,135,270,946,1111,767,271,148,948,34;49;F
49891;481,236,781,287,926,336,711,216,1176,1170,1111,959,478,46,47;45;F
49911;517,203,766,216,483,102,478,287,21,765,235,1329,524,336;29;F
49943;483,481,336,525,31,236,1176,101,766,1111,287,1092;47;F
49968;34,287,148,31,478,236,270,271,269;34;F
49998;270,946,1176,1170,969,1111,478,287,203,1092,47,524,201,101,236;16;F
50036;1176,1170,1111,287,19,336;44;M
50046;481,203,1092,219,1176,34,31,101,969,483,517,287,1111,236,1170;47;M
50051;21,34,135,287,336,270,271,148,269;37;F
50064;270,271,19,269;39;F
50076;236,478,287,235,1329,524,219,47,1092,570,926,483,239,781,34;50;F
50107;34,765,1303,19,819,336;77;M
50145;47,979,483,766,220,101,1176,1170,1111,236,478,287,34,19,216;24;F
50150;135,19,34,148,31,270,271,269;8;F
50152;946,478,46,287,525,926,336,203,1303,819;23;F
50186;1329,525,570,711,203;29;F
50190;1303,1176,287,19,819;74;F
50212;1329,1092,816,336,203,979,481,570,239,216,220,236,235,219,237;39;M
50219;270,148,220,271,269;6;F
50228;1329,525,570,711,203;91;F
50230;19,765,34,948,148,781,271,767,236,239,946,1652,1092,926,135;43;F
50252;270,781,47,481,1176,1170,1111,478,287,34,336;36;F
50290;269,237,524,271,759;41;M
50293;148,270,271,269,135;4;F
50341;969,236,759,948,765,711,270,767,271,148,269;39;F
50358;31,236,767,269,946,948;38;M
50377;201,270,220,101,1111,478,46,287,47,535,517,336,203,979,216;29;F
50414;216,148,1111,236,239,287,34,765,336,481,926;40;M
50435;1176,239,270,236,478,271,781,759,287,956,235,524,47,535,269;9;F
50436;46,1652,1303,236,759,524,216,819,481;46;F
50459;781,478,236,1170,270,271,759,34,19,235,336,481,958,269,216;5;F
50467;31,287,270,271,148,759,948,34,524,47,819,570,336,481,269;7;F
50531;239;37;M
50552;1111,101,1176,1170,969,478,956,235,524,47,535,336,979,481,483;66;F
50560;766,270,1176,1170,478,31,148,34,517,236,1111,287;32;F
50563;570,336,767,781,948,21,19,135,481,819,148,958,270,269,271;32;M
50602;135,203,270,946,236,767,271,148,948,34,1303,525,819,269,216;48;M
50671;524,47,1092,535,336,481,287,759,31,478,1111,236,969,1176,101;20;F
50681;216,483,766,270,101,1176,1170,236,1111,478,287,34,19,524,570;30;M
50684;236,517,958,483,766,1170,1111,478,287,336,926,481;29;F
50700;135,781,31,478,236,102,239,216,765,47,336,979,948,946,767;47;F
50705;239;63;M
50724;1176,1170,1111;33;F
50752;1652,1303,525,979,481,1329,765,759,478,236,946,287,524,336,926;32;F
50816;270,271,148,269;36;M
50831;483,958,148,781,34,765,926,766,478,287,481,336;31;M
50846;969,101,1111,236,478,31,759,287,524,47,1092,819,816,535,481;50;F
50866;819,1303,759,781,1176,816,1092,524,287,478,1111,236,969,1170,101;51;M
50867;481,766,270,1176,1170,102,236,1111,478,759,287,21,19,926,203;17;F
50873;271,19,958,269;9;F
50883;270,766,287,765,219,819,1176,946,948,478,148,19,336,926,481;34;M
50884;525,819,481,135,46,781,959,1176,270,1111,271,34,19,336,269;42;F
50885;269,270,271;8;F
50910;271,19,958,269;6;M
50936;34,19,525,47,819,535,517,570,336,481,135,483,270,271,269;40;M
50941;1111,766,34,336,481,101;33;M
51041;270,1111,959,271,781,287,34,19,235,525,819,336,481,269,135;11;M
51084;235,135,270,1176,1111,959,271,781,34,19,525,819,336,481,269;6;F
51090;478,781,1329,481,216,287,34,926,135;49;M
51112;570,483,219,525,1329,19,959,766,287,765,336,926,711,203,135;25;F
51181;19,517,481,766,1170,478,287,34,525,47,1092,570,926,711,483;47;F
51186;1170,1176,946,270,220,766,236,478,287,34,47,535,269,216,483;48;F
51206;216,979,926,19,781,959,236,1170,1111,287,956,34,819,336,481;36;F
51243;767,46,148,1652,287,34,765,19,524,219,816,517,336,483,135;64;M
51321;201,946,767,948,47,816,135;37;F
51327;1329,765,766,946,819,1652,478,1170,239,1176,1111,781,948,287,1303;32;F
51338;271;38;F
51362;1303,336,483,969,766,270,478,781,46,34,819,517,1170,1111,287;35;M
51464;781,46,34,1303,819,336,926;43;F
51477;239,102,535,237;42;F
51563;47,1092,535,926,216,101,478,781,287,34,524,1329;51;F
51595;235,219,535,336,101,1176,236,31,759,287,524,47,1092,237;48;F
51633;271,819,481,19,1176,287,946,767,948,958,148,34,336;43;M
51669;1111,270,271,34,336,958,269;40;M
51686;271;7;M
51707;271;1;M
51749;946,19,819,1176,1111,767,271,148,948,336,481,958,135;48;F
51767;1170,1176,1111,271,31,287,34,524,816,517,336,481,958,269,135;41;F
51802;236,478,287,21,336,481,239,34,524,47,926;36;F
51815;478,148,287,34,336;48;M
51937;969,481,216,524,1092,535,336,979,102,236,31,759,47,926,101;40;F
52029;1170,478,781,765,1329,517,958,1176,1111,287,34,819,336,926,481;14;M
52043;203,766,270,101,1170,271,34,19,525,819,570,336,958,269,135;9;F
52099;711,203,236,31,46,956,1303,47;43;F
52106;781,948,34;65;M
52136;269;38;F
52143;535,483,216,1652,46,1329,478,271,31,287,524,517,269,926,237;35;M
52145;1111,287,34,819;36;M
52147;203,237,220,535,47,524,287,1111,46,148,34,19,270,271,269;44;F
52195;766,235,946,1176,236,31,148,34,19,1111,781,21,819,336,481;46;M
52201;102,236,287,34,47,336,478,21;48;M
52267;270,271,269;8;F
52272;270,271,269;6;M
52294;19,270,236,271,336,269;42;F
52303;236,271,34,336,269;40;M
52312;979,711,336,47,524,1652,478,239,1329,926;45;F
52354;481,483;67;F
52365;958,819,517,926,481,269,483,766,270,946,1176,1170,1111,478,287;31;M
52394;1111,1303,819;38;F
52401;1176,1170,34,19,47,336,517;35;F
52481;766,270,101,1176,1170,1111,478,271,21,524,525,517,203,481,135;69;F
52488;19,781,969;26;M
52559;958,819,19,959,1111,969,766,478,1170,1176,235,1329,47,517,336;42;F
52560;481,483;33;F
52588;1176,478,31,34,524,1111,287;40;F
52589;926,483,287;44;M
52598;1111,148,34,19,819,926,203,216,135,271,287,336,481,958,269;43;M
52645;481,483;74;M
52646;1176,483,766,946,1111,767,148,948,34,1303,19,287,570,336,926;35;M
52723;979,481,269,287,148,271,767,478,236,1170,766,102,34,765,1303;44;F
52726;926,34,781,478,1111,1170,1176;35;F
52741;781,1303,819,926;31;F
52772;969,34,958,101,1111,759,524,1092,979;67;M
52844;101,102,969,759,956,21,1329,524,1092,570,979;67;F
52913;535,481,1176,236,1111,959,759,21,47,1092,816,926,958,237,269;53;F
52922;478,781,287,34,336,926,483;48;F
52946;1111,1176,101,766,236,478,287,34,524,47,336;30;F
52958;1176,1170,102,236,1111,959,478,287,517,336,958,216;22;F
52991;34,1329,203,524,525,570;23;F
53112;524,101;25;F
53118;31,1652,203,570,819,525,219,19,34,271,1176,270,517,336,269;46;M
53259;220,1303,525,219,47,203,102,236,46,336,926,958;43;F
53316;271,236,1111,478,31,287,34,525,819,517,336,958,237,269,135;30;F
53317;271,1111,946,766,270,1176,236,478,765,819,711,958,483,34,287;31;M
53329;148,216,336;39;F
53340;46,946,239,956,34,765,19,235,525,219,570,336,31,287,203;38;F
53400;287,34,765,19,525,336,481,135,946,236,271,148,948,819,46;49;M
53432;1111,101,766,767,148,287,956,765,19,517,570,203,135,34,336;43;M
53495;148,220,203,517,525,19,765,34,948,1176,336,1111,946,287;22;F
53529;1176,1111,478,287,34,336,926,481;37;M
53555;1176,236,235,819,570,1111,781,759,1652,287,34,816,517,336,481;38;F
53578;34,19,524,1092,570,203,148,46,201,1303,336;57;F
53589;101,1176,1111,478,759,287,524,47,535,517,336,203;27;F
53599;969,201,239,956,34,21,19,235,47,819,816,336,979,958,216;21;M
53681;1176,766,1329,524,525,481,926,235,287,781,31,236,969,102,239;41;M
53749;946,1176,478,767,948,287,235,517,926,958;41;F
53752;781,946,1176,959,287,1329,819,816,517,336,926,711,203,958,481;37;M
53776;946,767,948;20;F
53779;767,946,948;52;M
53823;1652,21,958,239,102,478,31,46,759,287,1329,1092,336,711,481;55;M
53873;1176,287,34,517,481,1170,236,478,1111,46,47;49;M
53880;148,19,517,766,946,1176,236,287,765,336,926,711,481,216,483;29;F
53890;1092,203,979,219,235,19,201,46,781,766,765,336,767,946,948;47;F
53917;271,478,1111,1170,1176,101,946,781,287,34,765,524,336,269,135;31;M
53941;766,236,478,767,31,781,948,287,956,34,517,336,926,216,483;61;F
53950;148,135;79;F
54020;946,767,948;23;M
54032;47;45;M
54035;946,1329,525,517,766,1176,1170,1111,478,767,287,765,926,481;27;F
54100;31,46,1652,287,765,19,1329,524,525,219,47,570,336,203,481;44;F
54133;287,524,1092,216,101,1176,201,1170,236,478,21,1329,517,926,481;38;F
54138;269,216,483,135,235,1652,270,102,236,271,287,34,765,336;73;F
54151;979,237,816,236,1111,46,19,47;47;F
54169;979,481,958,237,269,216,483,135,766,270,1176,1170,1111,478,287;27;M
54221;481,269,135,958,148,767,766,946,1176,1111,287,34,765,19,336;26;M
54255;19;75;F
54257;19,47;77;M
54281;781,34,21,1111;37;F
54351;47,236,287,203,926,481,101,31,781,34,1303,524,1092,336,237;35;F
54377;1111,236,819,336,481;17;M
54400;203,220,31,34,525,711;52;F
54402;1170,46,759,34,19,336,926,216,1111,478,287,819,481,958,483;10;M
54444;239,781,235,525,47,535,570,979,481,135,31,34,287,336,926;29;F
54446;1170,1303,1111,34,819,481;48;F
54485;135,236,767,271,948,765,481,766,1111,781,148,287,34,19,336;24;M
54496;239;16;F
54497;483,1176,1170,236,1111,478,781,148,287,34,47,336,926,481,216;43;M
54509;969,101,239,102,236,1111,478,1652,34,1329,517,1176,1170,287,336;38;F
54544;1176,1170,236,47,517,336,481,287,946,767,948;20;F
54568;759,1303,524,816,483,216,135,478,34,765,1092,336,926,203,979;51;F
54623;101,478,31,759,34,1303,524,219,236,287,525,816,926,481,203;33;F
54641;524,525,483,46,766,270,236,478,287,34,517,481,1176,1170,1111;44;F
54643;216,483,269,958,766,926,1176,1170,236,1111,478,781,287,336,481;48;M
54659;239,287,21,235,1329,219,336,711,203,237,47,220;38;F
54685;570,948,781,31,1111,766,101,102,478,926,34,19,336,148,287;32;F
54739;1170,1111,47,535,979,483,524,287,478,926;47;F
54757;946,766,270,1176,1170,1111,478,287,1303,1329,47,517,926,711,483;44;F
54759;481,203,219,525,31,1176,236,287,34,336,269,1092,1111,271;44;F
54766;481,946,270,220,766,239,101,102,959,148,1652,47,1092,336,926;43;F
54815;239,959,478,47,287,956,34,336;31;F
54830;34,524,816,336,926,979,481,958;32;M
54892;236,979,1303,819;57;M
54996;239,1170,759,21,1329,979,481,483,102,517,1176,478,1111,287,135;31;F
55007;959,31,46,34,219,766,1176,1111,287,19,525,517,336,203,481;40;M
55013;270,239,102,236,1111,959,271,781,759,926,336,711,979,481,269;31;F
55060;239,969,34,570,979,336,535,1092,47,524,956,101,270,271,269;35;F
55081;19,203,958,101,478,31,287,34,524,336,481;35;F
55118;948,959,478,101,220,767,271,31,287,34,524,525,816,926,203;28;F
55141;236,956,1329,525,47,1092,819,816,535,570,481,958,135,201,239;32;F
55278;959,31,1652,287,34,1303,235,816,926,979,958,216,759,524,336;34;M
55293;102,271,21,958,269;36;M
55323;270,1176,1170,1111,478,765,19,525,203,483,946,781,287,34,336;30;F
55324;101,287,525,926,483,1176,1111,34,524,47,517,481;38;F
55326;956,819,1176,1111,478,767,781,1303,926,481,958;34;M
55364;819,525,781,271,969,236,148,34,235,47,336,203,481,958,216;43;F
55401;336,1092,524,1329,235,19,34,287,781,767,1111,102,1176,101,148;47;F
55402;1329,524,47,535,570,336,237,216,946,101,236,1111,478,759,287;38;F
55430;926,203,979,135,336,816,1329,34,948,766,781,765,525,47,711;54;F
55440;483,926,570,1303,287,236,781,34,958;41;F
55441;239,287,235,237,956,1652,969,1170,1176,236,1111,478,759,819,481;39;M
55450;287,524,1092,336;39;F
55451;101,102,34,21,524,525;35;F
55453;236,759,524,1303;40;M
55454;34,21,235,524,47,535,517,336,926,203,979,481,958,269,216;40;F
55478;34,271,269;29;F
55480;336,946,767,948;20;M
55482;1176,1170,1111,148,287,34,524,1092,819,517,336,481;23;M
55535;926,481,958,946,336;31;M
55542;956,1652,239,478,781,34,235,47,816,336,926,711,269,959,271;36;F
55544;239,201,102,781,34,19,101,969,524,219,47,816,336,203,958;47;F
55560;287,517,483,101,969,148,34,524,47,1092,535,336,979,958,216;30;F
55606;478,1111,946,766,101,1176,1170,34,19,47,819,517,336,481,958;44;M
55643;336,926,478,781,287,34;50;M
55666;767,236,239,102,959,781,948,287,34,1303,19,524,47,336,958;35;M
55683;216,269,926,570,816,819,1092,47,1329,235,31,959,102,239,958;45;M
55716;1111,287,34,819;41;M
55721;781,148,19,336,926,270,959,478,271,287,1652,34,1303,958,269;40;F
55725;781,287,956,1329,481,216,483,102,34,21,765,525,926,711,203;50;F
55765;483,766,1176,1170,1111,478,148,287,19,524,517,336,926,481,958;31;F
55769;1329,1652,46,31,271,1111,1170,766,946,478,287,34,235,336,926;38;M
55772;102,101,1176,478,287,21,765,481;30;M
55794;1176,1111,336,926,481,958;41;F
55823;235,524,525,535,481,958,135,220,781,287,765,47,1092,336,926;40;F
55861;1111,524,47,101;33;F
55956;766,946,1176,1111,478,148,287,34,765,525,336,135,767;55;F
55998;270,1111,478,271,287,19,524,816,336,269;37;M
56013;535,203,979,269,216,766,946,236,478,767,781,948,287,34,765;24;F
56039;148,481,959,34,336,926,979;22;F
56067;969,959,46,1652,517,336,926,481,239,201,34,765,235,47,135;38;F
56135;1170,1111,34,525,336,19,926,481,1176,517,765,766,570,483,287;27;M
56139;148,759,287,34,765,19,47,1092,535,336,979,216,101,781,524;36;F
56150;148,766,946,1176,1170,1111,478,759,287,34,819,517,336,926,481;22;F
56180;102,969,236,959,478,31,1652,956,524,47,1092,979,958,237,216;33;F
56194;478,336,926,203;51;M
56217;1329,524,525,570,203;56;M
56232;946,1176,765,47,517,203,481,1170,236,1111,478,287,34,19,336;43;M
56235;1303,235,570,216,979,481,203,711,1329,287,956,781,1092,926,135;27;M
56238;766,483,481,336,517,287,1111,1170,1176;38;F
56250;34,148,1176,1170,287,481,1111,1092,517,336,926;46;M
56257;711,1329,524,525,570,203;73;F
56260;269,781,969,102,1176,101,946,959,271,1329,524,525,570,203,958;44;M
56262;1176,239,220,946,1111,781,1329,525,219,336,926,203,979,958,483;47;M
56273;816,711,766,946,34,525,517,483,481,979,926,336,524,765,478;21;F
56274;481,969,235,759,1170,517,1176,102,1111,570,781,478,287,34,483;38;F
56294;1176,946,1170,1111,478,46,948,287,765,525,336,926,711,481,135;23;F
56315;102,236,781,19,1176,1111,148,287,34,21,765,570,336,711,481;46;M
56317;239,819,1652,46,781,946,767,271,948,34,765;45;F
56337;271,135;38;M
56343;767,336,926,1329;58;M
56381;19,525,956,759,1111,481,819,1329,524,570,203;33;F
56396;148,979,216,46,34,926,781,478,1176,1170,1111,287,517,336,481;44;F
56403;287,31,767,478,959,1111,102,1170,239,236,34,336,958,216,135;39;F
56417;19,819,979,535,46,1329,524,525,570,203;34;M
56421;969,1111,781,1329,524,1092,517,570,926,979,481,483,478,287,34;32;F
56434;781,271,767,1111,101,766,220,524,525,203,481,483,135,201,478;28;M
56435;1170,1111,781,819,517,336,926,201,478,524,525,203,481,483,135;27;F
56449;1111,478,287,1329,524,525,570,926,711,203;78;F
56458;1170,1111,959,271,148,956,287,34,19,47,819,336,481,269,958;43;M
56465;216,781,271,767,1111,946,220,201,478,524,525,203,481,483,135;73;F
56473;766,478,287,1329,525,570,926,711,203;69;M
56477;1176,148,34,287,765,47,216,135;32;F
56478;201,1652,1329,819;47;F
56482;220,236,759,47,958,269,216;40;F
56497;781,765,336,1111,766,220,946,201,478,524,525,203,481,483,135;83;F
56508;271;44;F
56517;102,759,101,483,287,711,767,946,1652,781,235,34,926,765,478;19;M
56548;220,270,102,236,759,525,47,336,203,216,219;34;F
56558;46,1652,956,1329,816,1176,271,47,819,336,958,34,287,478,1111;36;F
56581;148,926,236,102,34,47,958,216,270,959,271,19,819,336,269;63;F
56586;766,220,481,1111,287,34,765,1329,525,926,711;36;M
56599;203,979,219,525,21,34,287,759,31,478,236,220,481,237,216;44;F
56601;926,478,287,34,570,336,481;29;M
56641;148,19,765,525,269,270,478,481,1170,1176,517,483,766,1111,287;31;F
56646;946,1303,819,816,570,101,336;38;F
56647;270,1176,1170,478,759,287,816,517,336;40;F
56658;216,946,781,287,336,481;25;F
56685;270,239,102,959,271,46,148,1652,34,19,47,819,958,269,216;68;M
56690;236,1176,101,946,102,478,34,287,765,524,47,816,336,926,483;45;F
56709;766,287,34,1329,524,1092,819,816,336,926,711,979,481,958,483;21;F
56742;525,47,816,517,926,216,483,1176,1170,478,781,287,34,570,336;41;F
56756;101,524,203,711,517,287,1111,766,478,759,19,235,47,926,336;27;F
56780;946,767,287,765,525,135,203;68;F
56799;766,270,271,269;11;M
56820;483,216,481,203,47,148,271,1111,270,766,478,287,34,524,336;30;F
56822;47,102,46,926;39;M
56827;287,946,767,948,765,525,926,203,135;34;M
56846;766,270,271,269;9;M
56855;1176,1170,1111,336,517,481;14;F
56884;759,767,101,270,269,271;37;M
56986;236,31,1652,21,1329,524,525,570,203;39;M
57035;517,1092,1303,948,102,101,1170,47,525,1329,34,1111,478,287,135;44;F
57074;271,269;62;F
57088;271,269;63;M
57113;956,926,203,34,483,946,478,287,517,816,336,481,216;28;M
57128;148,781,946,220,270,766,1176,1170,1111,478,287,34,765,483,336;34;M
57134;336,216,236,1176,239,220,781,1303,235,525,219,816,926,203,481;40;F
57154;1176,1111,287,34,1303,517,336,481;34;F
57177;765,1303,524,47,203,478,31,287,34,525,570,336,926,711,481;33;F
57208;101,270,816,926,979,481,102,781,287,524,47,535,336,958,216;44;F
57212;102,1111,478,759,765,524,570,969,236,1652,287,34,336,926,481;45;F
57215;270,1111,271,31,287,524,47,819,535,336,481,958,237,269,216;10;M
57221;956,1303,524,1092,203,766,478,1652,34,235,525,47,517,336,711;31;F
57231;1176,1170,1111,478,287,34,47,819,816,517,336,926,979,481,958;33;F
57293;535,47,524,19,765,21,34,287,31,271,478,1111,236,101,270;7;F
57317;766,1176,1170,478,31,287,765,517,926,135;48;F
57341;1111,271,31,287,21,19,524,816,535,336,481,958,237,269,216;40;M
57345;926,287,220,239,236,781,34,1303,235,525,219,336,203,481,216;44;M
57436;34,135,819,336;38;F
57504;570,203,19,34,781,478,101,956,1329,926,711,287,524,135,336;42;M
57517;135,946,767,948;39;F
57534;1092,525,19,148,336,535,524,1329,287,478,959,969,102,101,979;22;F
57540;135;58;F
57550;101,236,524,525,219,1092,517,926,203,135;37;F
57568;524,1170,1176,1111,478,781,34,1092,517,336,926,979,481,958,216;55;M
57582;948,47,766,1170,236,478,287,524,525,517,926,711,481,216,483;39;M
57604;46,767,1111,236,1170,946,1176,478,781,287,34,765,570,481,269;15;F
57637;958,19,959,767,34,765,336;18;M
57651;1176,781,336;48;M
57681;270,102,31,46,235,525,219,203,781,34,47,336,135;49;F
57694;216,271,478,1111,220,236,781,46,34,524,525,219,926,203,481;32;F
57724;948,524,483,969,31,759,34,21,525,47,570,336,711,287,481;35;M
57747;711,958,481,102,1111,781,287,34,765,524,570,336,926,979,483;39;F
57753;517,47,525,34,287,781,478,1111,102,1170,239,946,336;48;F
57791;1176,1111,271,287,336,958;45;M
57891;517,816,525,270,220,239,1176,959,271,219,203,135,1111,765,336;38;M
57894;31,46,287,956,19,47,926,203,1303,765,948,946,767,34,135;41;F
57906;478,767,287,19,525,483,101,969,34,1303,47,816,535,336,958;48;F
57935;19,235,524,219,570,481,958,216,1176,271,47,819,517,336,269;38;F
57942;216,979,926,47,219,525,1329,287,148,236,102,101,535,336,203;25;F
57974;478,287,956,34,1329,1092,816,535,926,979,781,759,524,570,336;29;F
57983;235,287,767,948,946;42;M
58004;1652,46,101,31,287,21,235,524,219,819,535,570,336,481,237;30;F
58007;948,46,271,767,1111,239,102,1176,946,766,236,481,237,21,287;31;F
58012;34,759,270,239,102,959,271,1652,19,47,819,336,926,958,269;8;M
58017;1329,525,958,287,759,478,1111,969,236,46,235,819,336,926,481;45;F
58024;524,287,759,959,102,1170,1176,101,1111,216,517,336,979,481,958;48;F
58034;101,1176,102,1111,478,31,781,287,34,21,1303,47,517,336,203;35;F
58100;481,958,102,34,287,1652,781,1176,1170,1111,478,47,819,517,237;45;F
58117;969,216,958,711,535,1092,524,759,1170,101,781,1329,47,926,481;29;F
58148;1170,1176,517;39;M
58177;1329,711,481,483,1092,47,34,287,948,1111,102,1176,946,816,336;31;M
58186;767,819,517,269,135,1176,236,287,765,525,336,34,1303,219,203;42;F
58191;271,969,959,767,819,958,946,517,481,239,948,235,1092,135,956;35;F
58202;201,1111,34,336,481,958,1176,1170,959,781,1652,1303,19,816,517;40;F
58208;270,478,34,524,535,483,269;24;F
58220;101,1111,46,570,336,711,216,236,287,19,1329,525,816,926,203;31;F
58233;270,102,959,1111,271,478,781,287,34,19,336,926,958,269,216;11;M
58243;239,101,236,478,148,287,34,19,219,47,535,926,203,979,216;33;F
58247;766,1176,1170,1111,959,148,19,524,517,336,926,481,958;21;M
58251;216,101,102,969,31,287,956,34,21,1303,524,47,1092,336,926;32;F
58285;47,525,1329,235,1303,956,478,236,239,1170,1111,31,759,1652,287;41;F
58356;1111,478,759,287,34,1303,524,525,219,1092,570,336,203,483,135;10;F
58381;21,1329,336,481,958;25;M
58399;524,969,1111,478,759,1652,287,34,1303,570,336,203,269,216,135;3;F
58402;958,926,1092,1329,765,34,767,959,969,946,1176,1170,1111,336,481;21;M
58546;1652,948,759,31,767,101,946,201,34,765,47,336,926,203,237;29;F
58551;34,287;46;M
58556;524,47,570;39;M
58581;237,926,946,236,767,948,1652,269;42;F
58602;781,46,524,958,216,270,1176,1111,478,287,220,34,1092,336,926;47;M
58604;969,220,101,1111,781,287,34,524,216,47,336,926;45;F
58620;236,478,1176,1170,1111,287,34,336,203,481,101,524;46;F
58635;287,1303,979,481,216,203,926,525,524,220,34,765,19,1329,1092;23;F
58641;21,34,19,1329,219,47,819,517,269,336,958,926,287,781,481;46;F
58645;481,926,1092,235,34,287,101,946,1176,1111,959,478,767,31,948;39;F
58683;478,781,948,287,34,19,47,819,517,336,926,203,481,958,269;46;M
58689;270,271,269;38;F
58711;220,946,31,46,219,570,203,481,819,525,959,236,969,34,926;40;F
58717;101,478,759,287,34,524,1092,336;39;M
58725;478,781,287,34,19,148,336,766;25;M
58741;236,287,1303,816,711,979,969,535,220,478,781,1329,525,203,216;33;F
58760;102,21,1303,336;49;F
58761;1176,1170,1111,478,781,287,34,524,517,336;29;F
58781;483,1170,959,101,946,270,766,1176,1111,478,287,47,517,336,481;30;F
58786;1329,235,969,201,239,220,946,236,767,31,948,1652,956,47,336;34;F
58853;1176,148,765,1329,570,926,711,481,216;26;M
58864;19,219,570,926,766,946,1111,781,525,203,481,1176,34,517,336;28;F
58866;766,1176,478,287,19,1170,1111,148,34,517;32;F
58867;19,34,287,759,781,767,478,102,101,946,766,481,271,148;38;M
58922;148,287,34,19,524,525,336,711,203,958,216,765,1329,47,926;32;F
58925;1176,1170,1111,478,287,926,481;44;M
58963;979,216,236,956,47,816,478,525,101,34,336,759,524,570,287;39;M
58971;239,31,1176,236,759,287,34,21,235,517,336,979,481,237,216;35;M
58989;203;77;F
59008;483,19,765,148,781,101,766,1111,34,336;27;F
59011;31,34,19,235,525,219,47,926,336,237,767,287,958,481,203;36;F
59054;525,956,31,102,239,236,46,1652,34,235,219,47,570,336;63;F
59062;271,269;8;M
59071;271,269;5;M
59091;956,34,765,19,235,1329,219,237,239,478,31,524,525,47,570;36;F
59111;517,235,959,1170,102,478,781,287,34,21,19,819,570,336,481;33;M
59156;34,336,926;29;M
59157;1303,1652,219,570,203,237,781,34,524,525,1092,481,1176,1111,287;45;F
59186;767,517,926,483,946,948,819,481,1176,1170,478,959;41;M
59191;765,1303,1092,711,979,483,766,1176,1170,1111,1329,819,816,517,481;32;M
59220;270,1176,1170,1111,34,525,481,483,959,478,46,287,524,336,926;42;F
59223;271,102,969,1176,270,766,1170,1111,478,34,21,819,517,336,481;42;M
59245;219,102,781,148,287,34,21,524,47,336;42;F
59249;958,216,19,759,1111,236,1170,1176,101,220,102,478,287,34,336;36;F
59250;926,239,946,236,767,948,336;43;M
59251;220,101,969,524,525,1092,570,926,979;52;F
59253;336,481,946,959,148,287,19,47,816,483,1176,1170,1111,478,34;42;F
59257;766,1111,759,287;25;M
59274;766,1170,959,1111,948,819,135,979,1092,1303,1176,946,767,765,926;62;F
59290;287,948,271,767,1176,1170,1111,47,517,336,926,203,216,958,481;45;F
59330;203,237,220,239,101,236,31,19,219,535,570,336,216,47,481;58;F
59369;34,47,535,336,926,203,1176,1170,1111,478,287,21,517,481,216;30;F
59387;19,270,102,478,271,31,148,1652,287,21,47,336,926,269,135;34;M
59404;216,203,766,946,1176,236,478,271,46,287,524,47,336,481,483;65;F
59406;19,819,271,946,767,948;44;F
59421;46,759,287,1329,926,711,524,1092,535,979,101,969,21,525,47;48;F
59425;959,1111,781,1652,287;47;F
59430;1170,1092,524,236,478,287,19,1176,1111,34,336,926,216;59;F
59481;759,525,203,270,766,1176,1170,1111,478,148,287,517,336,481,483;32;F
59489;102,956,524,926,711;34;M
59507;1176,781,101,1170,478,287,34,21,1329,524,517,203,336,481,958;43;F
59532;946,1092,47,336,34,765;46;F
59577;524,816,570,481,287,34,926,711,478,19,525,336,216;61;M
59641;1176,236,148,287,34,765,525,47,819,816,570,336,481,216,135;37;M
59659;926,336,570,759,781,478,1176,101,969,287,956,21,1092,711,481;34;M
59814;979,819,219,524,765,948,148,766,946,478,287,34,19,47,336;31;F
59855;816,481,483;34;M
59914;236,46,148,1652,287,34,47,816,535,570,979,481,958,237,216;39;F
59916;236,781,148,287,1329,517,336,481,269,216,1111,34,19,525,816;43;M
59918;336,711,1170,1176,236,287,34,517,926,481,958,216,1303,19,819;45;M
59942;969,101,946,270,287,1092,336;31;M
60092;148,481,958,483,270,946,1176,1170,1111,478,287,21,765,19,336;27;M
60167;31,969,102,239,1176,781,287,34,235,1092,517,203,481,336;28;F
60214;525,203,287,34,336,946,239,948,767;16;M
60235;201,220,766,236,271,524,525,819,535,336,135,765,767,946,948;38;F
60262;101,478,946,287;35;F
60356;956,270,271,269,959,34,19,336,958;43;M
60385;21,239,220,336,481,535,216,236,270,781,946,1176,1170,1111,517;43;M
60394;239,1176,1170,236,1111,959,478,781,46,287,34,19,336,481,958;46;F
60423;219,47,525,478,220,766,148,287,19,336,926,203;35;F
60435;31,46,287,19,235,525,1092,336,711,481,237,102,236,1652,47;49;F
60442;766,517,270,1176,1170,1111,478,287,34,47,481,216;49;F
60448;19,819,535,47,524,21,148,270,271,269;37;F
60466;101,1176,1170,102,1111,781,287,34,525,219,517,336,203,979,481;49;M
60518;287,1176,239,270,766,1111,478,34,765,525,47,517,570,336,979;35;F
60538;766,220,270,946,239,969,236,767,948,524,525,336,135;9;M
60573;34,19,235,525,570,926,958,483,135,236,478,765,524,336,481;32;F
60589;201,203;41;M
60615;711,816;39;M
60643;239;49;F
60662;478,287,47;30;F
60671;483,958,481,203,336,517,1092,47,524,287,148,31,478,1111,101;29;F
60749;1111,148,287,926;35;M
60759;101,102,1111,1652,535,336,958,135;61;F
60816;478,271,287,34,19,1329,819,481,781;35;M
60855;1176,1170,236,1111,959,478,271,287,235,19,819,517,481,958,269;43;F
60863;216,958,336,570,1092,525,19,1303,34,148,781,271,767,236,969;31;F
60880;819,816,570,336,926,711,767,148,287,34,765,19;20;M
60881;19,34,948,271,478,969,1170,946,270,1176,31,781,287,336,926;41;M
60894;101,1329,524,47,816,336,926,979,958,269;27;F
60942;287,926,711,481;33;F
60981;517;43;M
61003;956,478,239,101,31,1111,34,1303,19,524,47,1092,535,481,216;44;F
61078;237,979,219,47,46,959,201,236,31,759,956,34,1303,235,819;36;F
61111;969,220,34,524,525,1092,816,336,203,979,216,767,948,781,946;49;F
61297;759,34,135,767,946,948;42;F
61363;969,235,819,31,236,767,781,759,287,34,524,47,1092,336,926;37;M
61387;270,766,1170,1111,148,287,34,765,525,819,517,336,481,946,1176;25;F
61410;46,47;61;F
61490;946,767,948;20;M
61544;21,287,948,148,271,1111,102,1176,236,765,926;22;F
61553;1111,524,1092,926,216,946,1176,102,478,759,287,34,21,336,481;29;M
61568;1111,287,34,235,524,517;32;F
61582;926;57;M
61599;287,21,524,47,481;39;F
61619;1176,1170,1111,148,21,765,524,336,481;19;M
61641;237,483,101,478,781,287,34,1329,524,47,1092,535,336,711,926;39;F
61647;483,481,926,517,148,781,1111,201,1176,270,478,287,34,765,336;24;M
61722;270,1111,478,287,34,19,525,219,336,203;31;F
61733;34,21;29;M
61798;203,517,816,271,478,1170,766,1176,287,525;26;M
61824;269,816,524,34,525,1092,959,1111,969,1170,1176,101,946,767,948;21;M
61831;570,19,765,21,766,270,1176,1170,478,148,287,34,816,517,336;34;M
61956;946,1176,1170,767,781,481,765,148,1111,478,287,34,336,1092,759;30;M
61963;216,816,1170,1176,1652,239,1111,781,287,34,1303,235,47,517,336;43;F
61964;766,1176,1170,236,1111,478,781,148,287,34,517,336,926,481,483;30;F
61980;979,483,766,270,1176,1170,767,271,524,47,34,336,101,478,287;27;F
61986;239,236,956,1303,47,336,711,481,237,148;33;F
61995;765,759,46,148,517,483,21,47,816,478,711,34,1329,524,926;38;F
62000;271,201,524,969,287,1303,819,1092,926,979,1111,239,478,759,34;31;F
62015;948,271,1170,766,946,1176,1111,478,148,765,525,517,287,34,336;30;M
62070;270,766,1176,1170,1111,478,148,287,34,765,21,19,570,336,481;3;M
62088;766,1111,781,759,47,570,481,483,478,287,34,524,336;31;F
62092;819,47,525,765,34,287,948,46,781,271,767,236,946,203,216;34;F
62099;270,481,979,203,1092,47,525,34,287,236,220,216;45;F
62103;1170,1111,478,287,34,19,481,483,1176,969,148,1303,517,336,958;28;F
62113;287,525,219,517,926,203,201,102,1111,21,524,47,1092,535,216;25;F
62125;483,220,270,1176,102,201,1111,478,759,287,21,524,816,481;32;M
62165;216,481,517,1329,781,1111,478,926;24;M
62176;481,766,220,1176,478,46,148,287,34,19,525,47,570,926,203;55;F
62209;1111,959,148,711,481,958,269,483,135,767,271,287,34,819,336;27;F
62218;148,948,19,219,517,481,483,135,287,34,765,1303,525,570,336;32;M
62219;1170,287,956,34,765,235,524,816,336,203,979,481,478,47,135;36;F
62243;711,1092,926,336;43;F
62282;34,483,236,781,219,336,203,766,1329,47,478,46,287,765,926;42;F
62323;1176,1170,236,1111,959,34,19,517,336,481;44;M
62364;239,101,969,570,524,216,236,956,235,926,135;36;F
62434;570,336,766,1111,287;27;M
62464;766,1176,1111,287,135;33;M
62470;478,21,19,101,766,34,287,336;30;M
62495;235,19,816,570,926,979,958,269,135,483,524,766,287,34,336;31;F
62527;239,102,1092,101,236,34,1303,1329,524,336,926,203,979,481,216;37;F
62557;239,102,21,816,336,481,216,759,766,34,711,287,926,478,483;27;M
62574;19,34,336;38;M
62590;269,481,958,926,969,239,135,287,271,478,1111,102,1170,1176,946;40;M
62591;1111,101,239,946,767,31,781,759,948,956,765,524,816,336,135;39;F
62592;1111,759,287,47,336,237,220,239,236,34,1303,525,219,203,216;40;F
62594;287,34,926;26;M
62618;926,524,287,478,236,101,201,34,525,219,47,816,570,336,203;28;F
62654;1111,781,148,34,517,336,481,1170,287,239,237,220,236,235,219;44;F
62684;287,34,21,1329,219,819,816,237,236,235,524,47,336,481,216;36;F
62691;946,239,102,236,781,336,926,287,148;35;M
62702;946,958,816,201,478,524,203,483,525,481,135;88;M
62711;270,969,31,781,1652,34,535,926,239,101,236,271,47;42;F
62722;236,46,524,47,1092,517,336,481,958,216,1176,478,287,34,1111;47;F
62749;336,287,1111;28;F
62751;101,1176,1170,1111,478,148,287,34,19,524,525,926,711,481,483;30;F
62809;287,969,47,478,766;44;F
62813;1170,236,781,34,765,524,336,926,711,102,1111,478,287,21,1329;36;M
62853;767,148,34,21,19,525,219,819,336,711,135,1176,1111,765,481;30;F
62897;524,1329,235,19,1303,765,781,478,959,1176,946,270,766,34,287;38;M
62907;483,270,766,759,269,1176,1170,236,1111,478,287,517,336,958,216;36;M
62973;102,969,959,958,269,135;47;M
63105;236,1111,781,148,759,19,517,570,926,135,1303,287,34,765,336;44;M
63118;517,481,958,1176,1170,767,781,948,34,765,135,946,236,336,216;17;F
63200;517,135,766,1176,236,478,781,148,287,34,765,1303,570,336,926;44;F
63250;765,759,781,766,1176,1170,1111,478,287,34,524,816,517,216,481;24;F
63292;216,1170,1652,287,19,1329,524,336,958,236,1111,34,517,926,481;10;M
63315;926,287,946,239,236,767,781,148,948,34,19,816,336,958,216;27;F
63325;759,959,1170,1176,270,220,766,236,478,31,287,525,570,481,958;33;F
63339;926,979,481,239,102,236,31,1652,956,524,47,1092,570,237,216;39;F
63343;236,524,570,478,287,1092,216,525;41;F
63348;148,1170,478,287,34,816;31;F
63362;478,948,19,570,481,135,483,926,1176,766,148,287,34,765,336;34;M
63436;781,148,765,1329,1092,570,711,481,483,478,287,34,524,336,926;39;F
63473;969,478,1652,287,34,765,235,1329,524,47,1092,336,926,711,216;40;F
63485;766,102,478,287,34,765,336,135;39;F
63567;766,239,101,956,765,235,524,1092,535,336,203,958,216,135;32;F
63607;47,481,946,31,236,46,235;33;F
63612;102,478,101,979,481,969,31,759,287,956,524,1092,926,237;42;F
63615;101,1176,1111,478,781,287,34,1329,524,47,336,711,203;36;F
63631;236,101,102,969,478,759,34,21,765,524,47,1092,46,336,979;37;F
63645;201,236,1111,959,1652,287,34,19,1329,47,517,336,926,481,958;48;F
63647;270,946,1176,1111,287,34,765,1303,1329,816,517,336,711,979,216;43;F
63695;525,270,271,570,269;55;F
63696;101,1329,711,979;34;F
63700;287,19,517,336,216,219,570,203,102,236,46,525,47,1092,481;59;F
63730;948,271,478,270,766,216,236,287,34,135,336;34;M
63733;1092,1176,102,478,781,21,765,1170,1111,271,287,34,819,517,481;47;M
63736;517,1329,19,34,287,1652,478,959,1111,236,1170,1176,101,239,766;77;F
63755;525,219,47,102,236,478,287,34,21,524,570,336,481,958,216;26;F
63759;1170,1111,1176,524,525,47,336;36;F
63760;946,766,1176,236,478,781,148,287,34,765,711,336,926,481,483;32;M
63769;203,336,47,1303,946,766,767,948,765;41;F
63780;816,203,481,220,216,958,336,1176,959,1303,239,1111,287,819;44;F
63799;1111,236,969,1170,1176,239,766,946,101,478,767,781,287,979,216;38;F
63837;946,767,948;42;F
63852;269,946,236,271,948,1303,767,31,148,34,19,336,237,216,135;38;F
63887;1170,236,1111,478,287,19,524,525,47,1092,517,336,979,481,237;43;F
63896;767,781,287,956,34,47,481;35;F
63937;148,958,766,1176,1170,1111,959,478,781,287,34,524,336,481,483;29;M
63944;481,483,270,946,1170,478,781,525,47,1176,1111,287,21,765,336;50;M
63965;478,816;28;M
63992;1176,102,287,34,926,219,47,148;48;F
64007;34,336,135,946,767,948;37;F
64009;1176,216,239,287,481,517,819,1303,1111;14;F
64034;236,525,819,203,958,216;41;F
64044;31,46,948,956,1092,269,236,959,781,148,34,47,819,336,135;39;F
64067;478,926,287,765,766,135,781;43;F
64121;1303,1170,102,236,46,287,765,19,525,219,47,570,336,203,481;88;M
64143;766,946,478,767,948,287,765,524;38;F
64163;31,969,102,101,781,524,1092,816,926,979;40;F
64165;220,1176,102,148,34,21,525,926,203;19;F
64210;1303,819;38;M
64229;1176,1170,1111,148,34,336,483,766,946,478,767,948,287,481,135;39;M
64241;766,946,767,948,765,336,135;36;F
64244;1176,1303,287,781,1111,201,478,524,525,203,481,483,135,148,19;18;M
64254;287,34,21,524,525,219,1092,535,517,570,336,711,203,481,237;36;F
64351;946,767,948;32;F
64359;135,767,959,236,239,946,270,478,31,287,34,19,525,570,336;38;F
64364;236,271,781,287,34,524,47,216,135,478,766,765,19,819,336;35;F
64389;336,926,979,766,946,101,767,781,948,765,525,570,481,958,135;40;F
64431;1176;32;F
64464;101,524,46,102,21,47,481;47;F
64487;1176,1170,1111,478,148,21,19,816,336,34,287;29;F
64491;239,1170,1111,287,235,517;34;F
64492;1170,1111,767,478,31,948,34,47,819,816,535,336,269,765,766;34;M
64535;1176,1170,236,148,19,819,216;66;F
64542;220,239,1092,336,216,819,525,956,759,31,969,101,781,34;38;F
64567;336,269,816,47,1170,1111,34,524;26;F
64578;478,759,287,1329,524,47,816,535,570,336,926,203,979,481,958;45;F
64628;1176,148,524,1092,336,19,525,47,481,236,1170,478,287;33;F
64629;478,767,271,781,948,287,34,19,570,203,958,483;42;F
64658;31,271,216,269,958,219,236,959,781,235,570,287,336,926,711;41;M
64659;524,203,481;18;F
64665;766,101,1176,102,478,781,287,21,765,1329,524,47,535,570,336;30;F
64669;946,765,525,47,135;47;M
64672;34,287,781,270,946,1176,1170,958,336,31,271,767,236,766,135;16;F
64685;1176,237,570,765,34,819,517,481,271,946,19,525,336,926,958;34;M
64687;102,1176,101,946,767,271,287,21,524,819,535,336,269,135;33;F
64688;1170,1111,478,1303,525,819,481,958,34,236,219,336,926,203,216;48;F
64701;766,101,1111,478,287,765,524,47;27;F
64709;478,767,271,781,948,287,34,19,570,203,958,483;42;M
64717;135,203,517,219,235,34,287,148,1111,336;37;M
64735;270,271,148,1652,287,336,481,269;3;M
64742;946,101,767,948,816,535;46;F
64747;765,766,948,767,946;37;M
64761;237,766,1176,1170,102,1111,478,287,21,235,517,336,711,481,483;35;M
64767;819,816,926,481,216,483,766,478;36;M
64791;1111,478,570,711,481,269,220,946,767,148,948,287,19,47,336;26;F
64794;46,148,1652,1303,19,1329,767,34,765,816,570,203,269,216,948;43;F
64838;102,478,759,287,524,47,979;24;F
64843;31,979,524,34,287,235,525,958,135;39;F
64848;1303,19,235,1111,1170,1176,101,478,287,34,524,570,336,711,481;35;F
64866;148;32;M
64885;478,287,926,483;49;F
64907;958,287,1111,959,271;42;F
64918;959,478,781,287,34,21,1329,524,1092,336,926,711,979,958,1176;26;F
64946;19,34,148,570,525,269,270,271;53;F
64953;959,1652,237,481,201,46,1303,766,946,1111,34,926,336,517,287;31;M
64989;269,271,958;44;F
65129;1176,1170,1111,287,34,517,336,481;39;F
65132;135;48;M
65232;766,946,969,236,478,767,781,948,1652,765,1092,336,203,269,135;39;F
65307;239,946,236,767,31,948,287,956,34,21,570,336,711,481,135;36;F
65313;31,34,525,336,481,483,959,271,819,570,135,478,287,19,524;32;F
65354;766,1176,478,148,948,287,34,765,47,517,336,926,481,483,135;60;F
65433;203,524,759,220,271,767,948,34,765,481,958,135,148,19,819;44;M
65443;483,781,956,525,570,926,766,946,767,948,287,34,765,336,135;32;F
65455;101,478,287,34,1329,524,47,336,711,958;37;F
65477;270,1170,1111,271,781,34,336,926,216,478;31;M
65500;517,336,926,203,481,958,135,766,767,781,148,948,287,34,765;30;M
65503;1092,135;34;F
65525;483,101,1111,34,21,524,336;45;M
65527;570,336,926,31,766,946,236,767,781,948,765,135;7;F
65540;711,237,269,135,239,287,34,19,979,216,236,1303,235,816,336;38;F
65644;102,236,478,781,287,765,1303,1329,336,926,483;50;F
65682;767,781,948,1652,34,956,1303,47,816,535,336,926,237,269,135;15;M
65683;1092,524,101,979;72;M
65717;1652,781,31,478,766,946,236,767,948,34,765;37;M
65746;269,926,570,524,19,946,766,959,478,948,287,765,1329,816,958;27;M
65747;535,816,47,1329,1303,948,781,766,946,239,969,236,336,926;9;M
65814;525,220,101,102,969,767,148,948,34,765,336,958,216,135,478;19;M
65831;1111,1176,271,148,287,956,34,765,19,47,517,336,481,269,135;29;F
65835;766,946,101,478,767,781,948,956,765,926,481,958,269,483,135;7;M
65843;270,101,1176,478,287,34,19,524,47,336,483;36;M
65846;220,239,236,235,219,237,216;70;F
65865;102,101,1176,711,926,336,1329;33;M
65877;287,34,47,336;67;F
65915;19,819,517,958,269,135,946,1176,1170,1111,478,148,336,926,481;26;M
65926;102,270,135,766,1170,148,481,478,31,46,287,19,711,958,483;47;M
65935;220,239,236,235,219,237,216;74;M
65947;101,1176,781,148,287,34,765,19,524,219,1092,816,535,336,203;46;F
65974;946,19,1329,525,819,926,958,135,478,956,765,235,336,481,483;55;M
65985;1176,1170,236,1111,478,287,21,524,47,1092,517,926,336,481,216;44;F
66005;101,102,969,478,781,148,1652,287,956,34,1303,1329,524,483,135;1;M
66006;101,1111,956,34,235,47,1092,819,535,481;39;F
66085;1111,287;30;M
66087;478,287,1329,525,219,926,203,236,781,34,21,47,336,481,216;44;F
66110;203,481,958,269,478,271,1176,1170,959,287,1329,525,819,336,216;45;M
66138;216,135,478,1652,287,956,34,219,47,819,570,926,979,481,237;41;F
66142;239;33;F
66143;1176,478,517,19,270,483,766,1111,1170,781,287,524,1092,336,926;58;M
66187;816,269,767,959,1176,220,570,926,958,271,34,21,235,819,481;42;M
66211;237,969,201,220,239,959,271,781,1652,34,19,816,958,269,135;8;F
66244;781,148,287,765,1329,525,1092,481,958,102,236,34,47,336,926;37;F
66299;481,483;44;F
66348;478,271,1176,767,148,287,34,570,1170,1111,765,819,517,336,481;49;M
66378;239,220,201,959,271,781,1652,34,19,525,816,958,237,269,135;8;M
66428;239;47;F
66459;1329;43;F
66460;203,1303,969,270,101,102,959,271,31,148,948,525,819,481,958;51;M
66549;1176,956,765,1329,570,958,781,34;34;M
66556;478,1176,101,1170,1111,781,34,535,517,481,483;43;F
66578;958,135,816,336;46;M
66611;148,525,236,31,34,570;38;M
66615;1111,517,481,483,1303,819;42;F
66653;148,219,570,270,271,21,525,819,336,765,287,1176,1111,34;33;M
66660;271,766,946,1111,478,948,287,34,19,525,219,517,926,203,481;30;F
66709;201,478,524,525,979,481,483,135;74;F
66736;239,46,19,816,535,979,101,31,956,34,235,524,47,481,958;31;F
66741;102,236,31,46,148,759,287,34,19,524,1092,535,570,336,926;47;F
66753;270,34,481,517,287,478,1170,1176,1111,524,1092,570,926,979,269;46;F
66762;478,271,287,956,21,524,481,958;39;M
66816;201,478,524,525,203,481,483,135;91;F
66839;135,926,336;48;M
66861;201,478,524,525,203,481,483,135;61;M
66883;201,478,524,525,203,481,483,135;59;F
66888;478,1111,1176,34,21,481;45;M
66935;135,336,34,287,46,148,1652;64;F
66999;270,1176,271,781,148,34,235,525,219,336,203,958,269;32;M
67004;956,31,336,926,287,481,1303,819;29;M
67118;959,34,766,946,767,948,336,135;35;M
67122;1303,570,1170,1176,946,781,525,1092,711,979,1111,287,34,47,336;61;F
67145;236,1170,1176,101,946,1111,478,767,287,34,19,524,47,1092,336;46;F
67210;958,34,19,525,336,1176,201,1170,969,236,1111,478,46,287,47;20;F
67259;236,46,148,765,1329,219,481,766,478,781,287,34,19,336,216;30;F
67389;766,946,767,781,948,1652,287,34,765,336,926;9;F
67399;946,948;60;F
67410;767,946,948;60;F
67438;767,948,946;48;F
67455;766,946,767,781,948,34,765,336,926;7;M
67468;270,201,483,135,926,1111,1170,1176,478,781,287,34,765,517,336;21;M
67516;926,216,483,102,236,478,781,759,287,34,21,524,47,1092,481;61;F
67528;969,239,101,102,271,956,34,1329,524,47,336,958,237,216,781;43;F
67604;958,1329,31,239,767,816,926,135,956,1652,201,203;39;M
67620;766,946,102,483,19,148,781,1111,287,34,336;53;M
67636;1176,1111,759,287,1092,336,926,711,979,481,135;19;M
67641;102,236,216,34,21,19,524,47,481;67;F
67660;781,1303,235,525,517,203,483,946,1176,956,570,336,926,711,481;31;F
67678;1176,1111,478,781,287,34,765,336,926,958;23;M
67779;34,765,19,1329,524,336,958,101,31,759,1092,535,926,711,481;54;F
67781;239,101,1176,1170,1111,478,31,781,287,956,34,336,517,711,481;11;M
67805;1329,287,1111,766,1176,1170,478,781,148,34,517,926,481,102,21;60;F
67808;239,101,1176,1111,1170,478,31,781,287,956,34,517,336,711,481;5;F
67811;101,47,287,19,1329;29;M
67820;21,102,47,46;63;M
67836;239,101,1176,1170,1111,478,31,781,287,956,34,517,336,711,481;4;F
67839;1303,19,219,1170,47,481,203,926,535,236,1176,220;23;F
67852;959,781,336,958;49;M
67857;1176,1170,1111,478,148,287,34,21,19,816,336;7;M
67864;203,102,236,1652,524,481,269,34,270,946,767,271,948,525,336;48;F
67972;1170,236,31,781,287,34;40;F
67988;336,481,517,1111;45;M
68064;478,47,958,269,979,926,1092,239,287,1652,34,765,1303,235,525;37;F
68146;1170,201,239,220,46,1652,535,570,336,203,979,958,269;12;M
68215;287,235,525,816,237,216,203,979,220,270,236,46,219,47;67;F
68253;766,101,236,220,148,946,287,34,765,525,219,47,1092,336,203;52;F
68263;525,47,959,239,148,46,535,336,203,979,481,958,269;11;M
68287;101,102,524,1092,535,201,203;71;F
68327;220,201,203,216;74;M
68358;759,287,1303,711,220,946,101,236,524,1092,535,336,979,481,216;35;F
68384;34,21,19,517,926,481,483,766,946,1176,1170,1111,148,287,336;47;M
68390;216,946,148,948,336,767,34,19,781,287,525,481,1111,1170,1176;21;M
68393;1303,979,535,46,203;62;F
68631;239;25;F
68699;236,148,525,219,819,517,483,1176,1170,1111,287,34,336,481,216;44;F
68711;483,203,148,946,236,478,34,819,1176,1170,1111,287,336,481,216;45;M
68725;102,1111,781,524,525,1092,926,203,979,287,47;39;F
68726;236,102,101,31,34,1329,819,336,711,216,483,269,979,271,270;37;F
68918;1092,979,481,216,269,220,101,102,46,287,21,524,47,535,336;43;F
68925;759,148,34,1303,271,767,1111,1170,201,239,101,102,236,478,216;49;F
68946;766,269,483,216,220,946,101,1303,219,47,535,926,711,203,979;57;F
68950;948,269,767,271,31,34,819;36;M
68991;766,481,483,926,767,946,1170,1111,478,148,287,34,765,19,336;29;F
68992;1111,1176,270,766,201,1170,478,287,34,524,517,336,979,481,216;37;F
69007;239,1176,767,148,287,34,1303;34;F
69010;101,1176,1111,525,336,481,269,216,1170,478,287,34,979,237,236;35;F
69052;766,101,102,271,31,148,535,525,524,1329,759,781,135,765,1092;38;M
69079;287,34,220,101,102,969,46,21,524,47,535,336,979,481,216;16;F
69083;287,478,766,946;62;M
69101;336,1170,236,1111,478,34,1303,525,219,819,926,203,481,958,216;13;F
69130;1170,236,1111,478,34,1303,525,219,819,336,926,203,481,958,216;46;M
69135;958,271,766,1176,1111,478,148,287,34,765,336;30;F
69149;1170,236,1111,478,34,1303,525,219,819,336,926,203,481,958,216;18;M
69164;816,336,926,203,481,781,946,767,948;38;F
69186;1170,1176,767,759,948,287,34,19,525,926,481,135,765,711,781;46;M
69208;203,481,958,483,135,766,236,31,287,34,19,524,525,1092,570;33;F
69234;767,478,969,102,239,946,101,759,21,524,47,1092,535,570,481;63;F
69311;34,1329,524,525,570,203,135;50;F
69329;767,759,948,287,1303,235,524,47,1092,816,535,570,203,979,481;66;M
69335;1176,1170,236,1111,478,287,926,216;33;F
69359;781,34,765,336,946,948,767;41;M
69363;478,767,759,948,1652,287,1303,524,47,1092,535,570,979,481,483;87;F
69414;765,21,287,948,148,781,767,270,478,271,34,524,926,269,135;28;F
69417;481,1176,220,101,1170,236,478,287,19,524,535,926,237,216;54;M
69484;102,271,148,287,34,819,483,135;53;F
69511;1176,1170,1111,19,478,287,34,336;34;F
69512;287,517,336;29;F
69535;781,1303,19,478,236,148,34,1329,336,203;71;F
69585;781,34,570,766,270,946,767,958,269,478,271,287,336;26;F
69635;31,478,239,287;31;F
69667;102,1111,287,34,21,517,336,216;38;F
69674;239;43;F
69675;781,239;38;F
69697;239,102,478,31,781,1652,135;40;M
69724;478,969,946,1176,483,19,765,148,781,101,766,1111,287,34,336;43;M
69903;239;39;M
69907;239,524,570,1111,759,287,34,517,336,269;38;M
69915;287,1176,766,517;21;F
69934;271,239;29;M
69983;1170,1111,478,781,517,34,524,816,216,570,819,1329,287,759,236;52;M
70059;216,148,816,336,101,478,781,759,287,956,34,1329,1092,570,926;31;F
70061;926,766,946,1176,1170,1111,478,781,287,34,765,517,336,481,483;62;M
70115;336,34,483,269,270,1176,1170,1111,478,271,287,517,481;37;F
70154;287;44;M
70169;235,46,220,101,478,148,287,34,1303,1111,781,19,1329,336,926;36;F
70199;525,287,766,946,478,767,148,948,34,765,926,711,958,483,135;47;F
70224;570,969,101,1176,1170,236,1111,478,287,34,47,1092,979,958,483;46;F
70239;271,269,46,34,765,19,219,47,236,203,216;36;F
70272;1170,1111,478,759,1652,287,524,517;42;F
70320;926,766,1176,102,1170,236,1111,478,287,34,21,517,481,483,216;30;M
70349;1111,236,102,766,1176,1170,478,781,287,34,517,481;43;F
70366;216,570,34,46,236,969,102,201,101,239,220,478,287,524,47;39;M
70391;767,781,148,948,34,765,525,570,926,958,135;48;M
70419;270,239,271,19,336,269;35;F
70458;270,271,19,524,336,269;8;F
70478;271;38;F
70493;270,271,759,19,524,1092,269;3;F
70504;517,481,101,1176,1111,287,19,958,47,1170,478,781,34,979,336;42;F
70543;959,781,34,1092,570;61;M
70591;481,236,781,570,203,135,34,765,336,926,958,269,946,959,767;43;M
70603;819,517,336,481,269,1176,1170,1111,478,765,525,203,148,287,34;48;F
70630;34,525,1092,135,946,236,767,948,765,47,570,336,958,237,216;46;F
70635;235,1329,570,958,269,816,219,1303,216,781,34,525,481,336,711;49;M
70758;946,767,948,819,570,711,135,1176,148,336,781,481,478,483,34;35;M
70772;926,979,216,101,1176,1170,1111,959,478,759,287,1092,336,481,958;35;M
70810;926,336,535,47,524,235,236,969,956;32;F
70863;236,1111,148,34,765,1303,524,525,570,336,203,216,270,271,269;28;F
70896;958,237,979,570,524,759,781,767,1111,766,21,816,711,216,135;59;M
70916;21,236,946,101,959,767,781,948,34,1329,524,525,570,203,216;45;F
70950;946,1111,926,481,483,269,336,816,34,287,148,478,570,979,958;30;M
70956;781,956,19,525,979,237,336,102,478,287,34,765,21,570,216;47;F
71023;1170,1176,766,946,236,781,148,948,34,765,525,819,336,203,481;34;F
71069;102,478,31,781,287,34,21,765,524,525,816,570,336,237,216;46;M
71081;236,926,216;57;M
71098;203,481,237,101,236,287,34,1329,219,47,570,517,336,926,216;36;F
71137;767,236,102,478,31,781,287,21,34,525,336,926,979,237,216;14;M
71138;269,270,135,336,819,47,948,956,767,959,969,101,946,958,271;31;M
71181;336,203,481,969,1111,478,535,270,271,269;31;F
71191;517,1170;44;M
71347;525,759,1111,946,46,1176,239,287,34,524,47,517,570,336,203;34;F
71370;270,101,271,1652,235,979,237,269;37;F
71372;481,483;36;F
71559;148,287,34,765;30;M
71562;1170,1111,148,478,781,287,34,765,19,816,336,926,958,216,483;24;F
71585;1170,766,1176,102,1111,478,148,287,34,21,765,19,524,336,481;25;M
71619;765,1303,1329,926,979,1176,287,34,235,816,517,336;28;F
71634;101,781,148,203,220,946,765,478,767,948,287,34,1303,336,481;36;F
71670;781,946,767,948;38;M
71708;781,34,336;32;M
71717;287,336,979,1176,1170,517;25;F
71724;271,148,236,570,336,203,481,237,766,1111,31,1652,287,34,765;31;F
71725;766,101,765,524,336,926,711,958,135;24;M
71730;478,336,135,201,203;71;F
71773;239,781,148,21,34,135,946,767,948,287,956,765,47,926,711;35;F
71775;101,236,969,478,767,781,948,287,34,235,765,336,926,711,135;33;F
71785;958,481,203,336,517,816,219,19,1303,34,478,1170,1111,287,819;45;F
71798;101,148,517,216,1176,1170,236,1111,478,287,34,21,1092,336,481;39;F
71836;765,524,958,483,102,148,287,21,19,525,1092,336,203,711,481;33;M
71859;766,270,135,101,969,1111,478,287,34,19,47,517,336,481,483;67;F
71871;31,46,1329,219,1092,816,958,759,765,1303,524,47,570,203,979;51;F
71876;759,19,525,219,336,34,478,517,216,1176,1170,236,781,46,287;47;F
71915;336,287,926;25;F
71924;1170,1111,478,287,34,1303,19,219,819,816,517,336,203,481,958;39;M
71972;948,767,766,946,781,819,481,216,236,478,148,287,34,765,336;27;F
72009;220,1176,102,1111,31,46,287,956,34,21,19,570,336,711,481;40;M
72077;765,34,948,148,271,767,1111,478,101,959,781,956,336,481,958;47;M
72149;767,271,101,1176,1170,1111,287,336;37;F
72158;236,781,287,34,47,336,481,1176,1170,1111,478,1329,517,979,216;30;F
72160;1092,135,535,1329,765,948,46,478,767,766,946,239,101,201,203;86;F
72211;31,478,236,766,239,220,946,767,948,1652,287,956,34,1303,235;47;M
72212;946,1176,1170,102,1111,959,148,21,478,34,524,47,481,287,336;33;F
72373;946,478,524,926,483,1176,1170,1111,759,287,34,517,336,979,481;31;F
72379;1176,101,766,239,946,969,478,767,31,781,148,948,287,34,47;31;F
72403;1303,216,101,1176,31,781,46,34,524,525,336,570,926,958,237;30;F
72480;237,239,956,34,47,816,135,336,524,287,759,31,102,201,101;34;F
72603;766,239,236,287,203,220,1176,102,34,21,1303,235,1329,47,979;29;F
72673;101,31,765,525,979,524,1092,570;76;F
72676;336,34,926;26;F
72704;1170,236,478,287,21,570,481;47;F
72735;926;55;M
72763;765,570,926,481,135,946,239,478,767,31,948,287,34,524,336;36;F
72774;1652,759,270,271,269;33;F
72806;31,19,47,781,34,481,1170,1111,21,524,1092,535,336,101,1652;41;F
72870;1176,1170,148,524,47,819,517,336,979,481,958,237,269,483,135;41;M
72964;1176,1170,478,517,926,481;25;F
72988;766,946,1170,781,483,135,1176,1303,1329,525,219,1092,926,711,203;51;F
73030;102,781,1652,34,21,235,524,47,1092,819,336,481;36;F
73110;969,535,946,101,46,767,47,1092,336,711;56;F
73190;478,271,31,46,287,1652,235,1329,524,517,926,237,269,216,483;6;F
73223;1176,1170,236,1111,271,781,46,956,34,19,336,979,959,481,958;46;M
73299;236,201,216;18;F
73486;235,336,270,959,271,781,287,34,19,958,269;9;F
73544;781,287,34,19,336,269,270,271,958;38;M
73572;1170,1111,478,287,34,524,517,336,481;46;M
73584;483,478,201,203;34;F
73621;478,201,483,203,481;39;M
73640;1170,46,34,525,219,517,216,483,478,287,765,524,336,203,135;24;M
73657;19,236,101,524,525,203,336,711,201,478,926,481,958,483,135;40;F
73659;201,478,481,203,483;6;M
73664;767,148,948;18;M
73688;201,478,203,483;2;M
73694;270,101,102,271,46,34,21,524,47,1092,819,336,481,958,269;54;F
73702;201,203;37;M
73719;201,203;7;M
73731;201,203,483;37;F
73732;102,34,21;46;F
73814;201,203;44;M
73820;765,959,287,34,19,819,336,926,481,958,269;27;F
73826;767,148,948;44;F
73830;201,203,481;8;M
73845;201,478,203,481;43;F
73881;31;84;M
73882;31;41;F
73897;201,203;67;F
73913;926,956,287,948,478,766,767,781,34,765,711,135;38;M
73919;201,203;83;M
73930;31;49;M
73939;201,478,481,483,203;48;M
73956;201,478,203,481,483;42;F
73971;201,478,203,481,483;6;F
73980;31;14;F
73988;201,203;3;M
74008;31;10;M
74025;958,969,101,946,478,767,781,948,287,34,926,483,135;50;F
74089;926,711,524,956,287,781,478,236,34,765,336,216,237,269,135;47;M
74138;1652,481,483;48;F
74143;481,220,1652,765,1303,235,525,47,816,203,216,336,34,287,236;43;F
74181;478,767,148,819,570,203,1652,287,34,525,47,336,979,958,135;38;F
74207;336,979,220,239,101,1176,969,478,781,287,34,524,767,946,948;25;F
74253;239,101,1176,1170,1111,478,31,781,287,956,34,517,336,711,481;37;F
74343;102,478,21,47,336,979,481,216,819;23;F
74353;959,34,19,1092,135,946,478,287,765,336,481,958;25;F
74377;979,926,336,524,287,781,478,1176;31;M
74403;483,203,336,517,819,1092,219,47,524,1111,216,1329,34,1176,481;49;F
74428;271,148,958;45;M
74482;765,336,926,481,483,525,1329,19,148,1111,287,1176,1170,478,34;38;F
74498;956,959,102,21,47,816,336,958;45;F
74521;819;65;F
74542;336,765;49;F
74556;819;50;F
74559;1170,478,148,287,34,336,926,481;45;F
74595;220,946,201,767,478,948,765,1329,219,525,926,203,481,483,135;42;M
74609;220,946,201,478,767,948,765,1329,926,203,481,216,135;69;F
74615;270,1176,517,979,269,766,478,148,287,34,19,524,47,336;25;F
74635;946,287,478,101,969,237,46,47;47;M
74678;101,102,1111,959,781,47,336,979,958,269,483,478,287,34,19;30;F
74709;959,271,287,956,34,1303,1329,819,336,269,135,946,767,948,926;38;F
74721;46,1170,236,959,219,517,336,203,481,958,135,478,216,287,34;30;F
74746;946,287,478,101,969,237,46,47;31;M
74758;766,1176,287,34,19,336,1111,959,781,956,570,958,135;34;M
74863;1303,711,135;42;M
74887;47,46,237,969,101,478,287,946;28;F
74891;959,34,19,336,958;41;F
74941;239,31,220,1329,524,525,570,203;47;F
74943;31,759,287,956,34,21,1303,524,525,47,1092,570,336,711,958;40;F
74952;287,478,101,969,237,102,47,946;19;F
74978;524,483,135,481,201,478,525,203;21;F
75022;287,478,101,969,237,46,47,946;41;F
75057;101,270,102,47,517,766,1176,1170,236,1111,478,759,287,1092,483;44;F
75154;287,525,47,517,203,481,483,236,478,31,759,34,524,570,336;41;F
75173;1111,478,203,525,1176,1170,481,287,517;27;F
75217;270,47,948,287,765;20;F
75235;1652,34,926,1303,216;24;F
75250;47;54;F
75276;946,948;43;F
75306;239,271,34,47;45;F
75316;102,1111,46,21,524,47,926;43;F
75338;1170,102,236,478,46,287,21,19,525,47,816,570,336,203,958;28;F
75339;946,948;43;M
75349;959,946,948;17;M
75371;946,948;12;F
75397;969,236,102,34,1111,1170,31,287,956,570,524,525,47,816,711;32;M
75401;946,948;64;F
75433;958,570,524,235,19,236,959,102,766,767,46,148,948,34,47;36;F
75448;570,34,287,148,481,1176,1170,236,1111,478,46,525,219,517,203;30;F
75579;1111,1303,819,46,34,336,481,1176,236,524,525,216;69;F
75592;478,959,1176,34,19,958;45;F
75603;34,236,781,148,287,765,1329,524,1092,47,336,926,979,483,216;40;F
75611;1111,46,759,34,19,47,819,535,517,203,979,481,958,269,483;42;F
75622;135,765,958,767,759,219,235,946,948;52;M
75675;1329,236,46,47,926,481,216;43;M
75704;759,34,336,287,47;54;F
75731;34,948,46,271,478,236,766,270,1176,1170,1111,148,287,819,481;17;F
75841;478,271,946,517,958,481,269,135,969,101,1176,1111,287,765,336;34;F
75846;759,102,1170,1111,287,21;49;F
75858;102,478,759,287,21,47,711;48;F
75948;926,336,517,287,1176,1170,1111,781,34,19,819,481;38;M
76029;101,102,236,34,21,235,524,1092,535,336,926,269;35;M
76033;101,767,759,524,47,1092,819,481,958;44;F
76061;1176,1111,287,336;54;F
76065;270,1176,1170,236,1111,478,46,287,219,517,926,979;27;F
76089;21,524,570,336,926,958;37;F
76139;1176,1170,1111,478,287,517,483;32;M
76155;102,236,1111,46,948,34,21,765,19,47,1092,816,517,336,979;35;F
76160;239;21;F
76162;239;22;M
76213;1176;28;F
76229;287,1652,781,271,1111,1170,101,270,766,946,767,948,34,765,135;74;F
76260;270,478,46,926,203,1176,1170,1111,287,34;28;M
76287;239;34;F
76327;478,19,1329,524,525,47,570,958,148,1652,287,34,1092,336,926;34;F
76330;239;29;F
76331;959,946,34,239,1176,102,148,21,765,1303,19,235,524,481,483;41;F
76397;148,287;51;M
76409;201,271,1170,1111,148,1303,235,219,819,570,336,31,46,287,525;28;F
76440;766,270,1176,1170,1111,478,287,517,481,483;40;M
76507;239,101,102,969,31,287,956,21,524,47,481;32;F
76532;926;47;F
76589;781,101,759,767,948,926,570,287,34;27;F
76594;1111,236,31,781,148,287,765,525,219,47,816,570,203,483,135;55;M
76607;287,219,47,816,979,269,270,236,765,525,336,203,216;61;F
76608;271,781,34,1303,336,1652,201,478,524,525,926,203,481,483,135;85;F
76661;1329,711,781,767,236,219,203,481,958,946,148,287,34,19,336;31;M
76733;478,525,219,1176,816,517;23;F
76769;478,481,483,135;34;M
76771;959,781,148,1652,34,21,19,235,1329,524,1092,517,336,481,483;37;M
76805;239,47,336,926,958,237,135,946,767,948;35;F
76808;766,946,478,767,948,287,1303,1329,816,926,135;67;M
77100;47,135;40;F
77157;481,483;57;F
77180;1176,517,946,102,1111,759,287,21,816,926,711,1652;18;M
77209;478,926;50;F
77222;481,979,336,1092,524,1329,1303,34,287,1652,759,478,1111,1176,101;70;F
77315;31,102,765,478,781,34,21,524,47,336,926,135,946,767,948;41;M
77371;1176,1170,236,1111,47,481;50;F
77398;101,287,765,979,219,1303,956,31,236,34,235,525,203,336,135;38;F
77463;102,47,483,517,478,766;31;M
77484;102,336,31,101,1652,47,946,767,781,948,34,21,765,926,135;41;F
77552;216,270,271,269,483,1176,1170,1111,478,287,21,19,336,34,816;13;M
77556;1303,819,517,483,946,148,287,34,21,765,19,336,711,979,481;29;F
77562;1170,1176,517,336;41;F
77602;1652,47,958,31,781,21,135,336,765,34,101,946,767,948,926;11;M
77661;287,1329,979,47,524,1303,21,1111,102,1170,1176,517,926,481,216;28;F
77685;483,1092,1303,1176,336,711,524,1329,34,948,781,767,236,102,946;46;M
77693;478,524,926,287;33;M
77701;102,1652,287,21,34,765,524,47,926,135,781,31,946,767,948;8;F
77743;287,220,524;31;F
77810;239;36;M
77873;946,948;82;F
77877;946,1170,478,759,1176,1111,781,46,1652,287,34,19,336,926,481;9;M
77900;946,948;61;F
77920;236,781,148,287,34,765,1329,524,47,1092,336,926,979,216,483;10;M
77946;236,781,148,287,34,765,1329,524,47,1092,336,926,979,483,216;7;F
77950;135;42;M
77979;203,236,46,816,535,336,979;45;F
77989;236,781,148,287,34,765,1329,524,47,1092,336,926,979,216,483;42;M
78027;101,946,1176,239,766,270,102,236,478,271,287,148,201,525,203;36;M
78036;956,19,570,711,220,239,481,483,1329,1303,21,1176,525,781,1111;39;M
78078;481,781,34,287,148,271,767,478,1111,1170,1176,270,517,336,269;26;F
78087;481,336,979;45;M
78109;219,237,216,201,102,969,21,979,203,46,535;43;F
78195;926;55;M
78334;101,1111,478,287,524,47,1092;48;F
78348;220,766,270,1176,1170,478,148,948,34,235,1329,525,517,570,203;31;F
78360;148,287,336;28;F
78385;201,956,216,135,946,102,236,926,711;53;F
78505;148,819,481;32;F
78543;1111,1176,46,525,219,570,481,203;47;F
78592;101,1176,478,781,21,19,235,525,47,535,336,926,711,979,958;42;M
78604;271,926,946,767,948;46;F
78631;270,766,1111,478,148,287,34,19,525,517,336,926,203,1176,1170;25;M
78681;287,336,570,148,34,926;30;M
78696;1176,201,102,1329,336,926,959,781,956,958,34,19;42;M
78746;219,47,711,203,979,958,216,101,102,959,34,765,1329,336,926;25;F
78747;767,271,948,570,203,481,1111,287,34,765,19,819,517,336,958;47;M
78771;101,969,287,34,524,47,336,481,979;45;F
78798;767,969,34,101,1111,959,478,287,524,336,481,958,483;29;M
78839;271;88;F
78853;203,219,765,34,1170,1176,236,1111,478,287,524,1092,517,481,216;44;F
78867;525,926,1176,1652,34,287,478,1111,236,1170,237,517,481,483;33;F
78876;1111,236,1176,1170,237,517,481,483;37;M
78877;946,270,570,926,481,135,766,239,959,478,34,235,524,47,336;35;M
78882;271;91;M
78901;46,781,969,1176,220,101,1111,959,1652,34,47,1092,819,979,958;43;F
78934;47,219,524,765,781,959,101,946,236,478,287,525,570,926,203;36;F
78969;1176,287,517,958,237,1303,781,239,236,1111,34,524,819,336,481;44;M
78987;1111,19,819,958;43;M
79014;34,525,816,336,926,203,979,216,239,236,1303,235,47,535,237;31;F
79176;781,34,926;39;F
79182;1111,478,287,816;52;M
79208;478,271,31,148,287,34,19,819,517,336,926,481,958,269,483;31;M
79350;1176,1170,236,1111,478,46,148,759,19,819,517,711,216;70;M
79418;535,236,759,287,19,525,47,216,101,959,781,34,524,336,958;42;F
79420;1092,287,478,1176,236,524,148,1111,47,46,101,102,979,570,336;47;F
79484;525,483,1176,1170,1111,478,781,287,34,19,219,517,926,203,481;37;F
79522;1329,19,34,287,517,926,958,1176;29;M
79563;517,481,766,270,946,1176,1170,478,781,287,819,336,926,958,135;37;M
79643;34,19,47,819,481,237,946,969,236,767,948,219,926,203,135;35;F
79674;1170,478,46,1303,219,220,270,101,102,781,47,483;37;F
79691;31,478,102,1170,239,220,201,236,34,235,219,819,336,926,203;33;F
79703;517,819,34,148,287,781,767,478,959,1176,946,481,958,269,135;47;M
79732;270,271,269;10;M
79736;270,271,269;7;M
79754;220,287,235,524,819,517,269,1111,19,47,570,336,481,959,958;47;F
79761;766,1111,478,287,135;53;F
79778;767;43;M
79801;946,1170,236,959,46,148,287,19,816,926,958;28;M
79804;236,1111,781,148,287,34,765,1329,525,219,570,336,926,481,216;45;F
79805;1111,1170,766,1176,148,287,34,765,1329,524,517,336,926,481,958;19;F
79827;102,148,34,21,765,19,47,336;55;F
79850;767,946,1111,948,1652,287,34,21,765,47,336,926,711,958,483;38;F
79942;766,1111,956,1329,979,135,287;44;F
79963;767,31,948,287,47,1092,102,239,220,101,535,926,481,483,135;42;F
80032;1652,235,203,979,958,1176,1170,1111,478,287,34,1092,336,926,481;47;F
80132;1176,1170,1111,959,478,948,287,34,19,481,483;28;F
80186;1652,34,524,47,535,926,481,101,239,21,525,816,979;43;F
80288;34,481,216,1176,1111,287,517,336;30;M
80291;269,271;37;F
80319;34;42;M
80322;781,34,287,235,816;36;M
80394;102,765,135,948,946,767;38;M
80399;1652,270,1176,1111,271,34,956,19,819,517,336,711,958,269,483;34;F
80518;270,959,478,271,781,148,287,34,19,235,336,958,269;7;M
80546;269,148,271;39;M
80587;46,271,767,201,946,236,19,237,148,1303,525,219,570,203,481;48;M
80619;478,781,148,34,765,1329,517;63;M
80706;478,216,481,517,34,287,1176,102,1111,759,21,524,1092;25;M
80783;270,271,148,1652,336,481,958,269;1;M
80823;766,946,959,767,948,34,21,765,19,535,336,481,958,135;49;M
80839;216,483,270,1176,1111,271,1652,287,34,19,235,524,336,958,269;43;M
80840;969,1176,781,524,766,1111,478,336,270,101,1170,148,34,287,271;43;F
80856;336,270,102,271,31,148,21,47,269;38;F
80867;1111,46,34,19,235,525,816,570,926,203,958,483,478,781,287;44;M
80873;270,271,19,958,269;42;M
80874;269;41;F
80897;766,270,271,765,336,269,135;46;M
80948;271;32;F
80960;1170,101,270,478,271,759,19,235,1329,524,336,481,958,269,216;8;M
80990;31,21,524,926,979,481,237,216;54;M
81006;926,47,287,220,236,148,524;23;M
81010;1111,287,19,570,958,216,1176,236,781,34,336,481,1092,819,1303;48;F
81027;1176,101,270,478,271,759,1652,287,19,235,1329,524,336,958,269;6;M
81076;1652,478,969,766,270,1111,271,759,287,19,1329,524,336,958,269;67;F
81102;956,1303,570,926,969,959,271,148,34,19,47,336,481,958,269;46;M
81132;1176,1170,1111,478,781,1652,287,19,235,1329,524,1092,271,270,269;48;M
81173;101,524,47,481;56;F
81266;481,1303,19,948,1111,969,239,1176,148,287,819,816,926,946,236;24;M
81279;336,958,220,239,101,767,948,287,524,47,535,926,481,483,135;50;M
81280;269,135,478,767,216,336,816,948,21,102,946,483,34,47,287;24;F
81301;34,287,148,31,478,969,101,270,220,271,759,481,958,269,135;35;F
81335;525,1176,478,1170,135,819,517,287,481,1111;38;M
81435;135,958,959;44;M
81459;1170,1111,478,271,34,765,819,336,958,1176,148,19,979,711,816;15;F
81488;237,216,239,101,102,236,31,956,21,235,524,47,570,711,979;32;F
81553;959,958;13;M
81586;926,478,1111,1170,535,46,1092,517,336,203,979,481,958,269,483;5;F
81599;216,816,239,201,478,524,525,203,481,483,135;20;F
81609;287,956,34,816,959,271,148,1303,19,47,336,926,481,958,269;10;M
81611;759,34,525,47,1092,535,711,203,979,101,478,46,287,765,336;45;F
81643;148,271,767,1111,102,1170,946,478,31,287,34,524,525,336,203;40;F
81656;19,34,287,478,1111,236,1170,1176,481,958,269,46,535,203,979;10;F
81701;270,765,269,216,1176,201,478,524,525,203,481,483,135;20;F
81717;570,216,946,236,1111,711,201,1176,759,525,524,219,203,481,135;19;F
81726;969,781,287,34,1303,47,336,481,959,271,148,19,926,958,269;12;M
81739;535,287,1111,1170,101,517,1176,201,478,524,525,203,481,483,135;20;F
81784;201,1176,239,946,969,271,1652,287,956,1303,1092,819,336,711,483;36;F
81809;525,766,21,483,148,517,481,1176,1170,1111,478,287,34,19,336;28;M
81862;101,969,478,781,46,287,34,765,524,47,1092,336,203,711,979;71;M
81866;969,201,239,34,19,47,926,979,958,216,270,271,481,269;37;F
81988;765,336;34;M
81999;216,979,956,478,270,958,271,287,34,19,235,47,926,481,269;10;M
82026;1176,1111,959,31,781,148,287,19,1329,517,570,926,34,336,481;46;M
82041;483,525,1329,766,236,1111,478,46,287,816,336;37;M
82075;270,271,269;8;M
82091;46,102,759,287,21,926,481,1176,1111;24;M
82176;979,216,34,956,287,1652,31,478,236,969,270,271,269;5;M
82235;766,946,525,958,219,517,203,979,216,336,47,287,1111,1176,220;26;F
82250;287,759,46,781,31,1111,1170,478,1652,1303,47,517,336,481,237;37;M
82254;270,478,271,287,34,235,47,926,979,958,481,216,269;3;M
82271;759,19,525,269,1170,1111,517,336,958,926,483,287,478,236,1176;23;F
82276;525,1329,1170,1176,101,270,102,1111,478,287,34,21,765,336,926;31;F
82297;270,478,271,1652,287,34,19,235,47,926,979,481,269,216;44;M
82306;759,219,570,203,1111,478,781,287,34,1303,525,336,926,711,481;36;M
82324;946,767,948;15;F
82326;269,270,766,271,148;42;F
82342;101,1176,1170,1111,287,34,21,524,47,1092,535,517,336,979,481;45;F
82345;336,481,483,1176,1111,478,148,287,34,816;25;M
82348;946,1176,236,1111,478,287,34,1303,524,525,219,570,926,203,481;41;M
82384;711,34,336,1170,1111,781,765,201,478,524,525,203,481,483,135;48;M
82408;524,235,956,101,969,946,767,948,34,765,47,535,336,203,135;39;F
82424;239,31,781,1652,34,1303,525,570,336,979;35;F
82490;1176,481,819,239,237,235,220,287,1111,236,525,219,570,203,216;34;F
82514;1652,781,31,271,102,270,766,946,46,767,948,34,765,336,481;42;F
82523;46,816,759,31,1111,969,239,34,287,336;40;F
82536;237,958,47,34,1652,46,271;40;F
82553;270,271,948,19,819,481,926,517,34,287,478,1111,1170,1176,336;7;M
82557;766,46,287,34,21,517,481,203,336,219,525,1170,1176,1111,236;36;F
82590;979;66;F
82605;220,102,236,47,816,216,148;38;M
82626;34,46,1652,478,969,946,101,236,767,759,948,287,21,524,135;36;F
82650;220,47,819,336,926,481;21;F
82708;481,102,34,1329,19,525,219,203,1176,1111,478,21,235,926,216;42;F
82720;958,237,759,478,959,969,979,47,31,1111,1170,1176,239;47;F
82779;19,47,269,481,336,203,1303,759,969,946,101,1176,1111,287,524;36;F
82796;946,236,959,948,767,781,287,956,34,525,819,336,926,958,483;34;M
82896;19,781,31,271,959,270,101,956,34,1303,816,336,926,481,269;8;M
82904;220,1092,481,759,46,102;29;F
82908;948,956,19,235,524,47,819,517,336,926,711,1176,31,287,481;33;F
82963;478,287,765,570,135,948,946,767;36;F
82975;767,766,946,959,948,287,765,336,1176;21;M
83016;236,766,525,336;30;M
83036;483,926,958,34,819,525,336,956,287,781,767,948,959,236,946;3;M
83081;765,216,336;34;F
83090;102,969,236,31,148,956,34,21,1329,570,336,926,237,216;3;F
83113;483,819,1176,101,517,102,1111,148,759,287,34,19,524,336,481;35;F
83125;1170,478,958,946,767,271,148,948,34,765,19,819,336,481,135;16;F
83129;239,236,31,759,287,956,34,235,524,1092,336,926,711,481,216;32;M
83202;781,31,271,959,101,270,956,34,1303,19,816,336,926,481,269;4;F
83220;711,926,336,570,524,1329,235,34,956,759,148,31,236,102,239;2;M
83227;101,236,478,148,287,34,19,524,525,570,336,711,237;50;M
83268;21,19,524,819,483,766,1176,1111,478,287,34,517,336,926,481;34;M
83297;236,101,239,102,478,759,21,47,517,1176,1170,1111,781,287,34;43;F
83299;102,236,781,148,287,34,19,1329,336,926,711;50;F
83304;216,237,203,711,926,570,524,34,956,759,148,31,236,102,239;4;F
83321;1176,34,765,525,336,203,135;50;M
83383;236,478,766,946,767,148,948,287,34,765,819,481,483,135,336;37;F
83401;239,201,1170,1111,478,287,47;30;F
83461;271,287,34,819,481,958,269,135,767,148,19,336;39;M
83471;979,926,816,1652;11;F
83475;946,767,948,926,958,135,336;35;M
83514;926,34,271,969;50;F
83572;1111,478,767,148,21,517,781,287,34,765,19,336,926,481,135;32;M
83626;220,239,1170,236,148,287,34,19,1329,524,47,1092,816,336,483;31;M
83657;524,481,525,21,203,979,816,102,1652,926,216,1111,1176,1303,819;28;F
83666;1111,148,481,1176,766,478,926,336,34,287;32;M
83686;287,570,203,979,483,135,102,969,759,1329,524,47,1092,535,336;34;F
83723;946,1176,148;34;F
83728;948,271,1111,148,287,34,336,203,481,269,216;32;F
83784;767,271,148,948,765,819,336,481,236,1111,287,34,19,958,269;35;F
83792;1092,478,969,1176,946,1170,1111,46,759,1652,47,819,816,535,336;44;F
83808;958,269,270,1176,1170,1111,478,271,148,287,34,47,336,481,483;32;F
83817;236,31,1652,287,34,1329,47,570,926,481,216,483;36;F
83837;19,959,236,1170,1176,766,1111,478,148,287,34,765,269,336;32;M
83856;979,216,1329,235,1303,34,1652,46,478,1176,1111,19,47,336,958;38;F
83879;239,236,1111,478,759,287,34,524,235,47,1092,517,570,481,483;67;F
83905;271,34,21,19,336,481,483,478,767,926,287;28;M
83906;946,148,19,336;31;M
83915;759,1303,19,235,524,535,517,570,926,203,979,958,237,483,135;6;F
83933;946,236,478,767,759,948,287,34,47,535,336,483;28;F
83962;101,1111,1092,47;49;F
83999;219,524,235,1170,946,1176,102,236,1111,478,287,21,47,1092,517;56;F
84008;216,958,336,34,1176,1170,1111,959,478,287,235,19,819,517,481;9;M
84023;765,201,34,1303,1092,203,220,946,239,236,767,948,336,237,135;69;F
84094;336,711,979,481,216,1176,1170,236,1111,478,759,287,34;33;F
84103;236,1111,781,148,34,336,958,481,1176,525,926,816,21,287,102;30;M
84116;766,1176,1170,236,1111,478,287,21,19,235,819,517,481,958,216;5;M
84120;1170,102,236,1111,959,781,148,765,336,926,979,46,34,47,946;41;F
84121;946,1176,1170,969,1111,478,46,759,1652,1092,816,819,47,535,336;14;M
84137;819,535,269,946,34,478,1170,101,766,287,47,336,481,216,483;40;F
84154;46,759,287,956,765,1329,524,1092,535,336,926,711,979,958,135;3;M
84169;946,1176,1170,969,1111,478,46,759,1652,1092,816,819,47,535,336;17;M
84203;765,336,926,711;36;M
84227;336,819,34,287,781,1111;50;M
84231;819,1170,1111,478,287,525,481,926,1329,336,958,483,517,1176,766;19;M
84254;1092,765,34,287,236,102,1176,101,766,946,959,767,948,956,958;72;M
84255;239,101,102,969,31,46,759,287,956,765,1329,524,1092,535,336;1;F
84295;102,236,148,287,34;67;F
84309;979;63;F
84319;239;51;F
84349;1176,948,956,765,926,269;34;M
84405;766,220,946,1176,201,959,148,287,34,19,525,517,336,481;29;F
84453;956,711,236,336,926;37;M
84471;102,287,34;24;F
84507;478,1111,1176,766,270,135,926,34,287;33;M
84520;535,926,958,237;14;F
84528;135,101,1111,478,948,481,216;30;M
84542;101,1176,969,1111,478,148,287,956,21,524,525,517,979,481,269;31;M
84544;19,21,34,287,148,478,1111,102,1170,1176,239,517,336,926,481;32;M
84568;239,236,46,481,958;42;F
84570;203,765,34,236,101,220;27;F
84658;287,46,236,478,781,34,21,711,481;58;M
84678;287,819,269,135,1652,1111,270,766,946,236,767,271,948,34,765;39;M
84682;1092,478,101,969,236,31,1652,287,956,34,235,524,525,570,135;35;F
84721;270,1176,1170,1111,478,271,948,287,34,19,819,517,336,926,481;4;F
84930;102,236,525,47,570,926,336;34;M
84955;236,478,46,287,34,1092;61;F
85206;1176,271,478,959,1111,102,270,766,946,767,287,34,765,135,711;34;M
85260;1176,201,47,336;55;F
85482;235,47,816,711,765,524,570,926,481,1176,959,31,34,1329,336;34;F
85486;766,946,948,767,765,926;38;F
85488;101,765,1111,478,781,148,287,34,19,524,517,336,979,481,483;34;F
85493;201,203;42;M
85543;1170,1111,34,19,336;50;F
85580;239,270,766,1176,478,34,235,1329,524,816,336;33;F
85651;766,220,236,1111,31,956,34,19,47,819,203,958,216;37;F
85676;1111,1170,1176,34,19,517,481,958;42;M
85701;765,1170,220,270,1176,1111,478,287,525,816,517,711,926,203,483;26;F
85704;946,270,47,481,269,216,483,135,271,766,969,478,287,21,926;30;F
85707;236,1111,781,819,336,135,766,478,271,148,287,34,47,481,483;36;M
85717;524,1092,336,102,236,19,525,47,816,570;41;F
85731;135,483,148,766,270,239,201,1170,1111,959,478,287,19,1329,47;17;M
85749;478,287,34,1176,336,481;33;M
85875;1652,765,1329,819,1176,1111,959,203,1170,478,34,47,517,336;38;F
85876;926,1170,1176,1111,478,287,524,47,517,336;64;F
85878;270,946,46,34,765,766,1170,1111,478,781,759,287,19,517,1176;16;F
85896;269,270,271,336,926;53;M
85933;517;43;F
86000;926,979,336,517,535,287,759,478,101,1176,1170,1111,524,1092;52;F
86051;135,239,101,31,287,34,47,926;33;F
86058;46,483,148,287,34,524,979,481,336,101,946,270,269,271,19;51;M
86097;1176,478,271,287,19,235,336,481,958,34,1092,517,1170,269,1111;39;F
86129;766,46,203,481,269,236,1111,271,765,525,148,336,926;53;F
86134;270,271,781,148,19,570,101,1176,1111,287,34,765,481,517,336;43;M
86156;270,969,271,1652,1303,819,979;40;F
86160;1652,148;68;M
86173;220,236,1652,525,270,271,269;11;F
86224;478,34,336,926;30;M
86228;270,271,287,956,34,19,524,47,336,481,269;31;F
86368;46,525,203,216,979,926,816,535,524,1329,948,101,956,1303,570;55;F
86378;767,135,481,31,948,19,711,926,958,946,287,765,524,525,570;36;F
86457;46,1111,236,946,270,1176,102,478,759,287,21,524,1092,535,517;64;F
86460;34,525,336,135;45;F
86653;270,271,31,148,34,19,524,47,819,535,336,979,481,958,269;11;M
86672;271,287,19;34;F
86678;483,287,34;30;F
86729;1111,271,19,269;34;M
86801;1092,47,948,270,101,271,31,148,34,19,524,819,481,958,269;9;F
86829;287,524,203,525,47,481,958,237,478,148,34,765,336,926,979;27;F
86857;759,237,102,816,101,478,46,524,525,219,47,1092,570,926,216;45;F
86953;766,19;45;F
87095;220,270,767,271,956,287,34,765,19,1329,819,570,481,269,135;32;F
87174;220,201,102,236,478,46,34,21,524,525,47,203,481,483,135;65;F
87176;766,765,946,767,781,948,1652,1303,1329,47,816,535,336,926,135;62;F
87196;336,203,220,101,1176,1170,1111,478,767,271,948,287,34,1303,525;28;M
87231;148,1329,525,478,336;33;M
87288;220,946,948;43;F
87299;765,819,336,926,958,269,1176,1170,1111,478,148,287,34,517,481;44;M
87380;101,201,102,236,1111,781,759,765,19,570,336,203,481,958,216;75;F
87430;31,148,287,34,336,926,269,969,524,1092,570,101,759,1303,819;43;F
87483;766,236,517,336,926,483,946,1111,478,767,781,948,287,34,135;46;F
87527;946,236,31,46,235,47,481;57;M
87538;766,1176,1170,1111,959,478,781,759,287,1329,524,1092,535,517,926;45;F
87549;1170,47,525,269,236,711,1176,478,765,819,135,270,766,271,336;33;F
87550;287,269,239,236,271,148,34,47,819,336,979,481,958,237,216;33;F
87608;271;38;M
87670;1176,1170,1111,478,148,287,34,135;34;M
87699;101,148,759,287,34,524,47,1092,570,336,481,237;36;F
87700;271;9;M
87732;271;6;F
87768;287,148;64;F
87867;478,148;67;M
87893;216,34,759,236,270,766,102,478,781,287,21,1329,336,926,483;55;M
87909;239,220,236,237,946,767,948;46;M
87928;270,271,148,34,819,269;33;M
87939;1111,1176,958,946,271,287,34,765,19,819,517,336,203,481,135;33;M
87955;239,270,766,1176,1170,1111,478,781,287,34,525,816,517,336,481;37;M
87956;21,478,236,34,1329,336,216,102,1652,287,946,767,948,926,135;13;F
87961;946,236,478,34,819,517,336;80;F
88115;767,948,765,216,135;51;F
88131;1329,481,216,270,766,1176,1170,102,478,781,287,34,21,926,483;21;F
88138;946,525,478,270,269,203,201,102,1652,216;16;F
88214;19;34;M
88280;148,959,236,201,101,766,19,524,926,481,1111,759,287,47,336;42;M
88326;483,517,816,1092,969,1170,946,959,767,926,1111,781,287,524,336;34;M
88344;271,478,969,101,270,34,524,1092,517,203,269,135;39;F
88489;478,1329,216;50;M
88504;271,31,781,148,956,34,765,19,1329,819,517,926,481,958,135;33;M
88630;759,287,570,135,765,19,767,271,481,1176,1111,948,1092,819,269;44;M
88677;269,481,287,478,1111,1170,1176,270,135;38;F
88684;102,781,956,21,481;40;M
88803;946,1176,766,270,1170,1111,478,781,287,34,19,819,336,481,958;27;M
88809;948,819,517,336,711,269,766,946,1176,287,34,524,926,481,958;31;M
88846;781,287,34,21,19,219,47,1092,819,517,336,926,979,481,269;44;M
88853;19;34;F
88858;102,236,781,46,34,21,765,1329,525,816,711,216;73;M
88898;336,1111,969,1176,946,525,219,819,237,483,236,287,1329,47,203;40;F
88937;969,236,959,956,1303,525,47,819,203,481,958;38;M
88948;46,287,34,336;31;F
88983;781,287,34,1329,19,47,816,481,478,1111,236,1170,1176,819,216;47;M
89049;517,766,270,102,1111,271,781,148,287,34,19,819,336,269,483;45;F
89129;336,926,481,19,287,271,270,148,269;38;M
89134;216,483,1176,478,781,336,481,287,34,21,765,1303,1329,47,926;40;M
89154;270,271,148,269;11;M
89201;34,19,1176,1170,1111,478,819,517;39;M
89230;270,271,148,269;53;M
89240;1092,235,148,1111,478,31,759,34,1303,216,483,287,19,47,525;40;F
89287;711,1329,524,525,570,203;74;F
89323;959,1176,1170,236,1111,478,287,34,19,235,1329,47,819,816,216;43;F
89365;148,287;29;F
89385;271,148,1303,269,203,336;25;F
89417;34,1303,524,216,236,102,31,148,956,235,1329,525,219,570,203;31;M
89426;767,271,781,148,19,525,219,570,203,766,946,948,34,765,336;44;M
89429;1303,235,219,816,958,819,570,201,478,524,525,203,481,483,135;33;M
89433;135;48;F
89448;478,767,271,781,948,287,34,19,570,203,958,483;13;M
89519;926;55;F
89550;148,31,969,201,220,101,287,524,219,47,1092,816,336,203,979;32;F
89596;478,767,271,781,948,287,34,19,570,203,958,483;8;M
89701;19,1176,816,979,101,1170,102,959,46,21,47,819,336,958,269;49;F
89719;946,767,31,759,948,21,765,1303,524,570,336,926,711,203,135;35;F
89733;948,216,781,767,236,1176,946,819,34,765,816,336,481,958,287;42;M
89778;236,148,336,237,34,765,1303,201,478,524,525,203,481,483,135;58;F
89816;765,1111,766;37;M
89830;766,946,148,759,1176,1111,287,47;21;F
90009;765,1303,19,525,819,816,535,517,336,203,481,958,269,216,483;32;F
90016;946,767,948;40;M
90028;1303,969,1176,946,287,34,525,1092,570,336;39;F
90045;1111,31,46,148,287,765,19,1329,524,525,47,517,570,336,481;50;F
90117;781,101,236,1111,46,148,759,481,269,102,287,21,524,47,336;45;F
90170;236,1111,219,765,1176,946,336;46;M
90172;1303,1111,525,816,287,946,1176,102,236;28;F
90228;336,535,1092,525,19,1652,148,34,1176,1170,481,483;48;M
90348;19,148,21,47,570,958,946,1176,102,767,948,765,135,287,34;40;F
90363;781,21,19,336,958,478,1176,1170,959,1111,148,287,34,517,481;18;M
90368;34,336,958,481,269;43;M
90417;481,483;48;F
90437;478,766,101,287,34,524,47,336,926,203,483;31;F
90441;958,21,1176,1170,1111,959,478,781,148,287,34,19,517,336,481;48;F
90459;1176,1111,46,525,219,570,203,481;74;F
90475;946,46,517,481,236,781,34,819,926;42;M
90485;21,524,219,517,711,203,481,483,766,1176,1170,102,1111,287,926;19;M
90529;1176,1170,1111,959,478,781,148,287,34,21,19,517,336,481,958;53;M
90559;781,47,102,46;72;M
90587;946,236,781,46,34,819,517,926,481;8;M
90599;946,236,31,46,235,47,481;55;F
90609;946,236,781,46,34,819,517,926,481;13;F
90612;47,46;39;M
90618;946,236,781,46,34,819,517,926,481;40;F
90647;239,236,959,767,271,31,948,19,336,926,958,781,1652,34,47;39;F
90722;478,287;58;F
90779;270,969,236,478,781,219,336,979,1170,1111,1652,287,524,47,517;45;F
90822;1329,819,203,946,1176,1170,478,31,759,287,34,517,336,926,481;37;F
90850;969,1652,34,1303,47,711,237;39;F
90881;34,765,1329,525,1092,483,336,524,19,1652,46,1111,1176,946,781;45;F
90917;269,926,570,1092,524,1303,1652,948,271,767,969,101,956,819,816;40;F
91004;478,979,216,958,203,926,535,816,47,525,524,1329,19,765,287;34;F
91039;34,1176,236,781,525,47,711,216,765,336,926,481,135,478,287;45;F
91050;1329,524,203,481,767,766,946,948,287,34,765,1303,570,926,135;36;F
91097;47,1176,271,1652;42;M
91196;1092,481,216,201,959,270,269,271,336;47;M
91198;270,201,959,271,1092,336,481,269,216;45;F
91247;766,101,1176,1170,478,31,759,287,956,1303,524,1092,570,926,979;17;F
91255;766,1176,1170,102,1111,287,483,926;23;M
91309;220,781,46,148,34,47,517,336;36;F
91432;478,1111,287,34,219,570,979,220,239,46,765,525,336,926,203;36;M
91457;1176,148,34,1303,1092,711,766,1170,1111,478,781,287,765,19,517;39;M
91650;1111,478,46,926,203,481,102,287,21,135;29;F
91652;237,483,336,524,235,1303,34,959,102,287,21,47,819,570,958;34;F
91696;1111,478,759,948,287,34,524,525,47,816,517,570,336,979,481;67;F
91746;1652,47,926,269;35;F
91757;239;17;F
91771;31;83;F
91784;766,270,1170,478,517,483,946,1176,236,1111,148,287,34,336,216;31;M
91840;481,483,1176,1170,1111,781,1303,336;33;M
91847;239,1652,47,926;12;M
91872;481,926,219,525,524,767,1170,1176,946,1111,781,148,34,19,336;40;M
91881;781,765,524,47,269,287,34,816,570,336;38;M
91892;270,1111,959,767,271,31,948,1652,21,19,47,819,711,958,269;68;F
91894;517,287,135;25;F
91915;1176,1111,271,948,148,287,21,765,524,47,517,481,216,336,34;32;M
91924;946,101,767,759,948,34,765,19,524,47,819,570,336,926,135;9;M
91954;570,524,759,31,1329,47,1092,816,926,711,203;61;F
91996;478,1329,517,979,481,216,483,766,1111,47,336,926,236,969,287;36;F
92034;946,101,236,767,948,34,765,524,47,819,570,336,926,135;11;M
92038;1170,236,1111,31,759,287,34,524,525,219,517,570,336,926,203;38;F
92083;239;61;F
92117;239,1652,524,47,926;9;F
92141;946,239,101,759,948,34,765,19,524,47,819,570,336,926,135;43;M
92207;101,236,767,948,34,765,19,524,47,1092,819,336,926,203,135;71;F
92234;31,34,1329,816,819,517,336,269,1176,1170,1111,781,47,481,759;50;F
92254;946,969,711,481,948,31,767,101,478,287,956,34,1329,524,926;32;F
92280;481,517,1176,34,765,19,1329,336,958,216,1111,478,781,148,287;59;M
92291;46,959,956,1329,979,535,203;47;M
92331;203,481,102,766,101,1176,1170,236,1111,478,287,524,336,926;30;F
92434;946,203,220,239,287,34,524,525,336,481;29;F
92471;759,781,478,102,239,101,969,959,1652,34,524,47,1092,336,926;45;F
92481;101,956,524,819,711,270,946,102,271,948,1652,1303,570,926,269;39;M
92529;1176,1170,1111,478,148,287,34,21,19,816,336;42;M
92555;34,336,481;38;M
92565;1652,34,926;40;M
92591;203;46;M
92624;816;39;M
92642;287,956,19,525,926,236,34,336;42;F
92655;31,478,525,926,711;29;F
92660;101,270,102,271,148,759,287,34,19,524,47,535,336,203,269;41;F
92665;767,148,235,1329,478,1111,1176,270,19,525,336,926,481,34,287;32;F
92697;478,1092,517,270,1176,1170,1111,271,287,34,524,481,269;49;F
92713;47,956,269,237,235,19,1303,239,236,959,31,271,759,135,819;6;F
92729;270,1170,236,767,271,148,46,946,969,1111,478,1652,287,517,135;8;M
92754;336,1170,1111;43;M
92774;766,946,1176,1170,1111,478,781,287,34,765,517,336;72;F
92813;946,102,478,948,287,21,765,47,336,269,237;17;F
92832;34,765,235,819,926,269,481,958,135,959,236,946,766,956,336;40;F
92853;336,481,483;40;F
92879;766,946,767,781,948,525,570,336;48;M
92947;271,31,956,34,1303,19,235,219,47,1092,819,203,135,269,481;2;F
93028;101,31,148,759,235,524,47,1092,816,535,336,926,203,1176,1170;35;F
93051;759,1652,287,34,1329,524,47,1092,336,926,979,958,216,237,236;41;F
93063;481;88;F
93074;524,1092,570,711,979,766,1176,148,336,958,483,287,781,946,767;33;M
93076;239,220,47,19,287,959,767,21,235,958,102,31,148,956,711;34;M
93128;46,271,239,946,270,236,1111,525,517,570,481,958,216,269,237;4;F
93263;946,102,236,959,478,767,948,21,765,524,47,336,237,269;45;F
93285;819;43;M
93297;946,239,767,781,948,287,765,47,336,135;34;F
93314;31,759,34,19,570,336,711,203,979,958,237,781,219,47,1092;48;M
93352;517,34,287,948,781,271,767,1111,236,1170,1176,946;48;M
93468;969,478,31,287,34,19,1329,47,336;51;M
93548;959,235,1092,269,287,236,271,781,34,270,336,926,711;47;M
93559;1111,1170,1176,270,34,336,483,236,46,287,235,219,481,237,216;33;M
93626;979,926,21,287,781,239,101,271,819,517;37;F
93672;270,946,1170,148,34,19,336,269,1111,271,31,287,524,525,570;37;M
93729;201,478,481,483;50;F
93763;478,287,21,47,517,216,1176,1170;43;F
93769;203,478,46,21,926,946,239,1176,102,1111,31,287,525,47,336;26;F
93773;1111;18;M
93774;481,216,135,1170,1176,270,766,1111,269,483,287,34,235,47,336;42;F
93782;958,711,269,216,483,135,47,517,956,1303,34,1329,816,926,481;34;M
93815;483,336,524,478,102,1170,1176;28;M
93847;336,926,216,102,287,21;28;M
94027;766,101,236,478,767,31,1652,287,34,765,524,926,979,958,135;39;F
94092;239,1176,969,271,287,34,19,1092,816,535,517,336,958,269,135;36;F
94129;270,1176,1170,148,19,946,766,1111,478,287,34,336,926,481,958;28;M
94196;766,1176,1170,1111,336,478,287;27;F
94231;34,287,1652,535,101,926;50;F
94250;287,524,816,517,979,766,1111,148,34,765,1329,336,926,711,481;19;M
94287;1303,19,525,570,203,237,287,34,524,47,816,478,135,336,781;41;F
94321;46,102,1176,946,766,101,1170,1111,478,148,287,34,765,336,517;20;F
94333;216,570,525,102,236,1111,287,47,1092;59;F
94335;481,483;70;F
94374;1170,1176,101,946,270,766,34,524,47,816,336,216,1111,478,287;39;F
94438;1092,31,956,34,926,711,481;35;M
94596;34,946,767,948;48;M
94649;219,203,19,481,34,287;24;M
94652;969,236,31,287,1303,47,336,926,101,478,524,711,979;39;F
94680;135,481,1092,524,1329,19,1303,819;8;M
94686;525,946,481,203,220,1176,236,1111,1170,478,781,287,483,34,1303;18;F
94753;34,287,781,478,969,1170,1176,101,1111,21,1329,535,926,979,481;55;F
94790;201,478,148,524,525,203,481,135,483;71;M
94816;19,1111,481,483;51;M
94878;201,478,148,524,525,203,481,135,483;85;M
94936;216,483,524,21,220,101,236,1111,287,34,1303,1329,19,1092,481;41;F
94964;478,524,1092,517,481,135;71;F
94980;239;45;F
95085;201,478,148,524,525,203,481,483,135;77;F
95096;1111,478,1329,336,711,481,287;25;F
95125;478,236,767,948,34;47;F
95165;201,478,148,524,525,203,481,483,135;76;M
95167;765,269,483,766,270,1176,1170,1111,478,148,287,517,336,926,481;31;F
95174;525,958,946,239,287,959,102,19,47,816,336;33;F
95187;270,271,481,483,269;14;F
95257;336,979,216,535,816,524,759,101,102,236,148,287,21,47,237;24;F
95304;135,287,34;33;F
95420;19;22;M
95436;216,956,287,1652,759,46,31,478,236,34,816,336,203,237,135;35;F
95497;1303,525,336,765,1176,270,766,483,1111,478,148,287,34;38;F
95504;926,237,216,31,781,21,816,535,336,220,102,969,47;12;F
95582;478,287,765,525,47,570,336,203,481,216,34;35;F
95617;946,101,478,287,956,535,336,926,711,203,979,135;80;M
95686;203;36;F
95742;979,216,766,1170,781,34,483,270,1176,478,287,517,336,481,201;34;M
95780;201,1176,101,270,220,766,946,239,31,781,287,34,19,336,979;34;F
95871;759,148,766,220,270,1176,1170,102,478,287,34,21,19,336,926;39;M
95925;287,34,336;26;M
96016;269,481,203,517,19,765,21,287,948,959,1170,1176,946,767,958;22;M
96086;235,781,148,765,336,570,47,219,525,1303,956,270,269,271,31;44;F
96186;46,239,1176,236,1111,287,34,47,1092,517,336,979,481,958,269;37;F
96205;1111,19,767,946,948,525,336,481,958;32;M
96257;1176,1170,478,781,287,34,1329,524,525,816,336,711,926,481,483;31;M
96268;979,570,21,102,946,766,270,1176,1170,1111,478,287,711,926,517;31;F
96305;946,948,765,336,926,481,135;40;M
96328;517,926,481,269,1176,1170,102,1111,478,781,148,287,34,21,524;21;F
96374;1170,1111,287,34,517,336,481,958;45;M
96385;766,102,46,34,219,570,926,135,765,203,287,336,767,948,946;50;F
96461;31,1329,524,570;37;M
96466;525,336,203,979,958,1176,1111,287,956,21,235,47,819,535,481;34;F
96499;102,766,767,946,948,135;42;F
96524;819,1176,1170,1111,781,287,1092,517,926,481,216;45;M
96549;959,478,287,34,765,19,235,958,946,767,948;40;F
96560;767,946,948;36;M
96579;47,535,101,478,31,759,765,1329,524,525,1092,816,570,711,203;67;M
96633;946,236,31,46,235,47,481;8;M
96681;946,767,948;11;F
96701;1652,239,959,271,34,19,235,47,819,336,269,236,1111,956,237;40;F
96729;946,766,270,1111,959,478,287,21,524,535,517,926,979,483,958;23;F
96773;946,767,948;8;M
96775;946,236,31,46,235,47,481;6;F
96823;946,767,948;41;M
96845;34,525,570,148,287,19,203,237,766,236,767,948,765,336,926;44;F
96936;766,270,946,1176,1170,1111,959,478,287,765,517,483;23;M
96940;287,34,336;27;F
96954;237,216,969,220,34,759,1170,101,236,478,31,1092,570,926,711;49;F
96965;1176,1170,148,21,19,1111,478,287,34,517,336;31;F
96969;946,766,1111,478,767,948,287,1329,524,219,535,517,336,926,979;44;F
96972;946,1176,1170,767,781,148,948,34,765,19,1092,570,336,481,979;12;M
97120;101,220,239,201,478,31,287,956,34,1303,235,47,570,336,135;31;F
97122;969,31,759,21,235,926,46,535,203,979,101;36;F
97126;148,1092;49;M
97145;1092,236,1170,1176,766,270,1111,287,1329,524,525,570;69;F
97150;216,31,201,102,236,781,759,34,524,525,219,336,711,203,237;39;M
97177;220,270,101,1170,236,478,31,524,1092,570,926,711,481,237,216;13;M
97191;219,570,819,148,46,959,1170,1111,478,948,525,481,216,483,135;66;M
97195;1176,1111,781,148,1170,478,287,34,19,336;29;M
97211;948,946,767;48;F
97231;979,766,946,478,767,948;44;F
97318;958,19,959,102,946,767,948;45;M
97415;481,958,237,101,1170,236,1111,271,31,46,759,1652,287,235,517;41;F
97430;926,135;38;M
97493;481,47,948,946,969,31,287,570;34;F
97554;102,1170,1176,478,31,46,19,47,535,570,711,203,979,481,958;41;F
97609;766,946,767,948,1652,979;10;F
97617;1176,287,34;32;M
97627;135,959,236,216,946,1170,271,148,948,765,235,525,819,517,336;47;M
97733;766,946,767,948,1652,979;7;F
97736;946,1303,19,816,517,1111,287,336,216;30;M
97813;766,31,959,102,1176,1170,1111,478,287,34,19,524,819,336;35;M
97883;237,336,819,47,235,19,21,34,759,46,31,236,102,1176,239;39;F
97885;766,270,946,201,1111,759,19,524,926,481,958,216,269,483,135;25;M
97902;478,287,34,21,535,336;28;F
97915;946,1176,478,31,287,34,524;33;M
97955;781,34,765,235,524,1092,570,336,926,979,481,958,135;41;F
97960;766,946,959,767,948,979,135;47;M
97985;31,1111,236,102,1170,1176,946,270,46,287,21,19,517,711,481;52;F
98009;287,34,765,926,203;36;M
98075;101,524,570;50;M
98096;102,1111,478,31,759,287,34,21,235,524,336,711,481,237,483;7;F
98111;287;33;M
98163;766,239,101,236,1111,819,958;45;F
98201;766,1176,287,34,336,979,216;28;F
98220;271,948,819,101,287,535,203,481,237,483,31,34,765,570,926;42;F
98249;1170,478,31,956,517,336,481,216,46,201,47,979,525,570;34;F
98281;19,1170,766,946,478,148,483,34,524,47,1092,570,336,481,216;36;F
98283;958,926,336,19,765,34,287,236,1170,1176,135,570,481,237,483;39;F
98337;767,19,525,336,483,766,1176,1111,478,148,34,765,570,481,287;32;F
98376;101,969,781,759,135,34,524,47,1092,535,336,979,958,237,269;34;F
98393;236,478,287,34;31;F
98410;517,135,270,101,236,478,287,34,524,483,819,1176,1170,1111,336;38;F
98441;34,765,816,336,926,979;23;F
98448;766,1176,969,1111,31,781,287,34,19,235,524,1092,517,336,958;37;M
98462;1111;16;F
98472;216,765,148,781,31,236,239,766,270,102,271,956,525,336,269;35;M
98473;765,287;22;F
98521;926,102,765;22;F
98544;101,270,766,1170,1111,478,31,287;32;F
98558;34,235,816,483,216,711,336,47,287,478,236;37;M
98597;201,767,31,948,1303,524,219,203,135;37;F
98610;766,946,478,767,948,287,34,765,47,570,336;37;F
98662;946,1111,767,148,948,287,765,525,517,481,135,270,236,271,269;36;F
98728;1176,1170,1111,767,781,517,979,481,483,478,287,34,524,47,336;26;F
98732;958,478,31,781,287,34,19,235,524,525,237,269,135,483,216;30;F
98771;220,201,236,767,31,759,948,34,1303,203;7;F
98792;1111,287,956,34,765,19,47,517,336,481,958,237,269,216,135;2;F
98800;766,946,969,478,767,948,287,34,765,524,525,47,570,336,135;11;F
98844;766,270,1176,102,1111,478,287,21;34;F
98870;236,1111,478,271,287,34,1329,525,47,819,517,336,926,481,483;58;F
98885;766,946,101,767,948,1652,287,34,765,525,47,816,336,481,135;9;F
98893;220,203,237,979,525,765,34,1652,102,946,767,948,47,336,135;37;F
98896;220,201,767,31,759,34,1303,235,219,203,135;69;F
98919;201,203;62;F
98966;271,781,148,948,525,219,819,816,336,958,269,220,34,1303,203;21;F
98993;46,969,270,926,481,269,483,766,1176,478,236,1111,781,287,34;44;F
99001;220,946,201,236,767,31,759,948,34,1303,235,524,219,203,135;95;F
99006;101,1176,1170,1111,478,287,524,517,958;29;F
99030;1329,287,478,336,481;32;F
99053;766,478,148,34,926,481;32;M
99078;1303,525,219,1092,819,203,237,46,34,765,524,47,535,336,979;37;F
99087;1111;15;F
99104;237,766,1176,1111,236,767,948,34,765,1303,525,47,570,336,203;52;F
99126;759,148,271,767,478,1111,1170,1176,239,946,270,220,816,336,287;39;M
99144;201,478,570;40;F
99216;239;36;M
99235;220,1176,1170,1111,148,948,287,47,517,336;21;F
99251;270,766,101,478,287,34,765,19,524,47,1092,535,336,269,216;55;F
99274;1176,1111,478,287,34;32;F
99289;478,1329,816,926;50;F
99340;517,47,524,478,766,270,1170,483;40;M
99343;711,926,481;28;M
99481;958,926,336,47,19,765,34,287,959,1111,1176;24;M
99550;1111,236,1170,220,766,102,959,524,1092,517,979,481,958,269,216;46;M
99559;1176,1170,1111,46,287,34,21,1329,517,336,926,203,481,216,483;58;M
99568;203,766,236,1176,287,19,946,959,767,948,34,336,926,711,958;12;M
99579;287,956,34,21,765,47,816,570,336,926,203,979,481,216,135;32;F
99699;948,287,956,34,765,19,819,517,336,926,481,958,1176,946,148;34;M
99757;478,781,21,19,481,216,220,1176,1170,31,46,287,1303,517,926;39;F
99778;478,287;34;F
99822;948,946,767,711,478,287,34;40;M
99872;47,979,237,948,759,1170,969,236,711,766,287,21,336,481,216;23;F
99876;271,31,148,948,34,19,1329,819,517,570,336,926,481,958,269;2;F
99907;239,1176,1170,102,767,759,287,34,19,524,525,47,816,336,958;31;M
99910;236,287,958,766,946,1176,959,767,948,34,19,336,926,711,203;14;M
99924;1176,478,287,483,481,47,525,1170,766,1111,148,34,1329,336,926;30;M
99926;478,336,481,216,220,287,21,524,47,816,517,203,135;28;F
99946;570,819,31,34,525,239,236,148,235,47;31;F
99973;483,102,287,946,478,781,948,765,926,135;32;F
99996;101,1170,236,478,287,1303,525,219,47,819,517,711,979,481,216;57;F
100066;1170,478,271,31,148,287,34,19,1329,819,570,926,481,958,269;71;M
100076;1176,1111,759,287,34,1329,525,47,819,517,336,926,216,135,203;26;F
100121;946,948,767;39;M
100131;570,1092,525,271,269;44;M
100164;31,781,34,21,958,46,235,47,336,481;36;M
100186;31,46,816,525,219,1303,478,236,201,1176,220,287,517,979,216;14;F
100207;148,759,765,819,570,203,269;47;F
100216;34,236,478,271,956,819,336,135,517,287,1170,270,481,1111,1176;41;M
100231;481,216,926,819,517,1092,235,1303,1652,287,46,31,1170,1176,220;3;F
100236;781,31,271,478,236,101,239,946,767,948,1652,34;38;F
100259;269,270,271;38;F
100347;478,34,21,236,1652,235,47,102,781,946,767,948;45;F
100350;478,271,31,148,948,34,19,819,517,570,336,926,481,958,269;71;F
100367;21,34,478,47,235,1652,781,236,102,946,767,948;11;F
100420;220,946,101,102,1111,287,21,19,524,47,517,336,203,926,216;18;F
100494;1092,203,216,483,220,766,946,781,148,287,34,816,336,926,481;45;F
100499;946,1170,102,1111,478,148,287,336;27;M
100510;148,19,816,517,926,711;26;F
100511;926,517,819,1092,235,19,1303,21,287,46,31,236,1170,1176,220;11;F
100524;270,271,269;11;M
100542;1170,1176,336,926;37;F
100554;235,236,1111,478,287,336;30;F
100587;524,525,219,517,203,979,216,101,1176,1170,21,1329,711,926,481;29;F
100594;946,220,766,102,236,478,31,765,524,525,47,570,336,203,481;26;F
100605;767,946,948,766,765;47;F
100612;101,236,287,524,47,517,570;38;F
100624;946,102,1111,287,34,21,765,19,524,525,47,816,336,926,481;36;M
100644;946,270,220,766,287,517,101,1176,1170,1111,478,524,926,481,759;28;F
100667;766,1111,959,478,287,336,926,979,958,216;35;M
100673;270,271,269;8;F
100680;765,766;39;M
100748;767,946,948;37;M
100751;270,271,269;40;M
100793;216,47,34,287,478,969,239,1170,1176,236,1111,1652,235,517,926;35;F
100796;47,235,21,34,1652,781,478,236,102,946,767,948;6;M
100844;19,525,148,34,478,135;26;M
100954;535,336,47,524,759,1111,102,1176,101;27;F
101038;216,481,336,1092,525,524,19,765,21,34,287,1176,220,102,148;25;F
101046;478,1176,101,766,481;27;F
101047;287,34,148;26;M
101053;34,765,524,336,203,979,269,216,766,239,102,19,47,481,236;26;F
101078;570,979,481,135,220,34,524,336,926,203,216;31;F
101195;101,1170,270,239,236,47,203,481,269,216,1652,711,287,478,483;27;F
101219;759,101,766,270,102,959,478,781,34,524,47,336,481,269,19;30;F
101239;239,959,478,271,148,759,956,47,336,481,1176,287,34;28;F
101318;478,767,271,148,765,19,525,819,203,481,958,483,287,34,336;33;F
101319;1170,1176,101,102,478,148;28;F
101365;1329,525,203,269,1170,816,524,1303,759,478,517,336,1176,287,21;36;F
101381;483,765,19,34,287,766,101,781,1111,336,148;26;F
101461;767,959,969,101,956,819,47,336,958,271;41;F
101468;1176,946,1170,236,1111,478,781,287,34,19,47,819,816,336,483;36;M
101495;287,21,517,483,1170,478,926,481;42;M
101572;102,271,46,148,759,524,47,269;34;F
101583;767,135;53;M
101589;270,101,102,271,148,759,47,269;37;M
101707;481,926,711,1170,478,287,956,1303,819;61;F
101738;287,19,524,47,926,958,216;28;F
101767;287,1111,1170,766,478;16;F
101784;102,236,148,34,765,1329,336;36;F
101831;148,19,816,481,958,535,525,34,524,135,220,287,926,336,203;26;M
101833;1176,1170,1111,478,287,34,517;40;F
101846;287,19,524,958,1303,239,270,220,101,525,570,336,203;24;F
101856;766,46,287,34,765;42;F
101870;34,711,481,958,1176,525,336,979,31,1652,524,570,926,101,239;40;F
101875;1092,525,219,1111,201,239,766,1176,958,979,203,926,524,287,959;34;F
101876;19,946,135,269,926,517,819,524,34,287,948,31,271,767,478;31;F
101887;1111,148,287,21,765,19,336,481;40;M
101911;959,21,525,219,570,203,336;41;M
101920;219,19,525,1176,1170,1111,478,781,948,34,336,203,979,481,958;13;F
101926;287,336,481,483;24;F
101941;101,767,31,148,287,19,336,481,958,269,135;27;M
101987;1170,236,1111,31,287,34,517,336;36;M
101993;219,816,570,481,216,483,102,478,34,765,524,336,926,203,979;35;F
102003;46,287,47,570,336;32;F
102013;946,767,948,765;11;F
102079;946,765,236,31,287,34,19,1329,524,525,219,47,570,336,203;28;M
102087;287,759,478,1111,148,46,271,767,766,946,1176,236,765,525,336;36;F
102088;478,781,34,765,19,524,336;36;M
102091;926,517,148,1170,766,270,1176,1111,478,781,287,524,47,336,979;29;F
102119;524,481,216,102,236,1111,46,21,1092,816,535,570,926,711,979;35;F
102137;946,1176,1111,478,148,287,765,816;34;M
102150;765,34,287,1652,478,1176,270,766,958,711,102,239,31,235,524;32;M
102180;478,287,34,524,926;33;M
102184;235,524,47,535,517,336,239;32;F
102203;1111,21,1092,336,926;42;F
102204;570,219,759,959,478,102,1111,287,34,21,1329,524,525,926,481;38;M
102271;102,203,926,946,1176,969,236,1111,31,46,287,47;23;F
102283;781,287,765,336;15;F
102309;948,956,819,926,271,47,781,148,765;31;F
102337;219,819,535,979,958,216,269,220,1111,287,47,517,336,926,481;32;F
102362;1092,239,1652,525,203,269,220,236,959,46,219,926,481,237,216;34;F
102380;766,1092,926,711,269,135;59;F
102400;201,1170,478,31,759,481,47,336,237,216,236,1111,959,287,34;40;F
102441;46,47;43;F
102460;766,1176,478,31,287,570;52;M
102471;148;40;F
102475;235,19,287,1652,759,781,478,236,1176,270,271,148,34,336,269;42;F
102489;236,34,21,1092,216,926;49;F
102492;1111,781,19,525,481,958,216,483,101,478,148,287,34,47,336;36;F
102501;220,101,959,478,781,287,34,19,235,524,47;27;F
102511;956,711,1303,819;61;M
102514;31,236,270,201,46,287,819,203,481,237,220,1111,478,517,979;42;F
102523;287,236,270,271,46,19,819,336;49;F
102550;270,31,781,948,819,816,535,239;46;F
102576;481,483;64;F
102642;239;30;F
102661;1176,236,478,781,287,34,765,525,219,517,336,203,958,216,135;76;F
102686;948,1329,767,711,34,926,287;33;F
102705;31,759,287,525,47,481,958,946,478,767,948,34,765,336,135;34;F
102725;1111,19,524,47,517,481,958,269;31;F
102744;1111,287,19;29;M
102762;336;22;M
102798;101,1176,1170,969,1111,478,31,287,956,34,524,47,816,336,926;40;M
102805;1092,524,235,956,287,759,101,239,1329,47,535,336,979,958,216;31;F
102822;481,483;63;M
102827;767;48;M
102829;946,1176,1170,1111,478,148,287,34;32;M
102832;102,781,524,47,816,535,336,979,216,270,101,1176,478,517,481;42;F
102895;287,34,765,47,816,336,481,135;31;F
102907;102,525,203,958;37;M
102977;102,239,101,1111,959,31,148,34,21,336,926,711,979,958,216;29;M
102995;759,525,535,926,481,201,1111,478,287,34,47,816,979,958,216;35;F
103052;269,979,101,1176,102,287,524,517,1170,1111,478,34,525,47,481;47;F
103069;766,236,478,781,287,34,765,19,525,219,336,203,481,216,135;75;M
103165;135,478,517,1111,287,34,336;38;F
103231;766,1176,1170,102,1111,478,781,287,34,21,517,336,979,481,483;33;F
103236;478,1111,1170,1176,101,270,220,946,236,287,765,525,219,47,203;45;F
103261;767;71;F
103276;766,1176,1170,1111,478,271,148,287,34,765,19,524,481;26;M
103296;220,524,525,47,203,979,237,216,101,102;26;F
103325;287,759,478,1652,481,47;46;F
103356;946,959,34,19,816,336,481,958;33;M
103379;1303,34,46,1176,1111,287;31;F
103409;1176,1170,1111,478,34,19,1329,524,47,517,336,481,483;27;F
103425;478,31,781,287,34,1329,570,926,216,336;42;M
103433;336,1092,781,216,237,535,524,19,34,478,1170,1176,101,201,203;38;M
103443;481,483,766,1176,1170,1111,478,287,34,765,19,517;35;M
103497;148,34,1092,570,926,336;54;M
103510;524,926,979,766,946,1176,1111,959,478,148;23;M
103613;781,287,926,216,478,517,336;30;M
103631;270,1111,271,958,269;40;M
103634;102,478,287,524,47,535,336;27;F
103692;766,781,34,765,1329,1092,926,336;27;F
103724;956,34,816,203,483,766,1652,19,1329,1092,336,926,711,481,958;35;M
103776;34,287,46,781,959,236,1176,946,270,219,570,926,711,203,216;44;M
103816;1303,765,21,766,1176,1170,1111,478,148,287,34,19,517,336;35;M
103818;948,1329,926,135,236,1111,478,525,481,287,34,19,570,336,148;33;M
103846;216,237,958,481,979,570,1092,524,766,102,236,959,478,287,21;29;F
103895;483,1170,1111,148,287,19,336,478,270,271,34,517,926,1176,269;19;M
103937;34,524,1092,926,481,958;41;F
103940;203,926,336,570,1092,524,34,287,478,236,969,1170,1176,101,766;21;F
103944;216,1176,102,236,478,781,46,21,19,525,47,336,926,203,481;56;F
104037;34,765,47,570,203,958,926,1111,287,19,525,819,535,517,336;35;F
104050;135,34,816,570,237,236,271,19,336,269,959,46,219,481,958;45;M
104065;101,1176,1170,478,287,524,517,481,1111;39;M
104117;269,1170,524,1176,1111,31,46,219,517,203,483,287,336,235,1329;6;F
104134;483,766,270,1176,1170,1111,478,148,287,34,1329,47,517,336,926;44;M
104156;236,201,946,220,766,1176,1170,1111,478,287,34,19,47,336,203;35;F
104170;570,1111,236,1170,220,766,946,1176,478,287,34,765,1329,47,336;26;F
104183;478;38;F
104186;926,517,34,287,959,236,766,220,219,47,336,979,481,269,216;33;F
104209;148;28;M
104241;766,270,101,1176,1170,1111,478,759,287;31;F
104265;959,958;43;M
104277;926,958,21,956,759,31,1092,336,711,481,483,102,478,34,287;37;M
104289;336,135;55;F
104320;1170,781,926,481,1111,1176;38;M
104381;1176,102,1111,959,271,148,948,21,19,47,336,926,481,216,269;37;M
104383;1170,236,1111,287,34,19,47,517,336,481,958;54;F
104421;1176,1170,1111,478,759,287,34,524,47,1092,535,517,336,979,481;49;F
104426;148,19,336;53;F
104514;34,478,959,19,926;49;M
104524;239,220,236,759,34,765,1303,235,47,816,336,203,979,237,216;20;F
104529;946,201,102,236,1111,781,46,34,19,926;23;F
104545;1303,819,101,1176,1170,969,1111,478,31,287,34,524,816,336,926;38;F
104562;101,1176,1170,969,1111,478,31,287,34,1303,524,819,816,336,926;8;M
104598;1176,1170,1111,31,46,1329,524,525,219,517,336,203,483,269;4;M
104600;203,1303,219,481,287,948,148,767,1111,946,34,765,525,816,336;27;F
104604;236,959,767,781,759,287,765,1329,524,570,926,711,203,958,216;71;M
104639;711,21,524,525,237,216,102,148,483,781,46,1652,287,19,926;49;F
104715;1329,483,481,711,926,336,517,570,47,524,34,287,148,478,1111;37;F
104746;1111,34,19;28;F
104758;816,1176,1111,959,781,287,47,819,517,336,958;35;F
104822;235,21,101,220,1176,1170,1111,1652,287,34,524,47,517;44;F
104863;525,1329,46,236,220,101,102,21,524,535,570,203,979,237,216;46;F
104890;1176,1170,1111,31,46,1329,524,525,219,517,336,203,269,483;39;M
104946;47,759,979,481;23;F
104958;766,781,148,287,34,19,336,926,958,271,478,270,269;40;M
105019;287,478,101,969,271,781,19,524,1092,535,926,711,979,216,47;72;M
105050;1170,1111,478,287,956,570,34,236,336,767;40;M
105054;711,483,270,102,236,478,781,759,287,34,21,1329,926,979,481;71;F
105073;101,1176,1111,959,535,481,958,148,287,34,524,1092,336;29;M
105144;946,767,948,34,336,926,135;39;M
105175;781,34,946,1111,759,287,956,21,524,336,926,203,481,958,269;34;M
105205;525,1111,236,1176,765,19,216,148,478,287,34,47,819,517,336;59;F
105208;336,767,959,958;44;F
105312;34,926,237,481,216,1176,1170,236,1111,148,1652,287,21,525,336;41;F
105344;236,220,1176,1111,148,287,34,19,525,336,216;20;M
105353;1303,766,102,969,31,148,765,524,525,1092,816,570;71;F
105359;958,216,483,517,816,19,781,1176,481,269,1170,478,1111,287,336;34;M
105428;766,946,767,948,287,34,765,135;42;M
105461;524,481,269,1176,946,270,483,766,1170,1111,287,34,517;47;F
105490;766,1170,21,819,481,1176,236,1111,959,781,34,765,19,517,958;45;F
105550;239,270,102,969,236,46,525,47,979,135,959,21,235,336,481;34;M
105638;201,239,19,235,1329,524,525,219,47,535,481,958,216,102,101;33;M
105668;1170,1176,101,239,220,46,287,21,47,819,336,979,481;41;F
105681;1111,478,287,34,525,570,336;34;F
105683;535,517,481,979,958,237,216,781,478,236,220,239,34,21,47;33;F
105702;287,19,517,711,216,483,766,946,101,236,767,948,765,336,926;17;F
105759;946,101,1176,1170,1111,271,759,287,765,1329,819,570,711,481,483;72;M
105806;946,101,1176,1111,959,287,34,19,47,816,517,336,481,958,269;50;M
105828;287,34,21,235,1329,525,47,819,816,570,926,979,481,237,216;37;M
105843;478,236,946,220,1176,1170,1111,781,148,34,765,336,203,481,216;31;F
105865;34,1170,1111,478,148,287,956,1329,525,517,336,926,711,481,483;39;M
105878;483,216,287,816;36;M
105880;34,270,483,525,765,148,766,336,926,287,1111,1170,478,1176,517;30;F
105942;781,1329,525,711,1652,19,524,926;52;F
105958;135,270,271,269,946,767,948;38;M
105960;517,101,102,926,766,270,946,1176,1170,1111,478,287,525,336,216;41;F
106008;46,148,19,135,481,34,287,336,220,1111,765,1303,525,219,203;24;F
106072;1176,1170,287,525,517,926,203,481,269;27;M
106136;946,239,767,948,34,47,1092,336,926;52;F
106188;711,481,766,1176,1170,759,1652,287,956,525,517,979,958,19,524;44;F
106199;781,478,1176,287,148,1111,946,220,34,765,1303,525,926,203,216;20;F
106224;816,102,46,19,517,570,336;49;M
106228;816,135;51;M
106269;270,271,269;39;F
106334;1111,271,148,819,336,203,269;25;F
106364;1092,47,525,524,1652,46,271,478,236,102,946,101,34,535,336;40;F
106449;101,201,102,1111,46,21,19,816,336,926,979;15;F
106451;270,271,269;10;M
106477;1176,102,1111,759,765,517,336,926,483,47,34,287,781,478,148;54;F
106520;765,1176,101,766,926,711,1329,1652,946,767,948;45;F
106561;1170,1111,478,948,287,956,34,765,525,47,517,336,481,483,135;59;F
106618;969,1170,1176,270,239,236,31,781,1652,287,34,235,524,535,336;37;F
106644;969,220,239,236,1652,34,19,336,958;9;M
106664;102,1111,816,336;45;M
106703;203,481,220,101,102,46,759,287,34,21,19,525,816,535,336;47;F
106726;102,271,31,759,1652,956,21,235,47,819,816,336,481,216;39;F
106776;1170,1111,478,287,34,517;35;F
106796;220,270,1176,1170,1111,478,781,46,287,34,765,19,524,47,816;47;F
106806;767,271,781,765,19,1092,819,216,816;35;M
106809;135;36;F
106822;959,236,102,1176,766,34,21,19,524,525,570,336,926,481,216;14;M
106838;235,239,220,525,1303,765,34,46,236,201,219,570,216,203;21;F
106846;1111,34,47,816,336,979,481;50;M
106935;524,1329,34,956,759,781,102,236,478,31,287,235,711,481,216;33;F
106959;946,201,1170,1111,959,478,781,287,34,765,517,336,926,481,269;25;M
106972;47,766,101,535,102,236,1111,478,287,21,517,481,483,1176,1170;66;F
106980;236,478,287,34,570,336;41;M
107001;781,478,969,1176,101,239,102,236,1111,959,956,21,19,47,958;12;F
107015;239,101,102,969,236,31,46,1652,956,524,47,816,979,237,216;6;F
107049;201,239,1111,781,1652,34,765,235,336,203,216,135,946,767,948;37;F
107075;766,570,19,956,948,46,1176,1111,271,781,148,287,34,765,819;38;F
107140;237,216,135;16;M
107146;958,517,19,236,102,1111,148,34,287,336;20;M
107243;816;40;F
107255;201,31,781,287,34,765,1303,19,235,524,525,47,816,336,203;43;F
107261;271,1303,819,203,956,287,31,102,34,524,816,570,336,958,269;32;F
107325;946,31,781,19,525,203;28;F
107331;948,781,767,236,570,336,135;38;F
107363;47,819,336,239,220,216,525,203,236,271,34,517,979,481,269;44;F
107495;235,34,956,271,478,236,1176,239,270,220,946,1170,759,336,237;31;F
107512;220,101,959,478,271,781,148,19,524,926,958,269;19;F
107536;1303,46,979,1176,1170,1111,478,34,19,47,819,517,336,926,481;42;F
107573;239,102,148,287,517,336,269;55;F
107591;946,767,948,1652,135;38;M
107644;948,819,570,135,711,926,1176,1170,1111,287,765,1329,483,336,481;38;M
107658;767;64;F
107680;148,336,517,34,478,270,483,766,1176,1170,1111,287,19,135;35;F
107714;287,148,781,767,959,1111,236,1170,1176,220,201,102,21,535,979;19;F
107747;781,34,765,19,525,481,958;17;M
107756;819,135,271,148,19,47,958,269;34;F
107759;287,478,34,765,1329,203,481,926,101,1652,525,570,270,269,271;28;F
107784;135,958,517,1170,767,1176,1111,478,148,759,287,34,19,524,336;28;F
107791;102,959,956,34,21,19,47,336,958;42;F
107817;759,781,959,1111,767,478,287,34,19,1329,524,525,570,336,926;30;M
107842;979,926,816,21,34,271,959,102,135;43;M
107845;946,759,1329,524,525,816,336,926,203,481,1176,1170,287,1092,517;39;F
107878;478,781,287,1303,235,524,926,1092;36;F
107911;969,239,1176,236,1111,148,287,34,19,819,336,926,203,481,958;62;M
107922;19,235,1329,47,336,781,31,46,759,287,34,525,926,979,481;32;F
107924;570,517,1092,47,525,524,34,287,46,781,478,1111,1170,1176,101;31;F
107930;711,766,220,270,271,781,1652,287,19,524,47,535,979,958,216;8;F
107953;1111,478,948,34,19,525,219,819,517,1176,1170,236,46,759,287;41;M
107973;101,31,287,34,336,711;35;F
107981;239,220,781,287,34,1303,1329,525,47,336,203;51;F
107995;767;64;M
108007;219,958,220,239,956,1303,235,570,711,203,31,34,525,336,287;37;F
108036;1303,1329,524,979,481,101,102,19,235,525,47,816,336,958;45;F
108077;478,219,236,969,101,1329,47,535,979;24;F
108112;1170,478,34,1092,336,926,203,481;44;F
108165;336,203,481,239,236,1111,478,31,781,46,287,570,237,969,816;30;F
108181;220,46,1329,524,525,219,570,203;47;F
108196;946,767,948;11;M
108220;102,1111,148,287,34,19,336;60;M
108297;765,34,287,948,148,781,31,525,47,535,570,336,711,203,979;36;F
108304;946,767,948;9;M
108310;220,201,236,34,219,216,1329,524,525,570,203;13;M
108388;816;51;M
108421;216,101,1170,236,1111,478,31,1652,287,34,235,524,47,1092,819;36;F
108466;237,524,21,948,946,767,31,47;39;F
108491;1111,525,47,816,570,711,481,781,1329,524,926,478,287,34,336;36;F
108523;135,781,766,765;33;M
108572;1170,102,478,287,21,1329,1092,926,711,481;61;F
108578;525,517,570,958,269,766,1111,287,34,21,19,47,816,336,481;32;F
108582;958,135,766,946,201,236,767,148,287,34,765,19,570,336,216;25;F
108587;478,759,34,765,1092,216,287,336,483,525,570,926,948,767,946;38;F
108634;478,926,47,21,34,287,1111,102;52;M
108749;483,216,481,203,926,47,524,287,1111,236;42;F
108812;101,478,287,34,336;34;F
108827;270,946,201,102,236,767,759,948,524,816,570,336,711,237;41;M
108878;220,271,269;37;M
108943;101,201,959,767,765,19,524,336,979;28;M
108967;1303,269,948,271,767,946,535,1652,926,958,711,483,1092,287,819;43;F
109054;19,517,481,483,766,1176,1170,478,148,287,336,926;32;M
109197;946,767,948;66;F
109204;102,759,236,31,781,956,34,21,19,1329,524,979,958,237;11;M
109228;478,46,287,34,524,570,336,926,711,203,481,958,237,269,135;38;F
109236;948,1652,34,765,19,235,525,570,336,926,711,481,958,237,135;9;F
109242;203,216,979,237,946,759,1092,570,239,31,287,34,1329,524;48;M
109295;219,203,1170,1111,34,765,570,216,135,270,101,1176,478,926,1652;37;M
109345;816;49;M
109434;819,203,481,216,946,1176,1170,236,1111,478,148,287,19,517,336;21;F
109464;478,46,759,1652,287,19,570,926,236,959,34,47,819,336,481;36;F
109500;524,34,148,219,1303,46,1111,220,203,781,19,525,336,481,958;38;M
109515;336,926,237,946,1170,236,478,767,759,948,1652,287,34,765,570;8;F
109519;201,235,1329,926,958,483,766,101,478,287,34,19,524,47,336;31;F
109564;481,483;25;M
109593;135,1111,781,34,525,819,816,336,711,203;36;M
109601;946,767,948,135;44;M
109694;969,236,948,19,219,711,203,237,767,34,765,525,570,336,135;38;M
109770;102,21,1303,1170,236,34,517;54;F
109781;1176,1170,1111,478,148,525,47,819,517,336,481,102,236,21,216;54;M
109864;47,819,517,570,979,269,1111,287,34,525,336,203,481,216,236;36;F
109913;517,148,1111,270,766,1176,1170,478,287,34,765,21,19,816,336;33;F
109940;1176,1170,1111,287,47,481;46;F
110122;926,979,946,1111,478,767,948,1652,287,34,235,47,237,336,481;37;F
110200;570,946,201,948,1303,819,816,535,979,269,767,271,1652,969,956;29;F
110238;287,524,47,816;50;F
110241;766,46,570,979,220,1111,816;38;M
110250;767,21,19,219,979,481,237,216,102,31,287,570,926,711,203;37;M
110371;34,46,287;37;F
110389;239,101,102,969,478,759,287,235,1329,47,1092,535,926,979,481;39;F
110390;236,478,816,336,979,216,759,102,148,287;25;M
110481;524,46,34,1303,525,570,336,203,135,1111,1176,766,946,478,287;35;F
110482;524,47,101,34;28;F
110517;336,236,148,216;33;F
110522;1111,287,34,1303,483,766,270,946,1170,478,31,46,525,570,336;34;M
110586;926,34,478,481,336,287;32;F
110621;148,135,203,926,336,1329,525,765,34,19,219,948,767,1176,946;20;F
110642;969,101,239,220,1176,1170,478,781,287,1303,525,219,481,517,203;32;M
110674;958,31,287,956,34,21,1303,19,235,1329,524,570,336,203,481;40;F
110779;336,287;29;M
110791;239,1176,1170,781,759,34,524,517;29;F
110808;767,271,1176,101,946,148,34,1092,819,517,336,481,958,269,216;51;M
110831;220,478,148,1329,203,765,336,926,481,1176,946,270,766,287,1111;20;M
110905;336,979,958,269,216,483,969,102,1170,1176,1111,478,148,287,47;35;F
111041;946,767,271,948,1652,287,1303,1092,819,535,926,711,958,269,483;44;M
111099;1176,1170,270,21,287,478,102,765,1329,524,336,926,481,216,483;55;F
111105;101,1176,1170,148,287,1303,235,524,47,1092,535,336,926,203,958;3;F
111112;287,958,1111;43;M
111150;525;29;F
111154;781,1176,34,1111,1170,236;50;F
111178;239,236,31,1652,956,1303,235,1329,816,535,926,711,979,237,135;41;F
111258;570,819,1329,19,271,781,336,135,236,766,946,767,948,765,1303;40;M
111332;819,816,926,481,216,336,517,219,287,46,478,1111,1176,1170,236;39;F
111370;270,46,766,220,236,19,483,759,1111,478,816,570,1170,525,1092;48;F
111398;781,946,767,271,948,1652,287,1092,819,535,926,711,958,269,483;8;M
111400;101,1176,1170,969,1111,478,31,287,34,1303,524,819,816,336,926;4;M
111449;46,31,220,101,1176,1170,148,759,235,524,47,1092,535,926,203;32;M
111464;101,1176,102,478,759,287,34,1329,524,47,1092,535,926,979,481;39;M
111474;1170,236,1111,959,478,767,31,148,19,47,570,336,979,481,958;7;M
111573;819,525,1170,236,959,478,1111,781,148,287,34,19,336,481,1176;45;F
111608;1170,1111,767,759,819,336,216,135,271,781,46,517,481,34,483;44;M
111611;148,287,1329,525,1176,1111,34,765,19,481;38;M
111634;524,270,767,958,135,959,478,287,235,481,711,570,1092,759,236;47;F
111666;270,101,959,271,31,781,956,34,1303,19,816,336,926,481,269;49;M
111697;948,46,1170,766,517,481,216,336,1176,1111,148,287,34,21,816;15;F
111728;236,1111,271,287,34,524,47,816,336,203,979,958,269,216,135;35;F
111756;767,478,765,481,216;16;M
111761;1329,759,483,481,336,478,969,1176,1170,517,46,1652,525,570,926;37;F
111782;1329,1176,1170,101,102,1111,478,287,34,21,524,525,481,979,269;47;M
111910;483,216,478,287,336,481,1176,1170,1111,236;51;F
111937;1111,31,46,481,269,478,781,287,956,34,19,1092,819,336,958;36;F
111979;47,517,220,239,1176,1170,1111,478,148,287,19,336;29;F
112041;336,203,958,220,101,1176,969,1111,34,47,819;43;M
112044;570,766,959,478,781,948,525,336,481,483,148,765,19,926,958;31;M
112085;148,948,219,203,1176,1170,236,1111,287,525,517,336,481,958,216;43;M
112099;711,1170,1111,478,287,525,1092,517,336,481,483;49;M
112114;816,926,237,239,201,236,781,948,34,524,219,47,819,336,216;13;M
112119;34,287,336;34;M
112128;269,926,570,517,236,102,1170,956,524;35;M
112142;1092,239,236,31,1652,956,1303,235,1329,524,816,926,711,237,135;41;M
112203;759,46,478,239,101,969,236,31,1652,287,19,47,1092,336,135;39;F
112238;766,19,235,47,239,236,34,765,525,135;36;F
112271;781,34,47,819,101,1176,1170,1111,478,287,517,481,135;44;M
112304;239,101,1170,236,1111,959,478,759,287,524,1092,336,979,481;44;F
112310;270,1176,201,1170,236,1111,478,46,759,1329,524,219,336,203,481;69;F
112323;220,271,203,819,201;44;F
112333;46,948,956,524,1092,819,517;49;M
112370;946,767,781,948,34;39;M
112376;236,46,759,765,235,1329,524,1092,819,570,31,34,711,237,216;41;M
112383;34,956,1170,271,767,270,766,239,101,969,236,1111,478,31,287;35;F
112424;1329,34,148,478,766,1111,287;30;F
112464;239,236,31,1652,956,1303,235,1329,524,816,926,711,979,237,135;8;F
112477;946,1176,236,959,287,34,216,269,979,336,481;32;F
112483;46,34,203,481,958,219,926,269,237,524,287,570,336,711,135;10;M
112512;766,765,19,1092,570,926,711,946,767,271,948,1652,819,269,135;9;F
112515;819,517,481,135,19,765,148,101,766,1111,781,34,287,483,336;32;M
112553;287,101,34,19;38;F
112620;19;32;M
112637;19;37;M
112645;239,1092,219,524,759,287,34,1303,525,816,570,336,926,711,203;13;M
112658;220,1176,1170,1111,478,287,525,517,926,203;30;F
112784;239,236,31,1652,956,1303,235,1329,524,816,926,711,979,237,135;6;M
112799;270,1176,1111,478,31,271,46,148,759,287,19,47,336,481,483;49;M
112807;570,1329,478,236,135,819,287,781,271,766,946,767,948,765,1303;10;F
112830;959,34,816,958,216,148;37;F
112857;819,570,948,31,767,946,1176,287,34,926,958,269,765,336,481;27;M
112860;1303;33;F
112929;781,759,1652,524,816,711,958,1329,570,926,237,239,31,47,819;46;F
112963;958,237,239,236,1111,31,287,956,34,21,235,47,517,336,481;30;F
113010;271,958,269;8;M
113015;1176,1170,1111,31,46,1652,287,34,21,235,219,517,336,926,481;45;F
113026;46,287,34,524,219,570,336,926,711,203,481,958,237,269,135;37;M
113061;336,236,148;43;M
113073;236,46,21,47,517,220,1111,31,287,336,237,239,819,481,216;35;M
113096;148,135,483,269,958,481,926,517,765,478,1111,201,1176,235,287;35;M
113130;239,236,31,1652,956,1303,235,1329,524,1092,816,926,711,237,135;2;M
113168;287,478,1111,236,1176,1170,102,781,34,19,336,958,216,47,517;40;F
113169;767,203,481,926,711,979,958,237,269,336,816,525,524,1329,34;45;M
113242;781,524,336,766,1176,1170,1111,46,759,1652,1329,525,570,926,979;6;F
113250;148,19,336,926,203,219,525,1329,765,34,948,767,1176,946,135;55;F
113275;767,781,287,135,216,269,481,336,819,948,271,270,236,765,1303;49;M
113278;271,220,201,203;3;F
113314;46,524,336,926,47;36;M
113355;239,1303,336,481,216,101,236,287,34,524,1092,535,46,148;32;F
113359;270,220,766,19,235,819,946,767,948,765,336,958,216,135;12;M
113372;101,959,948,524,47,481,958,269;36;M
113387;1170,1176,766,1111,478,287,34,1329,926,711,203,979,481,216,483;36;M
113437;1092,239,236,31,1652,956,1303,235,1329,524,816,926,711,237,135;75;F
113446;34,765,525,517,203,979,481,958,483,946,1176,767,759,524,336;37;F
113448;1170,101,148,34,47,336;27;M
113455;235,525,47,816,336,926,203,979,216,946,236,767,948,1303,1092;47;F
113456;135,570,819,525,1329,287,781,271,236,766,946,767,948,765,1303;8;F
113477;483,765,781,270,239,236,34,1329,517,336,711,135,478,47,287;33;M
113488;135,336,525,765,34,148,203,270,271,819,517,287,478,1111,766;41;M
113497;216,269,101,969,271,781,19,524,47,1092,535,926,711,979;44;F
113499;101,766,959,148,948,956,19,525,47,819,517,926,336,203,958;30;M
113517;481,926,765,287,781,478,1111,1170,1176;26;M
113536;1111,478,759,287,34,524,525,570,336,926,711,203,481,483,135;20;M
113650;21,31,236,102,1170,270,766,481,19,1176,1111,478,287,34,336;35;M
113669;1176,271,958,269;5;M
113691;239,34,237,570,1092,524,236,31,759,1329,219,819,926,711,216;6;M
113692;101,102,478,759,34,1303,525,220,1111,781,287,21,765,524,979;30;F
113702;235,287,46,767,236,31,34,19,524,525,517,570,926,203,135;44;F
113727;101,270,102,47,1176,1111,1170,478,21,524,517,135;29;F
113731;1176,1170,46,1111,287,525,517,336;47;M
113741;220,819,271,203,201;9;M
113752;270,269,271;56;M
113754;220,1170,19,525,336,287,1176,481;29;F
113778;517,1176;27;M
113795;239,236,31,1652,956,1303,235,1329,524,816,926,711,979,237,135;73;M
113840;1111,102,1170,1176,101,946,816,570,926,481,237,269,216,336,979;40;M
113858;101,1176,1170,969,1111,478,31,148,759,287,517;39;F
113864;287,478,1111,102,46,759,926,711,203;43;F
113878;236,271,148,34,765,1303,19,525,219,819,816,336,203,481,958;44;F
113925;478,1170,1176,946,781,956,34,524,525,336,926,203,237,216,483;23;F
113949;766,946,1170,1111,31,287,34,765,525,219,570,336,711,203,481;38;M
113983;819,517,203,958,216,483,478,34,765,524,535,570,336,926,711;33;M
114035;969,102,1170,766,236,101,239,946,270,220,517,1176,201,816,216;20;M
114142;270,271,269;16;M
114162;766,1176,236,517,1170,478,287,34,1111,148,21,525,336,926,481;31;F
114163;969,1170,1176,101,524,517,478,1111,287,47,1092,711,926,203,481;50;F
114191;1176,1329,47,336,481,21;24;F
114270;517;10;M
114330;270,271,269;8;F
114364;236,478,148,759,287,34,525,570,336,711,481,483;73;F
114375;31,478,236,766,270,148,765,1329,525,219,535,570,926,203;62;M
114406;102,1111,959,287,34,336;30;F
114424;270,766,946,1176,1170,1111,478,287,525,819,517,926,203,481,958;26;F
114504;570,481,958,483,101,148,524,46,34,535,271,19,47,269,711;45;M
114508;270,271,269;4;M
114573;926,21,948,478,946,767,765,47,336,237,269;48;M
114574;1176,236,148,517;27;F
114597;926,570,819,1329,287,102,1176,1170,1111,781,34,19,517,336,711;44;M
114603;220,46,759,34,765,47,926,481,483,478,1111,1170,1176,101,766;34;F
114646;956,819,766,1170,478,46,1176,1111,781,148,287,34,19,336,481;11;F
114683;270,271,269;46;F
114722;766,946,101,236,781,31,271,767,948,34,765,1329,336,711,135;38;F
114724;101,1176,1170,271,46,759,948,524,47,1092,819,816,535,517,336;44;M
114753;19,216;33;F
114759;517,481,958;38;M
114809;1170,102,959,1329,47,336,1176,236,34,816,958,1111,478,31,287;44;M
114919;47,535,481,216,220,101,46,759,287,525,336,926,711,203,979;27;F
114945;766,781,759,287,34,765,524,336,711,481;;F
115017;46,478,102,946,767,287,21,765,47,336;77;F
115041;239,767,781,34,235,19,816,336,926,237,216,946,201,236,948;31;M
115047;524,979,336;23;F
115053;478,148,759,287,34,525,570,336,926,481,483;74;M
115074;336;36;M
115145;1176,1111,287,34,517;58;F
115150;34,765,524,47,1092,336,926,481;49;F
115237;766,781,759,287,34,765,570,524,336,711,481;30;F
115258;766,946,101,236,781,31,271,767,948,34,765,1329,336,711,135;4;F
115380;19,759,781,478,959,1170,201,239,102,236,34,47,979,216,269;39;F
115388;766,946,101,236,767,781,31,271,948,34,765,1329,336,711,135;2;M
115502;270,235,1303,236,959,478,767,759,524,1092,570,711,481,958,135;20;M
115511;203,270,236,959,47,336,481,1111,271,46,34,19,570,958,269;46;F
115535;766,946,101,236,767,271,31,781,948,34,765,1329,336,711,135;41;M
115541;946,1111,336;29;F
115568;287,148,46,31,478,959,1111,1176,1170,34,524,47,336,926,979;30;F
115572;46,948,287,34,19,47,819,481,239,1176,102,1111,21,524,517;38;F
115584;711,1111,236,478,148,759,287,34,525,570,336,926,481,483;32;F
115632;1170,148,336,481,483,766,270,1176,102,1111,478,287,34,21,517;44;F
115668;1176,1170,1111,959,478,781,1652,287,34,19,819,816,517,336,958;45;F
115716;765,524,525,219,1092,570,135;58;F
115736;287,781,959,236,946,220,767,271,948,34,19,819,336,958,269;36;F
115753;478,781,759,34,19,47,816,517,336,979,958,270,271,1652,269;39;M
115766;270,271,1652,269;11;M
115772;270,271,1652,269;7;M
115936;766,946,101,236,767,271,31,781,948,34,765,1329,336,711,135;;M
115955;135,270,946,102,1111,287,34,19,517,570,336,483;50;M
116017;946,767,948;40;F
116281;1329,711,336,269,270,524,148,570,525,203,271,101;69;F
116282;1329,524,570,525,203;81;F
116284;1329,524,570,525,203;78;F
116285;1092,979,1329,711,478,481,101;77;F
116287;979,535,481,524;65;F
116288;1329,926,711,948,236,524,570,525,203;73;F
116289;979,956,765,948,525,135,31;65;M
116293;926,781,711,765,766,287,478,483,481,135,47,34;61;F
116294;926,781,711,765,766,287,478,483,481,135,47,34;62;M
116295;1329,524,570,525,203;71;F
999999104227;34,19,524,481,216,483,766,946,270,1111,478,781,287,765;31;F